/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.CharsetUtil;
import java.nio.charset.Charset;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class ByteBufUtilBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"true", "false"})
    private boolean direct;
    @Param(value={"8", "16", "64", "128"})
    private int length;
    private ByteBuf buffer;
    private ByteBuf wrapped;
    private ByteBuf asciiBuffer;
    private ByteBuf utf8Buffer;
    private StringBuilder asciiSequence;
    private String ascii;
    private StringBuilder utf8Sequence;
    private String utf8;

    @Setup
    public void setup() {
        int maxBytes = ByteBufUtil.utf8MaxBytes((int)this.length);
        this.buffer = this.direct ? Unpooled.directBuffer((int)maxBytes) : Unpooled.buffer((int)maxBytes);
        this.wrapped = Unpooled.unreleasableBuffer((ByteBuf)(this.direct ? Unpooled.directBuffer((int)maxBytes) : Unpooled.buffer((int)maxBytes)));
        this.asciiSequence = new StringBuilder(this.length);
        for (int i = 0; i < this.length; ++i) {
            this.asciiSequence.append('a');
        }
        this.ascii = this.asciiSequence.toString();
        this.utf8Sequence = new StringBuilder(this.length);
        char[] chars = "Some UTF-8 like \u00e4\u00c4\u220f\u0152\u0152".toCharArray();
        for (int i = 0; i < this.length; ++i) {
            this.utf8Sequence.append(chars[i % chars.length]);
        }
        this.utf8 = this.utf8Sequence.toString();
        this.asciiSequence = this.utf8Sequence;
        this.asciiBuffer = Unpooled.copiedBuffer((CharSequence)this.ascii, (Charset)CharsetUtil.US_ASCII);
        this.utf8Buffer = Unpooled.copiedBuffer((CharSequence)this.utf8, (Charset)CharsetUtil.UTF_8);
    }

    @TearDown
    public void tearDown() {
        this.buffer.release();
        this.wrapped.release();
        this.asciiBuffer.release();
        this.utf8Buffer.release();
    }

    @Benchmark
    public void writeAsciiStringViaArray() {
        this.buffer.resetWriterIndex();
        this.buffer.writeBytes(this.ascii.getBytes(CharsetUtil.US_ASCII));
    }

    @Benchmark
    public void writeAsciiStringViaArrayWrapped() {
        this.wrapped.resetWriterIndex();
        this.wrapped.writeBytes(this.ascii.getBytes(CharsetUtil.US_ASCII));
    }

    @Benchmark
    public void writeAsciiString() {
        this.buffer.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)this.ascii);
    }

    @Benchmark
    public void writeAsciiStringWrapped() {
        this.wrapped.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.wrapped, (CharSequence)this.ascii);
    }

    @Benchmark
    public void writeAsciiViaArray() {
        this.buffer.resetWriterIndex();
        this.buffer.writeBytes(this.asciiSequence.toString().getBytes(CharsetUtil.US_ASCII));
    }

    @Benchmark
    public void writeAsciiViaArrayWrapped() {
        this.wrapped.resetWriterIndex();
        this.wrapped.writeBytes(this.asciiSequence.toString().getBytes(CharsetUtil.US_ASCII));
    }

    @Benchmark
    public void writeAscii() {
        this.buffer.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)this.asciiSequence);
    }

    @Benchmark
    public void writeAsciiWrapped() {
        this.wrapped.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.wrapped, (CharSequence)this.asciiSequence);
    }

    @Benchmark
    public void writeUtf8StringViaArray() {
        this.buffer.resetWriterIndex();
        this.buffer.writeBytes(this.utf8.getBytes(CharsetUtil.UTF_8));
    }

    @Benchmark
    public void writeUtf8StringViaArrayWrapped() {
        this.wrapped.resetWriterIndex();
        this.wrapped.writeBytes(this.utf8.getBytes(CharsetUtil.UTF_8));
    }

    @Benchmark
    public void writeUtf8String() {
        this.buffer.resetWriterIndex();
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)this.utf8);
    }

    @Benchmark
    public void writeUtf8StringWrapped() {
        this.wrapped.resetWriterIndex();
        ByteBufUtil.writeUtf8((ByteBuf)this.wrapped, (CharSequence)this.utf8);
    }

    @Benchmark
    public void writeUtf8ViaArray() {
        this.buffer.resetWriterIndex();
        this.buffer.writeBytes(this.utf8Sequence.toString().getBytes(CharsetUtil.UTF_8));
    }

    @Benchmark
    public void writeUtf8ViaArrayWrapped() {
        this.wrapped.resetWriterIndex();
        this.wrapped.writeBytes(this.utf8Sequence.toString().getBytes(CharsetUtil.UTF_8));
    }

    @Benchmark
    public void writeUtf8() {
        this.buffer.resetWriterIndex();
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)this.utf8Sequence);
    }

    @Benchmark
    public void writeUtf8Wrapped() {
        this.wrapped.resetWriterIndex();
        ByteBufUtil.writeUtf8((ByteBuf)this.wrapped, (CharSequence)this.utf8Sequence);
    }

    @Benchmark
    public String decodeStringAscii() {
        return this.asciiBuffer.toString(CharsetUtil.US_ASCII);
    }

    @Benchmark
    public String decodeStringUtf8() {
        return this.utf8Buffer.toString(CharsetUtil.UTF_8);
    }
}

