/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
public class AdaptiveByteBufAllocatorConcurrentNoCacheBenchmark
extends AbstractMicrobenchmark {
    private static final ByteBufAllocator adaptiveAllocator = new AdaptiveByteBufAllocator(true, false);
    @Param(value={"00064", "00256", "01024", "04096"})
    private int size;

    public AdaptiveByteBufAllocatorConcurrentNoCacheBenchmark() {
        super(true, true);
    }

    @Benchmark
    @Threads(value=32)
    public void allocateReleaseHeapAdaptive(Blackhole blackhole) {
        blackhole.consume(adaptiveAllocator.heapBuffer(this.size).release());
    }

    @Benchmark
    @Threads(value=32)
    public void allocateReleaseDirectAdaptive(Blackhole blackhole) {
        blackhole.consume(adaptiveAllocator.directBuffer(this.size).release());
    }
}

