/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.ArrayList;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
public class CompositeByteBufRandomAccessBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"64", "10240", "1024000"})
    public int size;
    @Param
    public ByteBufType bufferType;
    private ByteBuf buffer;
    private Random random;

    @Setup
    public void setup() {
        this.buffer = this.bufferType.newBuffer(this.size);
        this.random = new Random(0L);
    }

    @TearDown
    public void teardown() {
        this.buffer.release();
    }

    @Benchmark
    public long setGetLong() {
        int i = this.random.nextInt(this.size - 8);
        return this.buffer.setLong(i, 1L).getLong(i);
    }

    @Benchmark
    public ByteBuf setLong() {
        int i = this.random.nextInt(this.size - 8);
        return this.buffer.setLong(i, 1L);
    }

    private static ByteBuf newBufferSmallChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 45 * 19);
        for (int i = 0; i < length + 45; i += 45) {
            for (int j = 1; j <= 9; ++j) {
                buffers.add(Unpooled.EMPTY_BUFFER);
                buffers.add(Unpooled.wrappedBuffer((byte[])new byte[j]));
            }
            buffers.add(Unpooled.EMPTY_BUFFER);
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0]));
        return buffer.capacity(length).writerIndex(0);
    }

    private static ByteBuf newBufferLargeChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 512);
        for (int i = 0; i < length + 1536; i += 1536) {
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[512]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[1024]));
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0]));
        return buffer.capacity(length).writerIndex(0);
    }

    public static enum ByteBufType {
        SMALL_CHUNKS{

            @Override
            ByteBuf newBuffer(int length) {
                return CompositeByteBufRandomAccessBenchmark.newBufferSmallChunks(length);
            }
        }
        ,
        LARGE_CHUNKS{

            @Override
            ByteBuf newBuffer(int length) {
                return CompositeByteBufRandomAccessBenchmark.newBufferLargeChunks(length);
            }
        };


        abstract ByteBuf newBuffer(int var1);
    }
}

