/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.microbench.handler.ssl.AbstractSslHandlerBenchmark;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public abstract class AbstractSslHandlerThroughputBenchmark
extends AbstractSslHandlerBenchmark {
    @Param(value={"64", "128", "512", "1024", "4096"})
    public int messageSize;
    @Param
    public BufferType bufferType;
    protected ByteBuf wrapSrcBuffer;
    protected EmbeddedChannel channel;
    private ByteBufAllocator allocator;

    @Setup(value=Level.Iteration)
    public final void setup() throws Exception {
        this.allocator = new PooledByteBufAllocator(true);
        this.initSslHandlers(this.allocator);
        this.wrapSrcBuffer = this.allocateBuffer(this.messageSize);
        byte[] bytes = new byte[this.messageSize];
        ThreadLocalRandom.current().nextBytes(bytes);
        this.wrapSrcBuffer.writeBytes(bytes);
        this.doHandshake();
    }

    @TearDown(value=Level.Iteration)
    public final void tearDown() throws Exception {
        this.destroySslHandlers();
        this.wrapSrcBuffer.release();
        this.clientCtx.releaseCumulation();
        this.serverCtx.releaseCumulation();
    }

    protected final ByteBuf allocateBuffer(int size) {
        return this.bufferType.newBuffer(this.allocator, size);
    }

    protected final ByteBuf doWrite(int numWrites) throws Exception {
        this.clientCtx.releaseCumulation();
        for (int i = 0; i < numWrites; ++i) {
            ByteBuf wrapSrcBuffer = this.wrapSrcBuffer.retainedSlice();
            this.clientSslHandler.write((ChannelHandlerContext)this.clientCtx, (Object)wrapSrcBuffer, this.clientCtx.voidPromise());
        }
        this.clientSslHandler.flush((ChannelHandlerContext)this.clientCtx);
        return this.clientCtx.cumulation().retainedSlice();
    }

    public static enum BufferType {
        HEAP{

            @Override
            ByteBuf newBuffer(ByteBufAllocator allocator, int size) {
                return allocator.heapBuffer(size);
            }
        }
        ,
        DIRECT{

            @Override
            ByteBuf newBuffer(ByteBufAllocator allocator, int size) {
                return allocator.directBuffer(size);
            }
        };


        abstract ByteBuf newBuffer(ByteBufAllocator var1, int var2);
    }
}

