/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Warmup(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=100, timeUnit=TimeUnit.MILLISECONDS)
@Fork(value=5)
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
public class PooledByteBufAllocatorAlignBenchmark
extends AbstractMicrobenchmark {
    private static final Random rand = new Random();
    private static final int CACHE_LINE_MAX = 256;
    private static final int OFFSET_ADD = 342272;
    private static final int BLOCK = 4;
    @Param(value={"0", "64"})
    private int cacheAlign;
    @Param(value={"01024", "04096", "16384", "65536", "1048576"})
    private int size;
    private ByteBuf pooledDirectBuffer;
    private byte[] bytes;
    private int sizeMask;
    private int alignOffset;

    @Setup
    public void doSetup() {
        PooledByteBufAllocator pooledAllocator = new PooledByteBufAllocator(true, 4, 4, 8192, 11, 0, 0, 0, true, this.cacheAlign);
        this.pooledDirectBuffer = pooledAllocator.directBuffer(this.size + 64);
        this.sizeMask = this.size - 1;
        if (this.cacheAlign == 0) {
            long addr = this.pooledDirectBuffer.memoryAddress();
            if (addr % 64L == 0L) {
                this.alignOffset = 63;
            }
            int off = 0;
            for (int c = 0; c < this.size; ++c) {
                if ((addr + (long)(off = off + 342272 & this.sizeMask) + (long)this.alignOffset) % 4L != 0L) continue;
                throw new IllegalStateException("Misaligned address is not really aligned");
            }
        } else {
            this.alignOffset = 0;
            int off = 0;
            long addr = this.pooledDirectBuffer.memoryAddress();
            for (int c = 0; c < this.size; ++c) {
                if ((addr + (long)(off = off + 342272 & this.sizeMask)) % 4L == 0L) continue;
                throw new IllegalStateException("Aligned address is not really aligned");
            }
        }
        this.bytes = new byte[4];
        rand.nextBytes(this.bytes);
    }

    @TearDown
    public void doTearDown() {
        this.pooledDirectBuffer.release();
    }

    @Benchmark
    public void writeRead() {
        int off = 0;
        int lSize = this.size;
        int lSizeMask = this.sizeMask;
        int lAlignOffset = this.alignOffset;
        for (int i = 0; i < lSize; ++i) {
            off = off + 342272 & lSizeMask;
            this.pooledDirectBuffer.setBytes(off + lAlignOffset, this.bytes);
            this.pooledDirectBuffer.getBytes(off + lAlignOffset, this.bytes);
        }
    }

    @Benchmark
    public void write() {
        int off = 0;
        int lSize = this.size;
        int lSizeMask = this.sizeMask;
        int lAlignOffset = this.alignOffset;
        for (int i = 0; i < lSize; ++i) {
            off = off + 342272 & lSizeMask;
            this.pooledDirectBuffer.setBytes(off + lAlignOffset, this.bytes);
        }
    }

    @Benchmark
    public void read() {
        int off = 0;
        int lSize = this.size;
        int lSizeMask = this.sizeMask;
        int lAlignOffset = this.alignOffset;
        for (int i = 0; i < lSize; ++i) {
            off = off + 342272 & lSizeMask;
            this.pooledDirectBuffer.getBytes(off + lAlignOffset, this.bytes);
        }
    }
}

