/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.MathUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=8)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
public class HttpMethodMapBenchmark
extends AbstractMicrobenchmark {
    private static final Map<String, HttpMethod> OLD_MAP = new HashMap<String, HttpMethod>();
    private static final SimpleStringMap<HttpMethod> NEW_MAP;
    private static final String[] KNOWN_METHODS;
    private static final String[] MIXED_METHODS;
    private static final String[] UNKNOWN_METHODS;

    @Benchmark
    public void oldMapKnownMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < KNOWN_METHODS.length; ++i) {
            bh.consume((Object)OLD_MAP.get(KNOWN_METHODS[i]));
        }
    }

    @Benchmark
    public void newMapKnownMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < KNOWN_METHODS.length; ++i) {
            bh.consume((Object)NEW_MAP.get(KNOWN_METHODS[i]));
        }
    }

    @Benchmark
    public void oldMapMixMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < MIXED_METHODS.length; ++i) {
            HttpMethod method = OLD_MAP.get(MIXED_METHODS[i]);
            if (method == null) continue;
            bh.consume((Object)method);
        }
    }

    @Benchmark
    public void newMapMixMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < MIXED_METHODS.length; ++i) {
            HttpMethod method = NEW_MAP.get(MIXED_METHODS[i]);
            if (method == null) continue;
            bh.consume((Object)method);
        }
    }

    @Benchmark
    public void oldMapUnknownMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < UNKNOWN_METHODS.length; ++i) {
            HttpMethod method = OLD_MAP.get(UNKNOWN_METHODS[i]);
            if (method == null) continue;
            bh.consume((Object)method);
        }
    }

    @Benchmark
    public void newMapUnknownMethods(Blackhole bh) throws Exception {
        for (int i = 0; i < UNKNOWN_METHODS.length; ++i) {
            HttpMethod method = NEW_MAP.get(UNKNOWN_METHODS[i]);
            if (method == null) continue;
            bh.consume((Object)method);
        }
    }

    static {
        KNOWN_METHODS = new String[]{"OPTIONS", "GET", "HEAD", "POST", "PUT", "PATCH", "DELETE", "TRACE", "CONNECT"};
        MIXED_METHODS = new String[]{"OPTIONS", "FAKEMETHOD", "GET", "HEAD", "POST", "UBERGET", "PUT", "PATCH", "MYMETHOD", "DELETE", "TRACE", "CONNECT", "WHATMETHOD"};
        UNKNOWN_METHODS = new String[]{"FAKEMETHOD", "UBERGET", "MYMETHOD", "TESTING", "WHATMETHOD", "UNKNOWN", "FOOBAR"};
        OLD_MAP.put(HttpMethod.OPTIONS.toString(), HttpMethod.OPTIONS);
        OLD_MAP.put(HttpMethod.GET.toString(), HttpMethod.GET);
        OLD_MAP.put(HttpMethod.HEAD.toString(), HttpMethod.HEAD);
        OLD_MAP.put(HttpMethod.POST.toString(), HttpMethod.POST);
        OLD_MAP.put(HttpMethod.PUT.toString(), HttpMethod.PUT);
        OLD_MAP.put(HttpMethod.PATCH.toString(), HttpMethod.PATCH);
        OLD_MAP.put(HttpMethod.DELETE.toString(), HttpMethod.DELETE);
        OLD_MAP.put(HttpMethod.TRACE.toString(), HttpMethod.TRACE);
        OLD_MAP.put(HttpMethod.CONNECT.toString(), HttpMethod.CONNECT);
        NEW_MAP = new SimpleStringMap(new SimpleStringMap.Node<HttpMethod>(HttpMethod.OPTIONS.toString(), HttpMethod.OPTIONS), new SimpleStringMap.Node<HttpMethod>(HttpMethod.GET.toString(), HttpMethod.GET), new SimpleStringMap.Node<HttpMethod>(HttpMethod.HEAD.toString(), HttpMethod.HEAD), new SimpleStringMap.Node<HttpMethod>(HttpMethod.POST.toString(), HttpMethod.POST), new SimpleStringMap.Node<HttpMethod>(HttpMethod.PUT.toString(), HttpMethod.PUT), new SimpleStringMap.Node<HttpMethod>(HttpMethod.PATCH.toString(), HttpMethod.PATCH), new SimpleStringMap.Node<HttpMethod>(HttpMethod.DELETE.toString(), HttpMethod.DELETE), new SimpleStringMap.Node<HttpMethod>(HttpMethod.TRACE.toString(), HttpMethod.TRACE), new SimpleStringMap.Node<HttpMethod>(HttpMethod.CONNECT.toString(), HttpMethod.CONNECT));
    }

    private static final class SimpleStringMap<T> {
        private final Node<T>[] values;
        private final int valuesMask;

        SimpleStringMap(Node<T> ... nodes) {
            this.values = new Node[MathUtil.findNextPositivePowerOfTwo((int)nodes.length)];
            this.valuesMask = this.values.length - 1;
            for (Node<T> node : nodes) {
                int i = SimpleStringMap.hashCode(node.key) & this.valuesMask;
                if (this.values[i] != null) {
                    throw new IllegalArgumentException("index " + i + " collision between values: [" + this.values[i].key + ", " + node.key + "]");
                }
                this.values[i] = node;
            }
        }

        T get(String name) {
            Node<T> node = this.values[SimpleStringMap.hashCode(name) & this.valuesMask];
            return node == null || !node.key.equals(name) ? null : (T)node.value;
        }

        private static int hashCode(String name) {
            return name.hashCode() >>> 6;
        }

        private static final class Node<T> {
            final String key;
            final T value;

            Node(String key, T value) {
                this.key = key;
                this.value = value;
            }
        }
    }
}

