/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.HpackHeader;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Fork(value=5)
@Threads(value=1)
@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=5)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@BenchmarkMode(value={Mode.AverageTime})
public class HpackEncoderBenchmarkUniqueValues
extends AbstractMicrobenchmark {
    @Param(value={"fewHeaders", "manyPaths", "tracesWithUniqueValues"})
    private String type;
    private final AsciiString[] PATHS = HpackEncoderBenchmarkUniqueValues.generateRandomPaths(20);
    private final Random r = new Random();
    private final Http2Headers[] http2Headers = new Http2Headers[1000];
    private final HpackEncoder[] hpackEncoder = new HpackEncoder[1000];
    private final ByteBuf output = Unpooled.buffer((int)10, (int)10000);

    @Setup
    public void setup() throws Http2Exception {
        int i;
        for (i = 0; i < this.http2Headers.length; ++i) {
            DefaultHttp2Headers headers = new DefaultHttp2Headers();
            if (this.type.equals("tracesWithUniqueValues")) {
                headers.add((Object)AsciiString.of((CharSequence)"traceid"), (Object)HpackEncoderBenchmarkUniqueValues.randomAsciiString(20));
            }
            headers.add((Object)AsciiString.of((CharSequence)"key1"), (Object)AsciiString.of((CharSequence)"value1"));
            headers.add((Object)AsciiString.of((CharSequence)"key12"), (Object)AsciiString.of((CharSequence)"value12"));
            headers.add((Object)AsciiString.of((CharSequence)"key123"), (Object)AsciiString.of((CharSequence)"value123"));
            if (this.type.equals("manyPaths")) {
                headers.add((Object)AsciiString.of((CharSequence)":path"), (Object)AsciiString.of((CharSequence)("/path/to/" + this.PATHS[this.r.nextInt(this.PATHS.length)])));
            }
            headers.add((Object)AsciiString.of((CharSequence)":method"), (Object)AsciiString.of((CharSequence)"POST"));
            headers.add((Object)AsciiString.of((CharSequence)"content-encoding"), (Object)AsciiString.of((CharSequence)"grpc-encoding"));
            this.http2Headers[i] = headers;
        }
        for (i = 0; i < this.hpackEncoder.length; ++i) {
            this.hpackEncoder[i] = new HpackEncoder();
            for (Http2Headers headers : this.http2Headers) {
                this.output.clear();
                this.hpackEncoder[i].encodeHeaders(3, this.output, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
            }
        }
    }

    @Benchmark
    public void encode(Blackhole bh) throws Exception {
        this.output.clear();
        Http2Headers headers = this.http2Headers[this.r.nextInt(this.http2Headers.length)];
        HpackEncoder encoder = this.hpackEncoder[this.r.nextInt(this.hpackEncoder.length)];
        encoder.encodeHeaders(3, this.output, headers, Http2HeadersEncoder.NEVER_SENSITIVE);
        bh.consume((Object)this.output);
    }

    private static AsciiString[] generateRandomPaths(int size) {
        AsciiString[] paths = new AsciiString[size];
        for (int i = 0; i < size; ++i) {
            paths[i] = HpackEncoderBenchmarkUniqueValues.randomAsciiString(20);
        }
        return paths;
    }

    private static AsciiString randomAsciiString(int length) {
        return AsciiString.of((CharSequence)HpackHeader.createHeaders((int)1, (int)10, (int)length, (boolean)true).get((int)0).value);
    }
}

