/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.HpackBenchmarkUtil;
import io.netty.handler.codec.http2.HpackDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.HpackHeadersSize;
import io.netty.handler.codec.http2.HpackUtilBenchmark;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

public class HpackDecoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HpackHeadersSize size;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private ByteBuf input;

    @Setup(value=Level.Trial)
    public void setup() throws Http2Exception {
        this.input = Unpooled.wrappedBuffer((byte[])this.getSerializedHeaders(HpackBenchmarkUtil.http2Headers(this.size, this.limitToAscii), this.sensitive));
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.input.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void decode(final Blackhole bh) throws Http2Exception {
        HpackDecoder hpackDecoder = new HpackDecoder(Integer.MAX_VALUE);
        DefaultHttp2Headers headers = new DefaultHttp2Headers(){

            public Http2Headers add(CharSequence name, CharSequence value) {
                bh.consume(HpackDecoderBenchmark.this.sensitive);
                return this;
            }
        };
        hpackDecoder.decode(0, this.input.duplicate(), (Http2Headers)headers, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSerializedHeaders(Http2Headers headers, boolean sensitive) throws Http2Exception {
        HpackEncoder hpackEncoder = HpackUtilBenchmark.newTestEncoder();
        ByteBuf out = this.size.newOutBuffer();
        try {
            hpackEncoder.encodeHeaders(3, out, headers, sensitive ? Http2HeadersEncoder.ALWAYS_SENSITIVE : Http2HeadersEncoder.NEVER_SENSITIVE);
            byte[] bytes = new byte[out.readableBytes()];
            out.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            out.release();
        }
    }
}

