/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.microbench.http.HttpRequestDecoderUtils;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ReferenceCountUtil;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=10, time=500, timeUnit=TimeUnit.MILLISECONDS)
public class HttpPipelinedRequestDecoderBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"false", "true"})
    public boolean direct;
    @Param(value={"1", "16"})
    public int pipeline;
    @Param(value={"false", "true"})
    public boolean pooled;
    @Param(value={"true", "false"})
    public boolean validateHeaders;
    private EmbeddedChannel channel;
    private ByteBuf pipelinedRequest;

    @Setup
    public void initPipeline() {
        PooledByteBufAllocator allocator = this.pooled ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        this.pipelinedRequest = HttpPipelinedRequestDecoderBenchmark.pipelined((ByteBufAllocator)allocator, HttpRequestDecoderUtils.CONTENT_MIXED_DELIMITERS, this.pipeline, this.direct);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new HttpRequestDecoder(4096, 8192, 8192, this.validateHeaders, 128)});
        this.pipelinedRequest.retain(0x3FFFFFFE - this.pipeline);
    }

    private static ByteBuf pipelined(ByteBufAllocator alloc, byte[] content, int pipeline, boolean direct) {
        int totalSize = pipeline * content.length;
        ByteBuf buf = direct ? alloc.directBuffer(totalSize, totalSize) : alloc.heapBuffer(totalSize, totalSize);
        for (int i = 0; i < pipeline; ++i) {
            buf.writeBytes(content);
        }
        return buf;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void testDecodeWholePipelinedRequestMixedDelimiters() {
        Object o;
        EmbeddedChannel channel = this.channel;
        ByteBuf batch = this.pipelinedRequest;
        int refCnt = batch.refCnt();
        if (refCnt == 1) {
            batch.retain(0x3FFFFFFE - this.pipeline);
        }
        batch.resetReaderIndex();
        channel.writeInbound(new Object[]{batch});
        Queue decoded = channel.inboundMessages();
        while ((o = decoded.poll()) != null) {
            ReferenceCountUtil.release(o);
        }
    }

    @TearDown
    public void release() {
        this.pipelinedRequest.release(this.pipelinedRequest.refCnt());
    }
}

