/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.search;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.search.AbstractMultiSearchProcessorFactory;
import io.netty.buffer.search.AbstractSearchProcessorFactory;
import io.netty.buffer.search.SearchProcessor;
import io.netty.buffer.search.SearchProcessorFactory;
import io.netty.microbench.search.ByteBufType;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ByteProcessor;
import io.netty.util.internal.ResourcesUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Warmup(iterations=5)
@Measurement(iterations=5)
@Fork(value=1)
public class SearchRealDataBenchmark
extends AbstractMicrobenchmark {
    @Param
    public Algorithm algorithm;
    @Param
    public ByteBufType bufferType;
    private ByteBuf haystack;
    private SearchProcessorFactory[] searchProcessorFactories;
    private SearchProcessorFactory searchProcessorFactory;
    private static final byte[][] NEEDLES = new byte[][]{"Thank You".getBytes(), "* Does not exist *".getBytes(), "<li>".getBytes(), "<body>".getBytes(), "</li>".getBytes(), "github.com".getBytes(), " Does not exist 2 ".getBytes(), "</html>".getBytes(), "\"https://".getBytes(), "Netty 4.1.45.Final released".getBytes()};
    private int needleId;
    private int searchFrom;
    private int haystackLength;

    @Setup
    public void setup() throws IOException {
        File haystackFile = ResourcesUtil.getFile(SearchRealDataBenchmark.class, (String)"netty-io-news.html");
        byte[] haystackBytes = SearchRealDataBenchmark.readBytes(haystackFile);
        this.haystack = this.bufferType.newBuffer(haystackBytes);
        this.needleId = 0;
        this.searchFrom = 0;
        this.haystackLength = this.haystack.readableBytes();
        this.searchProcessorFactories = new SearchProcessorFactory[NEEDLES.length];
        for (int i = 0; i < NEEDLES.length; ++i) {
            this.searchProcessorFactories[i] = this.algorithm.newFactory(NEEDLES[i]);
        }
    }

    @Setup(value=Level.Invocation)
    public void invocationSetup() {
        this.needleId = (this.needleId + 1) % this.searchProcessorFactories.length;
        this.searchProcessorFactory = this.searchProcessorFactories[this.needleId];
    }

    @TearDown
    public void teardown() {
        this.haystack.release();
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int findFirst() {
        return this.haystack.forEachByte((ByteProcessor)this.searchProcessorFactory.newSearchProcessor());
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int findFirstFromIndex() {
        this.searchFrom = (this.searchFrom + 100) % this.haystackLength;
        return this.haystack.forEachByte(this.searchFrom, this.haystackLength - this.searchFrom, (ByteProcessor)this.searchProcessorFactory.newSearchProcessor());
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public void findAll(Blackhole blackHole) {
        SearchProcessor searchProcessor = this.searchProcessorFactory.newSearchProcessor();
        int pos = 0;
        do {
            pos = this.haystack.forEachByte(pos, this.haystackLength - pos, (ByteProcessor)searchProcessor) + 1;
            blackHole.consume(pos);
        } while (pos > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytes(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            byte[] byArray;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                int ret;
                byte[] buf = new byte[8192];
                while ((ret = ((InputStream)in).read(buf)) >= 0) {
                    out.write(buf, 0, ret);
                }
                byArray = out.toByteArray();
            }
            catch (Throwable throwable) {
                SearchRealDataBenchmark.safeClose(out);
                throw throwable;
            }
            SearchRealDataBenchmark.safeClose(out);
            return byArray;
        }
        finally {
            SearchRealDataBenchmark.safeClose(in);
        }
    }

    private static void safeClose(InputStream in) {
        try {
            in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void safeClose(OutputStream out) {
        try {
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static enum Algorithm {
        AHO_CORASIC{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractMultiSearchProcessorFactory.newAhoCorasicSearchProcessorFactory((byte[][])new byte[][]{needle});
            }
        }
        ,
        KMP{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newKmpSearchProcessorFactory((byte[])needle);
            }
        }
        ,
        BITAP{

            @Override
            SearchProcessorFactory newFactory(byte[] needle) {
                return AbstractSearchProcessorFactory.newBitapSearchProcessorFactory((byte[])needle);
            }
        };


        abstract SearchProcessorFactory newFactory(byte[] var1);
    }
}

