/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;

@Fork(value=2, jvmArgsAppend={"-XX:MaxInlineLevel=9"})
public class Utf8EncodingBenchmark
extends AbstractMicrobenchmark {
    private String[] strings;
    private StringBuilder[] stringBuilders;
    private AnotherCharSequence[] anotherCharSequences;
    private AsciiString[] asciiStrings;
    @Param(value={"true", "false"})
    private boolean direct;
    private ByteBuf buffer;
    @Param(value={"true", "false"})
    private boolean noUnsafe;
    private int dataSetLength;

    @Setup
    public void init() {
        System.setProperty("io.netty.noUnsafe", Boolean.valueOf(this.noUnsafe).toString());
        InputStream testTextStream = null;
        InputStreamReader inStreamReader = null;
        BufferedReader buffReader = null;
        int maxExpectedSize = 0;
        ArrayList<String> strings = new ArrayList<String>();
        ArrayList<StringBuilder> stringBuilders = new ArrayList<StringBuilder>();
        ArrayList<AnotherCharSequence> anotherCharSequenceList = new ArrayList<AnotherCharSequence>();
        ArrayList<AsciiString> asciiStrings = new ArrayList<AsciiString>();
        try {
            String line;
            testTextStream = this.getClass().getResourceAsStream("/Utf8Samples.txt");
            inStreamReader = new InputStreamReader(testTextStream, "UTF-8");
            buffReader = new BufferedReader(inStreamReader);
            while ((line = buffReader.readLine()) != null) {
                strings.add(line);
                stringBuilders.add(new StringBuilder(line));
                anotherCharSequenceList.add(new AnotherCharSequence(line));
                asciiStrings.add(new AsciiString((CharSequence)line));
                maxExpectedSize = Math.max(maxExpectedSize, ByteBufUtil.utf8MaxBytes((int)line.length()));
            }
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Utf8EncodingBenchmark.closeStream(testTextStream);
                Utf8EncodingBenchmark.closeReader(inStreamReader);
                Utf8EncodingBenchmark.closeReader(buffReader);
                throw throwable;
            }
        }
        Utf8EncodingBenchmark.closeStream(testTextStream);
        Utf8EncodingBenchmark.closeReader(inStreamReader);
        Utf8EncodingBenchmark.closeReader(buffReader);
        this.buffer = this.direct ? Unpooled.directBuffer((int)maxExpectedSize, (int)maxExpectedSize) : Unpooled.buffer((int)maxExpectedSize, (int)maxExpectedSize);
        this.buffer.setByte(maxExpectedSize - 1, 0);
        this.strings = strings.toArray(new String[strings.size()]);
        this.stringBuilders = stringBuilders.toArray(new StringBuilder[stringBuilders.size()]);
        this.anotherCharSequences = anotherCharSequenceList.toArray(new AnotherCharSequence[anotherCharSequenceList.size()]);
        this.asciiStrings = asciiStrings.toArray(new AsciiString[asciiStrings.size()]);
        this.dataSetLength = this.strings.length;
    }

    private static void closeStream(InputStream inStream) {
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static void closeReader(Reader buffReader) {
        if (buffReader != null) {
            try {
                buffReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int nestedByteBufUtilWriteUtf8String() {
        int countBytes = 0;
        for (String string : this.strings) {
            countBytes += this.nestedByteBufUtilWriteUtf8String1(string);
        }
        return countBytes;
    }

    private int nestedByteBufUtilWriteUtf8String1(String string) {
        return this.nestedByteBufUtilWriteUtf8String2(string);
    }

    private int nestedByteBufUtilWriteUtf8String2(String string) {
        return this.nestedByteBufUtilWriteUtf8String3(string);
    }

    private int nestedByteBufUtilWriteUtf8String3(String string) {
        return this.nestedByteBufUtilWriteUtf8String4(string);
    }

    private int nestedByteBufUtilWriteUtf8String4(String string) {
        return this.nestedByteBufUtilWriteUtf8String5(string);
    }

    private int nestedByteBufUtilWriteUtf8String5(String string) {
        return this.nestedByteBufUtilWriteUtf8String6(string);
    }

    private int nestedByteBufUtilWriteUtf8String6(String string) {
        this.buffer.resetWriterIndex();
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)string, (int)0, (int)string.length());
        return this.buffer.writerIndex();
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int byteBufUtilWriteUtf8String() {
        int countBytes = 0;
        for (String string : this.strings) {
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)string, (int)0, (int)string.length());
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int byteBufUtilWriteUtf8Bimorphic() {
        int countBytes = 0;
        int size = this.dataSetLength;
        for (int i = 0; i < size; ++i) {
            StringBuilder stringBuilder = this.stringBuilders[i];
            String string = this.strings[i];
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)stringBuilder, (int)0, (int)stringBuilder.length());
            countBytes += this.buffer.writerIndex();
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)string, (int)0, (int)string.length());
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int byteBufUtilWriteUtf8Megamorphic() {
        int countBytes = 0;
        int size = this.dataSetLength;
        for (int i = 0; i < size; ++i) {
            StringBuilder stringBuilder = this.stringBuilders[i];
            String string = this.strings[i];
            AnotherCharSequence anotherCharSequence = this.anotherCharSequences[i];
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)stringBuilder, (int)0, (int)stringBuilder.length());
            countBytes += this.buffer.writerIndex();
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)string, (int)0, (int)string.length());
            countBytes += this.buffer.writerIndex();
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)anotherCharSequence, (int)0, (int)anotherCharSequence.length());
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int byteBufUtilWriteUtf8CommonCharSequences() {
        int countBytes = 0;
        int size = this.dataSetLength;
        for (int i = 0; i < size; ++i) {
            StringBuilder stringBuilder = this.stringBuilders[i];
            String string = this.strings[i];
            AsciiString asciiString = this.asciiStrings[i];
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)stringBuilder, (int)0, (int)stringBuilder.length());
            countBytes += this.buffer.writerIndex();
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)string, (int)0, (int)string.length());
            countBytes += this.buffer.writerIndex();
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)asciiString, (int)0, (int)asciiString.length());
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int byteBufUtilWriteUtf8AsciiString() {
        int countBytes = 0;
        int size = this.dataSetLength;
        for (int i = 0; i < size; ++i) {
            AsciiString asciiString = this.asciiStrings[i];
            this.buffer.resetWriterIndex();
            ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)asciiString, (int)0, (int)asciiString.length());
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    @Benchmark
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public int writeGetBytes() throws UnsupportedEncodingException {
        int countBytes = 0;
        for (String string : this.strings) {
            this.buffer.resetWriterIndex();
            byte[] bytes = string.getBytes("UTF-8");
            this.buffer.writeBytes(bytes);
            countBytes += this.buffer.writerIndex();
        }
        return countBytes;
    }

    private static class AnotherCharSequence
    implements CharSequence {
        private final char[] chars;

        AnotherCharSequence(String chars) {
            this.chars = new char[chars.length()];
            chars.getChars(0, chars.length(), this.chars, 0);
        }

        @Override
        public int length() {
            return this.chars.length;
        }

        @Override
        public char charAt(int i) {
            return this.chars[i];
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String toString() {
            throw new UnsupportedOperationException();
        }
    }
}

