/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Warmup(iterations=10, time=400, timeUnit=TimeUnit.MILLISECONDS)
@Measurement(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
public class ByteBufZeroingBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"1", "2", "3", "4", "7", "8", "15", "64", "65", "1024"})
    private int bytes = 1024;
    @Param(value={"true", "false"})
    private boolean direct;
    @Param(value={"true", "false"})
    private boolean pooled;
    @Param(value={"false"})
    public String checkAccessible;
    @Param(value={"false"})
    public String checkBounds;
    @Param(value={"0", "1"})
    public int startOffset;
    private ByteBuf buffer;
    private int offset;

    @Setup
    public void setup() {
        System.setProperty("io.netty.buffer.checkAccessible", this.checkAccessible);
        System.setProperty("io.netty.buffer.checkBounds", this.checkBounds);
        PooledByteBufAllocator allocator = this.pooled ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        int capacityRequired = this.startOffset + this.bytes;
        this.offset = 0;
        ByteBuf byteBuf = this.buffer = this.direct ? this.alignedDirectAllocation((ByteBufAllocator)allocator, capacityRequired, 8) : allocator.heapBuffer(capacityRequired, capacityRequired);
        if (this.startOffset > 0) {
            this.offset += this.startOffset;
        }
    }

    private ByteBuf alignedDirectAllocation(ByteBufAllocator allocator, int bytes, int alignment) {
        int nextAlignedOffset;
        ByteBuf buffer = allocator.directBuffer(bytes + alignment, bytes + alignment);
        long address = buffer.memoryAddress();
        int remainder = (int)address % alignment;
        this.offset = nextAlignedOffset = alignment - remainder;
        return buffer;
    }

    @Benchmark
    public ByteBuf setZero() {
        ByteBuf buffer = this.buffer;
        buffer.setZero(this.offset, this.bytes);
        return buffer;
    }

    @Benchmark
    public ByteBuf setBytes() {
        ByteBuf buffer = this.buffer;
        int offset = this.offset;
        for (int i = 0; i < this.bytes; ++i) {
            buffer.setByte(offset + i, 0);
        }
        return buffer;
    }

    @TearDown
    public void teardown() {
        this.buffer.release();
    }
}

