/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.channel;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Warmup(iterations=5, time=1)
@Measurement(iterations=5, time=1)
@State(value=Scope.Thread)
public class DefaultChannelPipelineDuplexHandlerBenchmark
extends AbstractMicrobenchmark {
    private ChannelPipeline pipeline;
    private EmbeddedChannel channel;
    @Param(value={"true", "false"})
    private boolean duplex;

    @Setup
    public void setup() {
        this.channel = new EmbeddedChannel(){

            public void runPendingTasks() {
            }
        };
        this.channel.config().setAutoRead(false);
        this.pipeline = this.channel.pipeline();
        this.pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.fireChannelReadComplete();
            }
        }});
        if (this.duplex) {
            this.pipeline.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void channelReadComplete(ChannelHandlerContext ctx) {
                    ctx.fireChannelReadComplete();
                }

                public void flush(ChannelHandlerContext ctx) {
                    ctx.flush();
                }
            }});
            this.pipeline.addLast(new ChannelHandler[]{new ChannelDuplexHandler(){

                public void channelReadComplete(ChannelHandlerContext ctx) {
                    ctx.flush();
                }
            }});
        } else {
            this.pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelReadComplete(ChannelHandlerContext ctx) {
                    ctx.fireChannelReadComplete();
                }
            }});
            this.pipeline.addLast(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

                public void flush(ChannelHandlerContext ctx) {
                    ctx.flush();
                }
            }});
            this.pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelReadComplete(ChannelHandlerContext ctx) {
                    ctx.flush();
                }
            }});
        }
    }

    @TearDown
    public void tearDown() {
        this.pipeline.channel().close();
    }

    @Benchmark
    public void propagateEvent(Blackhole hole) {
        hole.consume((Object)this.pipeline.fireChannelReadComplete());
    }

    @Benchmark
    @Threads(value=4)
    public void parallelPropagateEvent(Blackhole hole) {
        hole.consume((Object)this.pipeline.fireChannelReadComplete());
    }
}

