/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.openjdk.jmh.annotations.AuxCounters;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class ByteBufAllocateAndGrowBenchmark
extends AbstractMicrobenchmark {
    private static final ByteBufAllocator pooledAllocator = PooledByteBufAllocator.DEFAULT;
    private static final ByteBufAllocator adaptiveAllocator = new AdaptiveByteBufAllocator();
    private static final int MAX_LIVE_BUFFERS = 2048;
    private static final Random rand = new Random();
    private static final ByteBuf[] pooledDirectBuffers = new ByteBuf[2048];
    private static final ByteBuf[] adaptiveDirectBuffers = new ByteBuf[2048];
    @Param(value={"00256", "01024", "04096", "16384", "65536"})
    public int size;

    @TearDown
    public void releaseBuffers() {
        List bufferLists = Arrays.asList(pooledDirectBuffers, adaptiveDirectBuffers);
        Iterator iterator = bufferLists.iterator();
        while (iterator.hasNext()) {
            Object[] bufs;
            for (ByteBuf byteBuf : bufs = (ByteBuf[])iterator.next()) {
                if (byteBuf == null || byteBuf.refCnt() <= 0) continue;
                byteBuf.release();
            }
            Arrays.fill(bufs, null);
        }
    }

    @Benchmark
    public void pooledDirectAllocAndFree(BufStats stats) {
        int idx = rand.nextInt(pooledDirectBuffers.length);
        ByteBuf oldBuf = pooledDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBuf buf = pooledAllocator.directBuffer();
        this.expandBuffer(buf, stats);
        ByteBufAllocateAndGrowBenchmark.pooledDirectBuffers[idx] = buf;
    }

    @Benchmark
    public void adaptiveDirectAllocAndFree(BufStats stats) {
        int idx = rand.nextInt(adaptiveDirectBuffers.length);
        ByteBuf oldBuf = adaptiveDirectBuffers[idx];
        if (oldBuf != null) {
            oldBuf.release();
        }
        ByteBuf buf = adaptiveAllocator.directBuffer();
        this.expandBuffer(buf, stats);
        ByteBufAllocateAndGrowBenchmark.adaptiveDirectBuffers[idx] = buf;
    }

    private void expandBuffer(ByteBuf buf, BufStats stats) {
        stats.record(buf);
        while (buf.capacity() < this.size) {
            buf.capacity(2 * buf.capacity());
            stats.record(buf);
        }
    }

    @State(value=Scope.Thread)
    @AuxCounters
    public static class BufStats {
        long bufCounts;
        long bufSizeSum;
        long bufFastCapSum;

        void record(ByteBuf byteBuf) {
            ++this.bufCounts;
            this.bufSizeSum += (long)byteBuf.capacity();
            this.bufFastCapSum += (long)byteBuf.maxFastWritableBytes();
        }

        public double avgSize() {
            return (double)this.bufSizeSum / (double)this.bufCounts;
        }

        public double avgFastCap() {
            return (double)this.bufFastCapSum / (double)this.bufCounts;
        }
    }
}

