/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeadersFactory;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpHeadersFactory;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Thread)
@Fork(value=2)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class HttpRequestEncoderBenchmark
extends AbstractMicrobenchmark {
    private HttpRequestEncoder encoder;
    private FullHttpRequest fullRequest;
    private LastHttpContent lastContent;
    private HttpRequest contentLengthRequest;
    private HttpRequest chunkedRequest;
    private ByteBuf content;
    private ChannelHandlerContext context;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true", "false"})
    public boolean voidPromise;
    @Param(value={"false", "true"})
    public boolean typePollution;
    @Param(value={"128"})
    private int contentBytes;

    @Setup(value=Level.Trial)
    public void setup() throws Exception {
        byte[] bytes = new byte[this.contentBytes];
        this.content = Unpooled.buffer((int)bytes.length);
        this.content.writeBytes(bytes);
        ByteBuf testContent = Unpooled.unreleasableBuffer((ByteBuf)this.content.asReadOnly());
        DefaultHttpHeadersFactory headersFactory = DefaultHttpHeadersFactory.headersFactory().withValidation(false);
        HttpHeaders headersWithChunked = headersFactory.newHeaders();
        headersWithChunked.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        HttpHeaders headersWithContentLength = headersFactory.newHeaders();
        headersWithContentLength.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)testContent.readableBytes());
        this.fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", testContent, headersWithContentLength, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        this.contentLengthRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", headersWithContentLength);
        this.chunkedRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", headersWithChunked);
        this.lastContent = new DefaultLastHttpContent(testContent, (HttpHeadersFactory)headersFactory);
        this.encoder = new HttpRequestEncoder();
        this.context = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)(this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT), (ChannelHandler)this.encoder){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
        if (this.typePollution) {
            for (int i = 0; i < 20000; ++i) {
                this.differentTypes();
            }
        }
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.content.release();
        this.content = null;
    }

    @Benchmark
    public void fullMessage() throws Exception {
        this.fullRequest.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.fullRequest, this.newPromise());
    }

    @Benchmark
    public void contentLength() throws Exception {
        this.encoder.write(this.context, (Object)this.contentLengthRequest, this.newPromise());
        this.lastContent.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
    }

    @Benchmark
    public void chunked() throws Exception {
        this.encoder.write(this.context, (Object)this.chunkedRequest, this.newPromise());
        this.lastContent.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
    }

    @Benchmark
    public void differentTypes() throws Exception {
        this.encoder.write(this.context, (Object)this.contentLengthRequest, this.newPromise());
        this.lastContent.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
        this.content.setIndex(0, this.contentBytes);
        this.fullRequest.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.fullRequest, this.newPromise());
        this.encoder.write(this.context, (Object)this.chunkedRequest, this.newPromise());
        this.lastContent.content().setIndex(0, this.contentBytes);
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
    }

    private ChannelPromise newPromise() {
        return this.voidPromise ? this.context.voidPromise() : this.context.newPromise();
    }
}

