/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.AdaptiveByteBufAllocator;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.concurrent.FastThreadLocalThread;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Thread)
@Warmup(iterations=10, time=1)
@Measurement(iterations=10, time=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class RandomSizeByteBufAllocationBenchmark
extends AbstractMicrobenchmark {
    private static final int SEED = 42;
    private static final int[] SIZE_CLASSES = new int[]{32, 64, 128, 256, 512, 640, 1024, 1152, 2048, 2304, 4096, 4352, 8192, 8704, 16384, 16896};
    @Param(value={"ADAPTIVE"})
    public AllocatorType allocatorType = AllocatorType.ADAPTIVE;
    @Param(value={"128", "128000"})
    public int samples;
    private ByteBufAllocator allocator;
    private short[] sizeSamples;
    private int sampleMask;
    private int nextSampleIndex;

    @Setup
    @SuppressJava6Requirement(reason="using SplittableRandom to reliably produce data")
    public void init() {
        if (!(Thread.currentThread() instanceof FastThreadLocalThread)) {
            throw new IllegalStateException("This benchmark must be run with FastThreadLocalThread: run it with: -Djmh.executor=CUSTOM -Djmh.executor.class=io.netty.microbench.util.AbstractMicrobenchmark$HarnessExecutor");
        }
        switch (this.allocatorType) {
            case JEMALLOC: {
                this.allocator = new PooledByteBufAllocator(true);
                break;
            }
            case ADAPTIVE: {
                this.allocator = new AdaptiveByteBufAllocator(true, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown allocator type: " + (Object)((Object)this.allocatorType));
            }
        }
        this.samples = MathUtil.findNextPositivePowerOfTwo((int)this.samples);
        this.sampleMask = this.samples - 1;
        this.sizeSamples = new short[this.samples];
        SplittableRandom rnd = new SplittableRandom(42L);
        for (int i = 0; i < this.samples; ++i) {
            int sizeClass = rnd.nextInt(SIZE_CLASSES.length);
            short size = (short)rnd.nextInt(sizeClass == 0 ? 0 : SIZE_CLASSES[sizeClass - 1] + 1, SIZE_CLASSES[sizeClass]);
            if (size < 0) {
                throw new IllegalArgumentException("Size sample out of range: " + size);
            }
            this.sizeSamples[i] = size;
        }
    }

    private int nextSize() {
        int index = this.nextSampleIndex;
        this.nextSampleIndex = this.nextSampleIndex + 1 & this.sampleMask;
        return this.sizeSamples[index];
    }

    @Benchmark
    public void allocateAndRelease(Blackhole bh) {
        int size = this.nextSize();
        ByteBuf buffer = this.allocator.buffer(size);
        bh.consume((Object)buffer);
        buffer.release();
    }

    static {
        ResourceLeakDetector.setLevel((ResourceLeakDetector.Level)ResourceLeakDetector.Level.DISABLED);
    }

    public static enum AllocatorType {
        JEMALLOC,
        ADAPTIVE;

    }
}

