/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.Future;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=3, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=3, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class ScheduleFutureTaskBenchmark
extends AbstractMicrobenchmark {
    static final Callable<Void> NO_OP = new Callable<Void>(){

        @Override
        public Void call() throws Exception {
            return null;
        }
    };

    @Benchmark
    @Threads(value=3)
    public Future<?> scheduleLots(final ThreadState threadState) {
        return threadState.eventLoop.submit(new Runnable(){

            @Override
            public void run() {
                for (int i = 1; i <= threadState.num; ++i) {
                    threadState.eventLoop.schedule(NO_OP, (long)i, TimeUnit.HOURS);
                }
            }
        }).syncUninterruptibly();
    }

    @Benchmark
    @Threads(value=1)
    public Future<?> scheduleLotsOutsideLoop(ThreadState threadState) {
        AbstractScheduledEventExecutor eventLoop = threadState.eventLoop;
        for (int i = 1; i <= threadState.num; ++i) {
            eventLoop.schedule(NO_OP, (long)i, TimeUnit.HOURS);
        }
        return null;
    }

    @Benchmark
    @Threads(value=1)
    public Future<?> scheduleCancelLotsOutsideLoop(ThreadState threadState) {
        AbstractScheduledEventExecutor eventLoop = threadState.eventLoop;
        for (int i = 1; i <= threadState.num; ++i) {
            eventLoop.schedule(NO_OP, (long)i, TimeUnit.HOURS).cancel(false);
        }
        return null;
    }

    @State(value=Scope.Thread)
    public static class ThreadState {
        @Param(value={"100000"})
        int num;
        AbstractScheduledEventExecutor eventLoop;

        @Setup(value=Level.Trial)
        public void reset() {
            this.eventLoop = (AbstractScheduledEventExecutor)new NioEventLoopGroup(1).next();
        }

        @Setup(value=Level.Invocation)
        public void clear() {
            this.eventLoop.submit(new Runnable(){

                @Override
                public void run() {
                    ThreadState.this.eventLoop.cancelScheduledTasks();
                }
            }).awaitUninterruptibly();
        }

        @TearDown(value=Level.Trial)
        public void shutdown() {
            this.clear();
            this.eventLoop.parent().shutdownGracefully().awaitUninterruptibly();
        }
    }
}

