/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.udt.echo.rendezvousBytes;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.udt.UdtChannel;
import io.netty.channel.udt.nio.NioUdtProvider;
import io.netty.example.udt.echo.rendezvousBytes.ByteEchoPeerHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.net.SocketAddress;
import java.nio.channels.spi.SelectorProvider;
import java.util.concurrent.ThreadFactory;

public class ByteEchoPeerBase {
    protected final int messageSize;
    protected final SocketAddress myAddress;
    protected final SocketAddress peerAddress;

    public ByteEchoPeerBase(int messageSize, SocketAddress myAddress, SocketAddress peerAddress) {
        this.messageSize = messageSize;
        this.myAddress = myAddress;
        this.peerAddress = peerAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        DefaultThreadFactory connectFactory = new DefaultThreadFactory("rendezvous");
        MultiThreadIoEventLoopGroup connectGroup = new MultiThreadIoEventLoopGroup(1, (ThreadFactory)connectFactory, NioIoHandler.newFactory((SelectorProvider)NioUdtProvider.BYTE_PROVIDER));
        try {
            Bootstrap bootstrap = new Bootstrap();
            ((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)connectGroup)).channelFactory(NioUdtProvider.BYTE_RENDEZVOUS)).handler((ChannelHandler)new ChannelInitializer<UdtChannel>(){

                protected void initChannel(UdtChannel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.INFO), new ByteEchoPeerHandler(ByteEchoPeerBase.this.messageSize)});
                }
            });
            ChannelFuture future = bootstrap.connect(this.peerAddress, this.myAddress).sync();
            future.channel().closeFuture().sync();
        }
        finally {
            connectGroup.shutdownGracefully();
        }
    }
}

