/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.dns.udp;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponse;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;

public final class DnsClient {
    private static final String QUERY_DOMAIN = "www.example.com";
    private static final int DNS_SERVER_PORT = 53;
    private static final String DNS_SERVER_HOST = "8.8.8.8";

    private DnsClient() {
    }

    private static void handleQueryResp(DatagramDnsResponse msg) {
        if (msg.count(DnsSection.QUESTION) > 0) {
            DnsQuestion question = (DnsQuestion)msg.recordAt(DnsSection.QUESTION, 0);
            System.out.printf("name: %s%n", question.name());
        }
        int count = msg.count(DnsSection.ANSWER);
        for (int i = 0; i < count; ++i) {
            DnsRecord record = msg.recordAt(DnsSection.ANSWER, i);
            if (record.type() != DnsRecordType.A) continue;
            DnsRawRecord raw = (DnsRawRecord)record;
            System.out.println(NetUtil.bytesToIpAddress((byte[])ByteBufUtil.getBytes((ByteBuf)raw.content())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        InetSocketAddress addr = new InetSocketAddress(DNS_SERVER_HOST, 53);
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<DatagramChannel>(){

                protected void initChannel(DatagramChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new DatagramDnsQueryEncoder()}).addLast(new ChannelHandler[]{new DatagramDnsResponseDecoder()}).addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<DatagramDnsResponse>(){

                        protected void channelRead0(ChannelHandlerContext ctx, DatagramDnsResponse msg) {
                            try {
                                DnsClient.handleQueryResp(msg);
                            }
                            finally {
                                ctx.close();
                            }
                        }
                    }});
                }
            });
            Channel ch = b.bind(0).sync().channel();
            DatagramDnsQuery query = new DatagramDnsQuery(null, addr, 1).setRecord(DnsSection.QUESTION, (DnsRecord)new DefaultDnsQuestion(QUERY_DOMAIN, DnsRecordType.A));
            ch.writeAndFlush((Object)query).sync();
            boolean succ = ch.closeFuture().await(10L, TimeUnit.SECONDS);
            if (!succ) {
                System.err.println("dns query timeout!");
                ch.close().sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

