/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.factorial;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.example.factorial.FactorialClient;
import io.netty.util.concurrent.GenericFutureListener;
import java.math.BigInteger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class FactorialClientHandler
extends SimpleChannelInboundHandler<BigInteger> {
    private ChannelHandlerContext ctx;
    private int receivedMessages;
    private int next = 1;
    final BlockingQueue<BigInteger> answer = new LinkedBlockingQueue<BigInteger>();
    private final ChannelFutureListener numberSender = future -> {
        if (future.isSuccess()) {
            this.sendNumbers();
        } else {
            future.cause().printStackTrace();
            future.channel().close();
        }
    };

    public BigInteger getFactorial() {
        boolean interrupted = false;
        while (true) {
            try {
                BigInteger bigInteger = this.answer.take();
                return bigInteger;
            }
            catch (InterruptedException ignore) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.ctx = ctx;
        this.sendNumbers();
    }

    public void channelRead0(ChannelHandlerContext ctx, BigInteger msg) {
        ++this.receivedMessages;
        if (this.receivedMessages == FactorialClient.COUNT) {
            ctx.channel().close().addListener(future -> {
                boolean offered = this.answer.offer(msg);
                assert (offered);
            });
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }

    private void sendNumbers() {
        ChannelFuture future = null;
        for (int i = 0; i < 4096 && this.next <= FactorialClient.COUNT; ++i) {
            future = this.ctx.write((Object)this.next);
            ++this.next;
        }
        if (this.next <= FactorialClient.COUNT) {
            assert (future != null);
            future.addListener((GenericFutureListener)this.numberSender);
        }
        this.ctx.flush();
    }
}

