/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.example.stomp.websocket.StompChatHandler;
import io.netty.example.stomp.websocket.StompVersion;
import io.netty.example.stomp.websocket.StompWebSocketClientPageHandler;
import io.netty.example.stomp.websocket.StompWebSocketFrameEncoder;
import io.netty.handler.codec.MessageToMessageCodec;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.stomp.StompSubframe;
import io.netty.handler.codec.stomp.StompSubframeAggregator;
import io.netty.handler.codec.stomp.StompSubframeDecoder;
import java.util.List;

@ChannelHandler.Sharable
public class StompWebSocketProtocolCodec
extends MessageToMessageCodec<WebSocketFrame, StompSubframe> {
    private final StompChatHandler stompChatHandler = new StompChatHandler();
    private final StompWebSocketFrameEncoder stompWebSocketFrameEncoder = new StompWebSocketFrameEncoder();

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof WebSocketServerProtocolHandler.HandshakeComplete) {
            StompVersion stompVersion = StompVersion.findBySubProtocol(((WebSocketServerProtocolHandler.HandshakeComplete)evt).selectedSubprotocol());
            ctx.channel().attr(StompVersion.CHANNEL_ATTRIBUTE_KEY).set((Object)stompVersion);
            ctx.pipeline().addLast(new ChannelHandler[]{new WebSocketFrameAggregator(65536)}).addLast(new ChannelHandler[]{new StompSubframeDecoder()}).addLast(new ChannelHandler[]{new StompSubframeAggregator(65536)}).addLast(new ChannelHandler[]{this.stompChatHandler}).remove((ChannelHandler)StompWebSocketClientPageHandler.INSTANCE);
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    protected void encode(ChannelHandlerContext ctx, StompSubframe stompFrame, List<Object> out) throws Exception {
        this.stompWebSocketFrameEncoder.encode(ctx, stompFrame, out);
    }

    protected void decode(ChannelHandlerContext ctx, WebSocketFrame webSocketFrame, List<Object> out) {
        if (webSocketFrame instanceof TextWebSocketFrame || webSocketFrame instanceof BinaryWebSocketFrame) {
            out.add(webSocketFrame.content().retain());
        } else {
            ctx.close();
        }
    }
}

