/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2.helloworld.frame.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameCodecBuilder;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.ssl.SslContext;

public final class Http2ClientFrameInitializer
extends ChannelInitializer<Channel> {
    private final SslContext sslCtx;

    public Http2ClientFrameInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    protected void initChannel(Channel ch) throws Exception {
        if (this.sslCtx != null) {
            ch.pipeline().addFirst(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        Http2FrameCodec http2FrameCodec = Http2FrameCodecBuilder.forClient().initialSettings(Http2Settings.defaultSettings()).build();
        ch.pipeline().addLast(new ChannelHandler[]{http2FrameCodec});
        ch.pipeline().addLast(new ChannelHandler[]{new Http2MultiplexHandler((ChannelHandler)new SimpleChannelInboundHandler(){

            protected void channelRead0(ChannelHandlerContext ctx, Object msg) {
            }
        })});
    }
}

