/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.spdy.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.example.spdy.server.SpdyServerHandler;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.spdy.SpdyFrameCodec;
import io.netty.handler.codec.spdy.SpdyHttpDecoder;
import io.netty.handler.codec.spdy.SpdyHttpEncoder;
import io.netty.handler.codec.spdy.SpdyHttpResponseStreamIdHandler;
import io.netty.handler.codec.spdy.SpdySessionHandler;
import io.netty.handler.codec.spdy.SpdyVersion;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;

public class SpdyOrHttpHandler
extends ApplicationProtocolNegotiationHandler {
    private static final int MAX_CONTENT_LENGTH = 102400;

    protected SpdyOrHttpHandler() {
        super("http/1.1");
    }

    protected void configurePipeline(ChannelHandlerContext ctx, String protocol) throws Exception {
        if ("spdy/3.1".equals(protocol)) {
            SpdyOrHttpHandler.configureSpdy(ctx, SpdyVersion.SPDY_3_1);
            return;
        }
        if ("http/1.1".equals(protocol)) {
            SpdyOrHttpHandler.configureHttp1(ctx);
            return;
        }
        throw new IllegalStateException("unknown protocol: " + protocol);
    }

    private static void configureSpdy(ChannelHandlerContext ctx, SpdyVersion version) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{new SpdyFrameCodec(version)});
        p.addLast(new ChannelHandler[]{new SpdySessionHandler(version, true)});
        p.addLast(new ChannelHandler[]{new SpdyHttpEncoder(version)});
        p.addLast(new ChannelHandler[]{new SpdyHttpDecoder(version, 102400)});
        p.addLast(new ChannelHandler[]{new SpdyHttpResponseStreamIdHandler()});
        p.addLast(new ChannelHandler[]{new SpdyServerHandler()});
    }

    private static void configureHttp1(ChannelHandlerContext ctx) throws Exception {
        ChannelPipeline p = ctx.pipeline();
        p.addLast(new ChannelHandler[]{new HttpServerCodec()});
        p.addLast(new ChannelHandler[]{new HttpObjectAggregator(102400)});
        p.addLast(new ChannelHandler[]{new SpdyServerHandler()});
    }
}

