/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2DataFrame;
import io.netty.handler.codec.http2.DefaultHttp2GoAwayFrame;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersFrame;
import io.netty.handler.codec.http2.DefaultHttp2PingFrame;
import io.netty.handler.codec.http2.DefaultHttp2UnknownFrame;
import io.netty.handler.codec.http2.DefaultHttp2WindowUpdateFrame;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataFrame;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameInboundWriter;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersFrame;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2NoMoreStreamIdsException;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2SettingsAckFrame;
import io.netty.handler.codec.http2.Http2SettingsFrame;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamChannelBootstrap;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.LastInboundHandler;
import io.netty.handler.codec.http2.TestChannelInitializer;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatcher;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public abstract class Http2MultiplexTest<C extends Http2FrameCodec> {
    private final Http2Headers request = new DefaultHttp2Headers().method((CharSequence)HttpMethod.GET.asciiName()).scheme((CharSequence)HttpScheme.HTTPS.name()).authority((CharSequence)new AsciiString((CharSequence)"example.org")).path((CharSequence)new AsciiString((CharSequence)"/foo"));
    private EmbeddedChannel parentChannel;
    private Http2FrameWriter frameWriter;
    private Http2FrameInboundWriter frameInboundWriter;
    private TestChannelInitializer childChannelInitializer;
    private C codec;
    private static final int initialRemoteStreamWindow = 1024;

    protected abstract C newCodec(TestChannelInitializer var1, Http2FrameWriter var2);

    protected abstract ChannelHandler newMultiplexer(TestChannelInitializer var1);

    @BeforeEach
    public void setUp() {
        this.childChannelInitializer = new TestChannelInitializer();
        this.parentChannel = new EmbeddedChannel();
        this.frameInboundWriter = new Http2FrameInboundWriter(this.parentChannel);
        this.parentChannel.connect((SocketAddress)new InetSocketAddress(0));
        this.frameWriter = Http2TestUtil.mockedFrameWriter();
        this.codec = this.newCodec(this.childChannelInitializer, this.frameWriter);
        this.parentChannel.pipeline().addLast(new ChannelHandler[]{this.codec});
        ChannelHandler multiplexer = this.newMultiplexer(this.childChannelInitializer);
        if (multiplexer != null) {
            this.parentChannel.pipeline().addLast(new ChannelHandler[]{multiplexer});
        }
        this.parentChannel.runPendingTasks();
        this.parentChannel.pipeline().fireChannelActive();
        this.parentChannel.writeInbound(new Object[]{Http2CodecUtil.connectionPrefaceBuf()});
        Http2Settings settings = new Http2Settings().initialWindowSize(1024);
        this.frameInboundWriter.writeInboundSettings(settings);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettingsAck(this.eqCodecCtx(), Http2TestUtil.anyChannelPromise());
        this.frameInboundWriter.writeInboundSettingsAck();
        Http2SettingsFrame settingsFrame = (Http2SettingsFrame)this.parentChannel.readInbound();
        Assertions.assertNotNull((Object)settingsFrame);
        Http2SettingsAckFrame settingsAckFrame = (Http2SettingsAckFrame)this.parentChannel.readInbound();
        Assertions.assertNotNull((Object)settingsAckFrame);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeSettings(this.eqCodecCtx(), Http2TestUtil.anyHttp2Settings(), Http2TestUtil.anyChannelPromise());
    }

    private ChannelHandlerContext eqCodecCtx() {
        return (ChannelHandlerContext)ArgumentMatchers.eq((Object)((Http2FrameCodec)this.codec).ctx);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.childChannelInitializer.handler instanceof LastInboundHandler) {
            ((LastInboundHandler)this.childChannelInitializer.handler).finishAndReleaseAll();
        }
        this.parentChannel.finishAndReleaseAll();
        this.codec = null;
    }

    @Test
    public void writeUnknownFrame() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.writeAndFlush((Object)new DefaultHttp2UnknownFrame(99, new Http2Flags()));
                ctx.fireChannelActive();
            }
        });
        Assertions.assertTrue((boolean)childChannel.isActive());
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeFrame((ChannelHandlerContext)ArgumentMatchers.eq((Object)((Http2FrameCodec)this.codec).ctx), ArgumentMatchers.eq((byte)99), Http2MultiplexTest.eqStreamId(childChannel), (Http2Flags)ArgumentMatchers.any(Http2Flags.class), (ByteBuf)ArgumentMatchers.any(ByteBuf.class), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class));
    }

    Http2StreamChannel newInboundStream(int streamId, boolean endStream, ChannelHandler childHandler) {
        return this.newInboundStream(streamId, endStream, null, childHandler);
    }

    private Http2StreamChannel newInboundStream(int streamId, boolean endStream, AtomicInteger maxReads, final ChannelHandler childHandler) {
        final AtomicReference streamChannelRef = new AtomicReference();
        this.childChannelInitializer.maxReads = maxReads;
        this.childChannelInitializer.handler = new ChannelInboundHandlerAdapter(){

            public void channelRegistered(ChannelHandlerContext ctx) {
                Assertions.assertNull(streamChannelRef.get());
                streamChannelRef.set((Http2StreamChannel)ctx.channel());
                ctx.pipeline().addLast(new ChannelHandler[]{childHandler});
                ctx.fireChannelRegistered();
            }
        };
        this.frameInboundWriter.writeInboundHeaders(streamId, this.request, 0, endStream);
        this.parentChannel.runPendingTasks();
        Http2StreamChannel channel = (Http2StreamChannel)streamChannelRef.get();
        Assertions.assertEquals((int)streamId, (int)channel.stream().id());
        return channel;
    }

    @Test
    public void readUnkownFrame() {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, true, (ChannelHandler)handler);
        this.frameInboundWriter.writeInboundFrame((byte)99, channel.stream().id(), new Http2Flags(), Unpooled.EMPTY_BUFFER);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel, handler, 2);
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        Assertions.assertTrue((boolean)childChannel.isActive());
    }

    @Test
    public void readPriorityFrame() {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, true, (ChannelHandler)handler);
        this.frameInboundWriter.writeInboundPriority(channel.stream().id(), 0, (short)2, false);
        int numFrames = this.useUserEventForPriorityFrame() ? 1 : 2;
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel, handler, numFrames);
        if (numFrames == 1) {
            Http2PriorityFrame priorityFrame = (Http2PriorityFrame)handler.readUserEvent();
            Assertions.assertEquals((Object)channel.stream(), (Object)priorityFrame.stream());
            Assertions.assertEquals((int)0, (int)priorityFrame.streamDependency());
            Assertions.assertEquals((int)2, (int)priorityFrame.weight());
            Assertions.assertFalse((boolean)priorityFrame.exclusive());
        }
    }

    @Test
    public void headerAndDataFramesShouldBeDelivered() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(this.request).stream(channel.stream());
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("hello")).stream(channel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("world")).stream(channel.stream());
        Assertions.assertTrue((boolean)inboundHandler.isChannelActive());
        this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("hello"), 0, false);
        this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("world"), 0, false);
        Assertions.assertEquals((Object)headersFrame, inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
    }

    @ParameterizedTest
    @EnumSource(value=RstFrameTestMode.class)
    void noRstFrameSentOnCloseViaListener(final RstFrameTestMode mode) throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler(){
            private boolean headersReceived;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                try {
                    boolean endStream;
                    if (msg instanceof Http2HeadersFrame) {
                        endStream = ((Http2HeadersFrame)msg).isEndStream();
                        switch (mode) {
                            case HEADERS_END_STREAM: {
                                Assertions.assertFalse((boolean)this.headersReceived);
                                Assertions.assertTrue((boolean)endStream);
                                break;
                            }
                            case TRAILERS_END_STREAM: {
                                if (this.headersReceived) {
                                    Assertions.assertTrue((boolean)endStream);
                                    break;
                                }
                                Assertions.assertFalse((boolean)endStream);
                                break;
                            }
                            case DATA_END_STREAM: {
                                Assertions.assertFalse((boolean)endStream);
                                break;
                            }
                            default: {
                                Assertions.fail();
                            }
                        }
                        this.headersReceived = true;
                    } else if (msg instanceof Http2DataFrame) {
                        endStream = ((Http2DataFrame)msg).isEndStream();
                        switch (mode) {
                            case HEADERS_END_STREAM: {
                                Assertions.fail();
                                break;
                            }
                            case TRAILERS_END_STREAM: {
                                Assertions.assertFalse((boolean)endStream);
                                break;
                            }
                            case DATA_END_STREAM: {
                                Assertions.assertTrue((boolean)endStream);
                                break;
                            }
                            default: {
                                Assertions.fail();
                                break;
                            }
                        }
                    } else {
                        throw new UnsupportedMessageTypeException(msg, new Class[0]);
                    }
                    if (endStream) {
                        ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true, 0)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                }
                finally {
                    ReferenceCountUtil.release((Object)msg);
                }
            }
        };
        Http2StreamChannel channel = this.newInboundStream(3, mode == RstFrameTestMode.HEADERS_END_STREAM, (ChannelHandler)inboundHandler);
        if (mode != RstFrameTestMode.HEADERS_END_STREAM) {
            this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("something"), 0, mode == RstFrameTestMode.DATA_END_STREAM);
            if (mode != RstFrameTestMode.DATA_END_STREAM) {
                this.frameInboundWriter.writeInboundHeaders(channel.stream().id(), (Http2Headers)new DefaultHttp2Headers(), 0, true);
            }
        }
        channel.closeFuture().syncUninterruptibly();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(channel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
        inboundHandler.checkException();
    }

    @Test
    public void headerMultipleContentLengthValidationShouldPropagate() {
        this.headerMultipleContentLengthValidationShouldPropagate(false);
    }

    @Test
    public void headerMultipleContentLengthValidationShouldPropagateWithEndStream() {
        this.headerMultipleContentLengthValidationShouldPropagate(true);
    }

    private void headerMultipleContentLengthValidationShouldPropagate(boolean endStream) {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        this.request.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 0L);
        this.request.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 1L);
        Http2StreamChannel channel = this.newInboundStream(3, endStream, (ChannelHandler)inboundHandler);
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        Assertions.assertNull(inboundHandler.readInbound());
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    public void headerPlusSignContentLengthValidationShouldPropagate() {
        this.headerSignContentLengthValidationShouldPropagateWithEndStream(false, false);
    }

    @Test
    public void headerPlusSignContentLengthValidationShouldPropagateWithEndStream() {
        this.headerSignContentLengthValidationShouldPropagateWithEndStream(false, true);
    }

    @Test
    public void headerMinusSignContentLengthValidationShouldPropagate() {
        this.headerSignContentLengthValidationShouldPropagateWithEndStream(true, false);
    }

    @Test
    public void headerMinusSignContentLengthValidationShouldPropagateWithEndStream() {
        this.headerSignContentLengthValidationShouldPropagateWithEndStream(true, true);
    }

    private void headerSignContentLengthValidationShouldPropagateWithEndStream(boolean minus, boolean endStream) {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        this.request.add((Object)HttpHeaderNames.CONTENT_LENGTH, (Object)((minus ? "-" : "+") + 1));
        Http2StreamChannel channel = this.newInboundStream(3, endStream, (ChannelHandler)inboundHandler);
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        Assertions.assertNull(inboundHandler.readInbound());
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagate() {
        this.headerContentLengthNotMatchValidationShouldPropagate(false, false, false);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateWithEndStream() {
        this.headerContentLengthNotMatchValidationShouldPropagate(false, true, false);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateCloseLocal() {
        this.headerContentLengthNotMatchValidationShouldPropagate(true, false, false);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateWithEndStreamCloseLocal() {
        this.headerContentLengthNotMatchValidationShouldPropagate(true, true, false);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateTrailers() {
        this.headerContentLengthNotMatchValidationShouldPropagate(false, false, true);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateWithEndStreamTrailers() {
        this.headerContentLengthNotMatchValidationShouldPropagate(false, true, true);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateCloseLocalTrailers() {
        this.headerContentLengthNotMatchValidationShouldPropagate(true, false, true);
    }

    @Test
    public void headerContentLengthNotMatchValidationShouldPropagateWithEndStreamCloseLocalTrailers() {
        this.headerContentLengthNotMatchValidationShouldPropagate(true, true, true);
    }

    private void headerContentLengthNotMatchValidationShouldPropagate(boolean closeLocal, boolean endStream, boolean trailer) {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        this.request.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 1L);
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)channel.isActive());
        if (closeLocal) {
            channel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers(), true)).syncUninterruptibly();
            Assertions.assertEquals((Object)Http2Stream.State.HALF_CLOSED_LOCAL, (Object)channel.stream().state());
        } else {
            Assertions.assertEquals((Object)Http2Stream.State.OPEN, (Object)channel.stream().state());
        }
        if (trailer) {
            this.frameInboundWriter.writeInboundHeaders(channel.stream().id(), (Http2Headers)new DefaultHttp2Headers(), 0, endStream);
        } else {
            this.frameInboundWriter.writeInboundData(channel.stream().id(), Http2TestUtil.bb("foo"), 0, endStream);
        }
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        DefaultHttp2HeadersFrame headersFrame = new DefaultHttp2HeadersFrame(this.request).stream(channel.stream());
        Assertions.assertEquals((Object)headersFrame, inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
        Assertions.assertFalse((boolean)channel.isActive());
    }

    @Test
    public void streamExceptionCauseRstStreamWithProtocolError() {
        this.request.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 10L);
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)new ChannelInboundHandlerAdapter());
        channel.pipeline().fireExceptionCaught((Throwable)new Http2FrameStreamException(channel.stream(), Http2Error.PROTOCOL_ERROR, (Throwable)new IllegalArgumentException()));
        Assertions.assertFalse((boolean)channel.isActive());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((long)Http2Error.PROTOCOL_ERROR.code()), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void contentLengthNotMatchRstStreamWithProtocolError() {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        this.request.addLong((Object)HttpHeaderNames.CONTENT_LENGTH, 10L);
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        this.frameInboundWriter.writeInboundData(3, Http2TestUtil.bb(8), 0, true);
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
        Assertions.assertNotNull(inboundHandler.readInbound());
        Assertions.assertFalse((boolean)channel.isActive());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), ArgumentMatchers.eq((int)3), ArgumentMatchers.eq((long)Http2Error.PROTOCOL_ERROR.code()), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void framesShouldBeMultiplexed() {
        LastInboundHandler handler1 = new LastInboundHandler();
        Http2StreamChannel channel1 = this.newInboundStream(3, false, (ChannelHandler)handler1);
        LastInboundHandler handler2 = new LastInboundHandler();
        Http2StreamChannel channel2 = this.newInboundStream(5, false, (ChannelHandler)handler2);
        LastInboundHandler handler3 = new LastInboundHandler();
        Http2StreamChannel channel3 = this.newInboundStream(11, false, (ChannelHandler)handler3);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel1, handler1, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel2, handler2, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel3, handler3, 1);
        this.frameInboundWriter.writeInboundData(channel2.stream().id(), Http2TestUtil.bb("hello"), 0, false);
        this.frameInboundWriter.writeInboundData(channel1.stream().id(), Http2TestUtil.bb("foo"), 0, true);
        this.frameInboundWriter.writeInboundData(channel2.stream().id(), Http2TestUtil.bb("world"), 0, true);
        this.frameInboundWriter.writeInboundData(channel3.stream().id(), Http2TestUtil.bb("bar"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel1, handler1, 1);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel2, handler2, 2);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel3, handler3, 1);
    }

    @Test
    public void inboundDataFrameShouldUpdateLocalFlowController() throws Http2Exception {
        Http2LocalFlowController flowController = (Http2LocalFlowController)Mockito.mock(Http2LocalFlowController.class);
        this.codec.connection().local().flowController((Http2FlowController)flowController);
        LastInboundHandler handler = new LastInboundHandler();
        final Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)handler);
        ByteBuf tenBytes = Http2TestUtil.bb("0123456789");
        this.frameInboundWriter.writeInboundData(channel.stream().id(), tenBytes, 0, true);
        ((Http2LocalFlowController)Mockito.verify((Object)flowController)).consumeBytes((Http2Stream)ArgumentMatchers.argThat((ArgumentMatcher)new ArgumentMatcher<Http2Stream>(){

            public boolean matches(Http2Stream http2Stream) {
                return http2Stream.id() == channel.stream().id();
            }
        }), ArgumentMatchers.eq((int)10));
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(channel, handler, 2);
    }

    @Test
    public void unhandledHttp2FramesShouldBePropagated() {
        DefaultHttp2PingFrame pingFrame = new DefaultHttp2PingFrame(0L);
        this.frameInboundWriter.writeInboundPing(false, 0L);
        Assertions.assertEquals((Object)this.parentChannel.readInbound(), (Object)pingFrame);
        DefaultHttp2GoAwayFrame goAwayFrame = new DefaultHttp2GoAwayFrame(1L, this.parentChannel.alloc().buffer().writeLong(8L));
        this.frameInboundWriter.writeInboundGoAway(0, goAwayFrame.errorCode(), goAwayFrame.content().retainedDuplicate());
        Http2GoAwayFrame frame = (Http2GoAwayFrame)this.parentChannel.readInbound();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)frame, (Http2Frame)goAwayFrame);
    }

    @Test
    public void channelReadShouldRespectAutoRead() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        childChannel.config().setAutoRead(false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)dataFrame0);
        ReferenceCountUtil.release((Object)dataFrame0);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        Assertions.assertNull(inboundHandler.readInbound());
        childChannel.config().setAutoRead(true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 2);
    }

    @Test
    public void noAutoReadWithReentrantReadDoesNotSOOE() {
        int i;
        final AtomicBoolean shouldRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                if (shouldRead.get()) {
                    obj.read();
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        AtomicInteger maxReads = new AtomicInteger(1);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, maxReads, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        childChannel.config().setAutoRead(false);
        int maxWrites = 10000;
        for (i = 0; i < 10000; ++i) {
            this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(String.valueOf(i)), 0, false);
        }
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(String.valueOf(10000)), 0, true);
        shouldRead.set(true);
        childChannel.read();
        for (i = 0; i < 10000; ++i) {
            Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
            Assertions.assertNotNull((Object)dataFrame0);
            ReferenceCountUtil.release((Object)dataFrame0);
        }
        Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
        Assertions.assertTrue((boolean)dataFrame0.isEndStream());
        ReferenceCountUtil.release((Object)dataFrame0);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 0);
    }

    @Test
    public void readNotRequiredToEndStream() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        AtomicInteger maxReads = new AtomicInteger(1);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, maxReads, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Assertions.assertNull(inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundRstStream(childChannel.stream().id(), Http2Error.NO_ERROR.code());
        Assertions.assertFalse((boolean)inboundHandler.isChannelActive());
        childChannel.closeFuture().syncUninterruptibly();
        Http2ResetFrame resetFrame = this.useUserEventForResetFrame() ? (Http2ResetFrame)inboundHandler.readUserEvent() : (Http2ResetFrame)inboundHandler.readInbound();
        Assertions.assertEquals((Object)childChannel.stream(), (Object)resetFrame.stream());
        Assertions.assertEquals((long)Http2Error.NO_ERROR.code(), (long)resetFrame.errorCode());
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 0);
    }

    @Test
    public void channelReadShouldRespectAutoReadAndNotProduceNPE() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        childChannel.config().setAutoRead(false);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
            private int count;

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                ctx.fireChannelRead(msg);
                if (++this.count == 2) {
                    ctx.close();
                }
            }
        }});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        Http2DataFrame dataFrame0 = (Http2DataFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)dataFrame0);
        ReferenceCountUtil.release((Object)dataFrame0);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        Assertions.assertNull(inboundHandler.readInbound());
        childChannel.config().setAutoRead(true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
        inboundHandler.checkException();
    }

    @Test
    public void readInChannelReadWithoutAutoRead() {
        this.useReadWithoutAutoRead(false);
    }

    @Test
    public void readInChannelReadCompleteWithoutAutoRead() {
        this.useReadWithoutAutoRead(true);
    }

    private void useReadWithoutAutoRead(final boolean readComplete) {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assertions.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                if (!readComplete) {
                    ctx.read();
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) {
                ctx.fireChannelReadComplete();
                if (readComplete) {
                    ctx.read();
                }
            }
        }});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 6);
    }

    @Test
    public void allQueuedFramesDeliveredAfterParentIsClosed() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, new AtomicInteger(1), (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assertions.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 1);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("baz"), 0, true);
        Assertions.assertNull(inboundHandler.readInbound());
        this.parentChannel.close();
        Assertions.assertTrue((boolean)childChannel.isActive());
        childChannel.read();
        inboundHandler.checkException();
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 2);
        Assertions.assertFalse((boolean)childChannel.isActive());
    }

    private Http2StreamChannel newOutboundStream(ChannelHandler handler) {
        return (Http2StreamChannel)new Http2StreamChannelBootstrap((Channel)this.parentChannel).handler(handler).open().syncUninterruptibly().getNow();
    }

    @Test
    public void idleOutboundStreamShouldNotWriteResetFrameOnClose() {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assertions.assertTrue((boolean)childChannel.isActive());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        Assertions.assertFalse((boolean)childChannel.isOpen());
        Assertions.assertFalse((boolean)childChannel.isActive());
        Assertions.assertNull((Object)this.parentChannel.readOutbound());
    }

    @Test
    public void outboundStreamShouldWriteResetFrameOnClose_headersSent() {
        ChannelInboundHandlerAdapter handler = new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.fireChannelActive();
            }
        };
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assertions.assertTrue((boolean)childChannel.isActive());
        childChannel.close();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.eq((long)Http2Error.CANCEL.code()), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void outboundStreamShouldNotWriteResetFrameOnClose_IfStreamDidntExist() {
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.any(Http2Headers.class), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){
            private boolean headersWritten;

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                if (!this.headersWritten) {
                    this.headersWritten = true;
                    return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Exception("boom"));
                }
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setSuccess();
            }
        });
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) {
                ctx.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
                ctx.fireChannelActive();
            }
        });
        Assertions.assertFalse((boolean)childChannel.isActive());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
        Assertions.assertTrue((boolean)this.parentChannel.outboundMessages().isEmpty());
    }

    @Test
    public void inboundRstStreamFireChannelInactive() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)inboundHandler.isChannelActive());
        this.frameInboundWriter.writeInboundRstStream(channel.stream().id(), Http2Error.INTERNAL_ERROR.code());
        Assertions.assertFalse((boolean)inboundHandler.isChannelActive());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(channel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
    }

    @Test
    public void streamExceptionTriggersChildChannelExceptionAndClose() throws Exception {
        final LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)channel.isActive());
        Http2Exception.StreamException cause = new Http2Exception.StreamException(channel.stream().id(), Http2Error.PROTOCOL_ERROR, "baaam!");
        this.parentChannel.pipeline().fireExceptionCaught((Throwable)cause);
        Assertions.assertFalse((boolean)channel.isActive());
        Assertions.assertThrows(Http2Exception.StreamException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                inboundHandler.checkException();
            }
        });
    }

    @Test
    public void streamClosedErrorTranslatedToClosedChannelExceptionOnWrites() throws Exception {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        final Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isActive());
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Http2Exception.StreamException(childChannel.stream().id(), Http2Error.STREAM_CLOSED, "Stream Closed"));
            }
        });
        final ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assertions.assertFalse((boolean)childChannel.isActive());
        Assertions.assertFalse((boolean)childChannel.isOpen());
        inboundHandler.checkException();
        Assertions.assertThrows(ClosedChannelException.class, (Executable)new Executable(){

            public void execute() {
                future.syncUninterruptibly();
            }
        });
    }

    @Test
    public void creatingWritingReadingAndClosingOutboundStreamShouldWork() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isActive());
        Assertions.assertTrue((boolean)inboundHandler.isChannelActive());
        Http2Headers headers = new DefaultHttp2Headers().scheme((CharSequence)"https").method((CharSequence)"GET").path((CharSequence)"/foo.txt");
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame(headers));
        this.frameInboundWriter.writeInboundHeaders(childChannel.stream().id(), headers, 0, false);
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Assertions.assertEquals((Object)headers, (Object)headersFrame.headers());
        childChannel.close();
        this.parentChannel.runPendingTasks();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.eqCodecCtx(), Http2MultiplexTest.eqStreamId(childChannel), ArgumentMatchers.anyLong(), Http2TestUtil.anyChannelPromise());
        Assertions.assertFalse((boolean)childChannel.isOpen());
        Assertions.assertFalse((boolean)childChannel.isActive());
        Assertions.assertFalse((boolean)inboundHandler.isChannelActive());
    }

    @Test
    public void failedOutboundStreamCreationThrowsAndClosesChannel() throws Exception {
        LastInboundHandler handler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)handler);
        Assertions.assertTrue((boolean)childChannel.isActive());
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                return ((ChannelPromise)invocationOnMock.getArgument(5)).setFailure((Throwable)new Http2NoMoreStreamIdsException());
            }
        });
        final ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        this.parentChannel.flush();
        Assertions.assertFalse((boolean)childChannel.isActive());
        Assertions.assertFalse((boolean)childChannel.isOpen());
        handler.checkException();
        Assertions.assertThrows(Http2NoMoreStreamIdsException.class, (Executable)new Executable(){

            public void execute() {
                future.syncUninterruptibly();
            }
        });
    }

    @Test
    public void channelClosedWhenCloseListenerCompletes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isOpen());
        Assertions.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        ChannelPromise p = childChannel.newPromise();
        p.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        childChannel.close(p).syncUninterruptibly();
        Assertions.assertFalse((boolean)channelOpen.get());
        Assertions.assertFalse((boolean)channelActive.get());
        Assertions.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedWhenChannelClosePromiseCompletes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isOpen());
        Assertions.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        childChannel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        childChannel.close().syncUninterruptibly();
        Assertions.assertFalse((boolean)channelOpen.get());
        Assertions.assertFalse((boolean)channelActive.get());
        Assertions.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedWhenWriteFutureFails() {
        final ArrayDeque writePromises = new ArrayDeque();
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isOpen());
        Assertions.assertTrue((boolean)childChannel.isActive());
        final AtomicBoolean channelOpen = new AtomicBoolean(true);
        final AtomicBoolean channelActive = new AtomicBoolean(true);
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Mockito.when((Object)this.frameWriter.writeHeaders(this.eqCodecCtx(), ArgumentMatchers.anyInt(), (Http2Headers)ArgumentMatchers.eq((Object)headers), ArgumentMatchers.anyInt(), ArgumentMatchers.anyBoolean(), (ChannelPromise)ArgumentMatchers.any(ChannelPromise.class))).thenAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(5);
                writePromises.offer(promise);
                return promise;
            }
        });
        ChannelFuture f = childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)headers));
        Assertions.assertFalse((boolean)f.isDone());
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                channelOpen.set(future.channel().isOpen());
                channelActive.set(future.channel().isActive());
            }
        });
        ChannelPromise first = (ChannelPromise)writePromises.poll();
        first.setFailure((Throwable)new ClosedChannelException());
        f.awaitUninterruptibly();
        Assertions.assertFalse((boolean)channelOpen.get());
        Assertions.assertFalse((boolean)channelActive.get());
        Assertions.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void channelClosedTwiceMarksPromiseAsSuccessful() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.isOpen());
        Assertions.assertTrue((boolean)childChannel.isActive());
        childChannel.close().syncUninterruptibly();
        childChannel.close().syncUninterruptibly();
        Assertions.assertFalse((boolean)childChannel.isOpen());
        Assertions.assertFalse((boolean)childChannel.isActive());
    }

    @Test
    public void settingChannelOptsAndAttrs() {
        AttributeKey key = AttributeKey.newInstance((String)UUID.randomUUID().toString());
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        childChannel.config().setAutoRead(false).setWriteSpinCount(1000);
        childChannel.attr(key).set((Object)"bar");
        Assertions.assertFalse((boolean)childChannel.config().isAutoRead());
        Assertions.assertEquals((int)1000, (int)childChannel.config().getWriteSpinCount());
        Assertions.assertEquals((Object)"bar", (Object)childChannel.attr(key).get());
    }

    @Test
    public void outboundFlowControlWritability() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        Assertions.assertTrue((boolean)childChannel.isActive());
        Assertions.assertTrue((boolean)childChannel.isWritable());
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assertions.assertTrue((1024 < childChannel.config().getWriteBufferHighWaterMark() ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)childChannel.isWritable());
        childChannel.write((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(0x1000000)));
        Assertions.assertEquals((long)0L, (long)childChannel.bytesBeforeUnwritable());
        Assertions.assertFalse((boolean)childChannel.isWritable());
    }

    @Test
    public void writabilityOfParentIsRespected() {
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter());
        childChannel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(2048, 4096));
        this.parentChannel.config().setWriteBufferWaterMark(new WriteBufferWaterMark(256, 512));
        Assertions.assertTrue((boolean)childChannel.isWritable());
        Assertions.assertTrue((boolean)this.parentChannel.isActive());
        childChannel.writeAndFlush((Object)new DefaultHttp2HeadersFrame((Http2Headers)new DefaultHttp2Headers()));
        this.parentChannel.flush();
        Assertions.assertTrue((boolean)childChannel.isWritable());
        childChannel.write((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(256)));
        Assertions.assertTrue((boolean)childChannel.isWritable());
        childChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero(512)));
        long bytesBeforeUnwritable = childChannel.bytesBeforeUnwritable();
        Assertions.assertNotEquals((long)0L, (long)bytesBeforeUnwritable);
        this.parentChannel.unsafe().outboundBuffer().addMessage((Object)Unpooled.buffer().writeZero(800), 800, this.parentChannel.voidPromise());
        Assertions.assertFalse((boolean)this.parentChannel.isWritable());
        Assertions.assertTrue((boolean)childChannel.isWritable());
        Assertions.assertEquals((long)4097L, (long)childChannel.bytesBeforeUnwritable());
        this.parentChannel.flush();
        Assertions.assertTrue((boolean)this.parentChannel.isWritable());
        Assertions.assertTrue((boolean)childChannel.isWritable());
        Assertions.assertEquals((long)bytesBeforeUnwritable, (long)childChannel.bytesBeforeUnwritable());
        ChannelFuture future = childChannel.writeAndFlush((Object)new DefaultHttp2DataFrame(Unpooled.buffer().writeZero((int)bytesBeforeUnwritable)));
        Assertions.assertFalse((boolean)childChannel.isWritable());
        Assertions.assertTrue((boolean)this.parentChannel.isWritable());
        this.parentChannel.flush();
        Assertions.assertFalse((boolean)future.isDone());
        Assertions.assertTrue((boolean)this.parentChannel.isWritable());
        Assertions.assertFalse((boolean)childChannel.isWritable());
        this.frameInboundWriter.writeInboundWindowUpdate(childChannel.stream().id(), (int)bytesBeforeUnwritable);
        Assertions.assertTrue((boolean)childChannel.isWritable());
        Assertions.assertTrue((boolean)future.isDone());
    }

    @Test
    public void channelClosedWhenInactiveFired() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        final AtomicBoolean channelOpen = new AtomicBoolean(false);
        final AtomicBoolean channelActive = new AtomicBoolean(false);
        Assertions.assertTrue((boolean)childChannel.isOpen());
        Assertions.assertTrue((boolean)childChannel.isActive());
        childChannel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                channelOpen.set(ctx.channel().isOpen());
                channelActive.set(ctx.channel().isActive());
                super.channelInactive(ctx);
            }
        }});
        childChannel.close().syncUninterruptibly();
        Assertions.assertFalse((boolean)channelOpen.get());
        Assertions.assertFalse((boolean)channelActive.get());
    }

    @Test
    public void channelInactiveHappensAfterExceptionCaughtEvents() throws Exception {
        final AtomicInteger count = new AtomicInteger(0);
        final AtomicInteger exceptionCaught = new AtomicInteger(-1);
        final AtomicInteger channelInactive = new AtomicInteger(-1);
        final AtomicInteger channelUnregistered = new AtomicInteger(-1);
        Http2StreamChannel childChannel = this.newOutboundStream((ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                ctx.close();
                throw new Exception("exception");
            }
        });
        childChannel.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                channelInactive.set(count.getAndIncrement());
                super.channelInactive(ctx);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                exceptionCaught.set(count.getAndIncrement());
                super.exceptionCaught(ctx, cause);
            }

            public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
                channelUnregistered.set(count.getAndIncrement());
                super.channelUnregistered(ctx);
            }
        }});
        childChannel.pipeline().fireUserEventTriggered(new Object());
        this.parentChannel.runPendingTasks();
        Assertions.assertEquals((int)0, (int)exceptionCaught.get());
        Assertions.assertEquals((int)1, (int)channelInactive.get());
        Assertions.assertEquals((int)2, (int)channelUnregistered.get());
    }

    @Test
    public void callUnsafeCloseMultipleTimes() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        childChannel.unsafe().close(childChannel.voidPromise());
        ChannelPromise promise = childChannel.newPromise();
        childChannel.unsafe().close(promise);
        promise.syncUninterruptibly();
        childChannel.closeFuture().syncUninterruptibly();
    }

    @Test
    public void endOfStreamDoesNotDiscardData() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assertions.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        shouldDisableAutoRead.set(true);
        childChannel.config().setAutoRead(true);
        numReads.set(1);
        this.frameInboundWriter.writeInboundRstStream(childChannel.stream().id(), Http2Error.NO_ERROR.code());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Http2ResetFrame resetFrame = this.useUserEventForResetFrame() ? (Http2ResetFrame)inboundHandler.readUserEvent() : (Http2ResetFrame)inboundHandler.readInbound();
        Assertions.assertEquals((Object)childChannel.stream(), (Object)resetFrame.stream());
        Assertions.assertEquals((long)Http2Error.NO_ERROR.code(), (long)resetFrame.errorCode());
        Assertions.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        childChannel.closeFuture().syncUninterruptibly();
    }

    protected abstract boolean useUserEventForPriorityFrame();

    protected abstract boolean useUserEventForResetFrame();

    protected abstract boolean ignoreWindowUpdateFrames();

    @Test
    public void windowUpdateFrames() {
        AtomicInteger numReads = new AtomicInteger(1);
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        Assertions.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundWindowUpdate(childChannel.stream().id(), 4);
        Http2WindowUpdateFrame updateFrame = (Http2WindowUpdateFrame)inboundHandler.readInbound();
        if (this.ignoreWindowUpdateFrames()) {
            Assertions.assertNull((Object)updateFrame);
        } else {
            Assertions.assertEquals((Object)new DefaultHttp2WindowUpdateFrame(4).stream(childChannel.stream()), (Object)updateFrame);
        }
        this.frameInboundWriter.writeInboundWindowUpdate(0, 6);
        Assertions.assertNull((Object)this.parentChannel.readInbound());
        childChannel.close().syncUninterruptibly();
    }

    @Test
    public void childQueueIsDrainedAndNewDataIsDispatchedInParentReadLoopAutoRead() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicInteger channelReadCompleteCount = new AtomicInteger(0);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                channelReadCompleteCount.incrementAndGet();
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assertions.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        numReads.set(10);
        shouldDisableAutoRead.set(true);
        childChannel.config().setAutoRead(true);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        Assertions.assertEquals((int)3, (int)channelReadCompleteCount.get());
    }

    @Test
    public void childQueueIsDrainedAndNewDataIsDispatchedInParentReadLoopNoAutoRead() {
        AtomicInteger numReads = new AtomicInteger(1);
        final AtomicInteger channelReadCompleteCount = new AtomicInteger(0);
        final AtomicBoolean shouldDisableAutoRead = new AtomicBoolean();
        LastInboundHandler.Consumer<ChannelHandlerContext> ctxConsumer = new LastInboundHandler.Consumer<ChannelHandlerContext>(){

            @Override
            public void accept(ChannelHandlerContext obj) {
                channelReadCompleteCount.incrementAndGet();
                if (shouldDisableAutoRead.get()) {
                    obj.channel().config().setAutoRead(false);
                }
            }
        };
        LastInboundHandler inboundHandler = new LastInboundHandler(ctxConsumer);
        Http2StreamChannel childChannel = this.newInboundStream(3, false, numReads, (ChannelHandler)inboundHandler);
        childChannel.config().setAutoRead(false);
        DefaultHttp2DataFrame dataFrame1 = new DefaultHttp2DataFrame(Http2TestUtil.bb("1")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame2 = new DefaultHttp2DataFrame(Http2TestUtil.bb("2")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame3 = new DefaultHttp2DataFrame(Http2TestUtil.bb("3")).stream(childChannel.stream());
        DefaultHttp2DataFrame dataFrame4 = new DefaultHttp2DataFrame(Http2TestUtil.bb("4")).stream(childChannel.stream());
        Assertions.assertEquals((Object)new DefaultHttp2HeadersFrame(this.request).stream(childChannel.stream()), inboundHandler.readInbound());
        ChannelInboundHandlerAdapter readCompleteSupressHandler = new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            }
        };
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{readCompleteSupressHandler});
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("1"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame1, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("2"), 0, false);
        numReads.set(2);
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame2, (Http2Frame)inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("3"), 0, false);
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame3, (Http2Frame)inboundHandler.readInbound());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("4"), 0, false);
        Assertions.assertNull(inboundHandler.readInbound());
        childChannel.read();
        Http2TestUtil.assertEqualsAndRelease((Http2Frame)dataFrame4, (Http2Frame)inboundHandler.readInbound());
        Assertions.assertNull(inboundHandler.readInbound());
        this.parentChannel.pipeline().remove((ChannelHandler)readCompleteSupressHandler);
        this.parentChannel.flushInbound();
        Assertions.assertEquals((int)4, (int)channelReadCompleteCount.get());
    }

    @Test
    public void useReadWithoutAutoReadInRead() {
        this.useReadWithoutAutoReadBuffered(false);
    }

    @Test
    public void useReadWithoutAutoReadInReadComplete() {
        this.useReadWithoutAutoReadBuffered(true);
    }

    private void useReadWithoutAutoReadBuffered(final boolean triggerOnReadComplete) {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assertions.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar"), 0, false);
        childChannel.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                super.channelReadComplete(ctx);
                if (triggerOnReadComplete) {
                    ctx.read();
                    ctx.read();
                }
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) {
                ctx.fireChannelRead(msg);
                if (!triggerOnReadComplete) {
                    ctx.read();
                    ctx.read();
                }
            }
        }});
        inboundHandler.channel().read();
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("hello world2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("foo2"), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb("bar2"), 0, true);
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 3);
    }

    @Test
    public void windowUpdatesAreFlushed() {
        LastInboundHandler inboundHandler = new LastInboundHandler();
        FlushSniffer flushSniffer = new FlushSniffer();
        this.parentChannel.pipeline().addFirst(new ChannelHandler[]{flushSniffer});
        Http2StreamChannel childChannel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)childChannel.config().isAutoRead());
        childChannel.config().setAutoRead(false);
        Assertions.assertFalse((boolean)childChannel.config().isAutoRead());
        Http2HeadersFrame headersFrame = (Http2HeadersFrame)inboundHandler.readInbound();
        Assertions.assertNotNull((Object)headersFrame);
        Assertions.assertTrue((boolean)flushSniffer.checkFlush());
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(16384), 0, false);
        this.frameInboundWriter.writeInboundData(childChannel.stream().id(), Http2TestUtil.bb(16384), 0, false);
        Assertions.assertTrue((boolean)flushSniffer.checkFlush());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), Http2TestUtil.anyChannelPromise());
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 1);
        Assertions.assertFalse((boolean)flushSniffer.checkFlush());
        childChannel.read();
        Http2MultiplexTest.verifyFramesMultiplexedToCorrectChannel(childChannel, inboundHandler, 1);
        Assertions.assertTrue((boolean)flushSniffer.checkFlush());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), Http2TestUtil.anyChannelPromise());
        childChannel.read();
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.eq((int)0), ArgumentMatchers.eq((int)32768), Http2TestUtil.anyChannelPromise());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeWindowUpdate(this.eqCodecCtx(), ArgumentMatchers.eq((int)childChannel.stream().id()), ArgumentMatchers.eq((int)32768), Http2TestUtil.anyChannelPromise());
        Assertions.assertTrue((boolean)flushSniffer.checkFlush());
    }

    @ParameterizedTest(name="{displayName} [{index}] value={0}")
    @MethodSource(value={"userEvents"})
    public void userEventsThatPropagatedToChildChannels(Object userEvent) {
        LastInboundHandler inboundParentHandler = new LastInboundHandler();
        LastInboundHandler inboundHandler = new LastInboundHandler();
        Http2StreamChannel channel = this.newInboundStream(3, false, (ChannelHandler)inboundHandler);
        Assertions.assertTrue((boolean)channel.isActive());
        this.parentChannel.pipeline().addLast(new ChannelHandler[]{inboundParentHandler});
        this.parentChannel.pipeline().fireUserEventTriggered(userEvent);
        Assertions.assertEquals((Object)userEvent, inboundHandler.readUserEvent());
        Assertions.assertEquals((Object)userEvent, inboundParentHandler.readUserEvent());
        Assertions.assertNull(inboundHandler.readUserEvent());
        Assertions.assertNull(inboundParentHandler.readUserEvent());
    }

    private static Collection<Object> userEvents() {
        return Arrays.asList(ChannelInputShutdownReadComplete.INSTANCE, ChannelOutputShutdownEvent.INSTANCE, SslCloseCompletionEvent.SUCCESS);
    }

    private static void verifyFramesMultiplexedToCorrectChannel(Http2StreamChannel streamChannel, LastInboundHandler inboundHandler, int numFrames) {
        for (int i = 0; i < numFrames; ++i) {
            Http2StreamFrame frame = (Http2StreamFrame)inboundHandler.readInbound();
            Assertions.assertNotNull((Object)frame, (String)(i + " out of " + numFrames + " received"));
            Assertions.assertEquals((Object)streamChannel.stream(), (Object)frame.stream());
            ReferenceCountUtil.release((Object)frame);
        }
        Assertions.assertNull(inboundHandler.readInbound());
    }

    private static int eqStreamId(Http2StreamChannel channel) {
        return ArgumentMatchers.eq((int)channel.stream().id());
    }

    private static final class FlushSniffer
    extends ChannelOutboundHandlerAdapter {
        private boolean didFlush;

        private FlushSniffer() {
        }

        public boolean checkFlush() {
            boolean r = this.didFlush;
            this.didFlush = false;
            return r;
        }

        public void flush(ChannelHandlerContext ctx) throws Exception {
            this.didFlush = true;
            super.flush(ctx);
        }
    }

    static enum RstFrameTestMode {
        HEADERS_END_STREAM,
        DATA_END_STREAM,
        TRAILERS_END_STREAM;

    }
}

