/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.DefaultChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.Http2ConnectionPrefaceAndSettingsFrameWrittenEvent;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.codec.http2.Http2StreamVisitor;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

public class Http2ConnectionHandlerTest {
    private static final int STREAM_ID = 1;
    private static final int NON_EXISTANT_STREAM_ID = 13;
    private Http2ConnectionHandler handler;
    private ChannelPromise promise;
    private ChannelPromise voidPromise;
    @Mock
    private Http2Connection connection;
    @Mock
    private Http2RemoteFlowController remoteFlow;
    @Mock
    private Http2LocalFlowController localFlow;
    @Mock
    private Http2Connection.Endpoint<Http2RemoteFlowController> remote;
    @Mock
    private Http2RemoteFlowController remoteFlowController;
    @Mock
    private Http2Connection.Endpoint<Http2LocalFlowController> local;
    @Mock
    private Http2LocalFlowController localFlowController;
    @Mock
    private ChannelHandlerContext ctx;
    @Mock
    private EventExecutor executor;
    @Mock
    private Channel channel;
    @Mock
    private ChannelPipeline pipeline;
    @Mock
    private ChannelFuture future;
    @Mock
    private Http2Stream stream;
    @Mock
    private Http2ConnectionDecoder decoder;
    @Mock
    private Http2ConnectionEncoder encoder;
    @Mock
    private Http2FrameWriter frameWriter;
    private String goAwayDebugCap;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.promise = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        this.voidPromise = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        Mockito.when((Object)this.channel.metadata()).thenReturn((Object)new ChannelMetadata(false));
        DefaultChannelConfig config = new DefaultChannelConfig(this.channel);
        Mockito.when((Object)this.channel.config()).thenReturn((Object)config);
        RuntimeException fakeException = new RuntimeException("Fake exception");
        Mockito.when((Object)this.encoder.connection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.decoder.connection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.encoder.frameWriter()).thenReturn((Object)this.frameWriter);
        Mockito.when((Object)this.encoder.flowController()).thenReturn((Object)this.remoteFlow);
        Mockito.when((Object)this.decoder.flowController()).thenReturn((Object)this.localFlow);
        ((Http2FrameWriter)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                ByteBuf buf = (ByteBuf)invocation.getArgument(3);
                Http2ConnectionHandlerTest.this.goAwayDebugCap = buf.toString(CharsetUtil.UTF_8);
                buf.release();
                return Http2ConnectionHandlerTest.this.future;
            }
        }).when((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((ChannelFuture)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                Object o = invocation.getArguments()[0];
                if (o instanceof ChannelFutureListener) {
                    ((ChannelFutureListener)o).operationComplete((Future)Http2ConnectionHandlerTest.this.future);
                }
                return Http2ConnectionHandlerTest.this.future;
            }
        }).when((Object)this.future)).addListener((GenericFutureListener)Mockito.any(GenericFutureListener.class));
        Mockito.when((Object)this.future.cause()).thenReturn((Object)fakeException);
        Mockito.when((Object)this.future.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.pipeline()).thenReturn((Object)this.pipeline);
        Mockito.when((Object)this.connection.remote()).thenReturn(this.remote);
        Mockito.when((Object)this.remote.flowController()).thenReturn((Object)this.remoteFlowController);
        Mockito.when((Object)this.connection.local()).thenReturn(this.local);
        Mockito.when((Object)this.local.flowController()).thenReturn((Object)this.localFlowController);
        ((Http2Connection)Mockito.doAnswer((Answer)new Answer<Http2Stream>(){

            public Http2Stream answer(InvocationOnMock in) throws Throwable {
                Http2StreamVisitor visitor = (Http2StreamVisitor)in.getArgument(0);
                if (!visitor.visit(Http2ConnectionHandlerTest.this.stream)) {
                    return Http2ConnectionHandlerTest.this.stream;
                }
                return null;
            }
        }).when((Object)this.connection)).forEachActiveStream((Http2StreamVisitor)Mockito.any(Http2StreamVisitor.class));
        Mockito.when((Object)this.connection.stream(13)).thenReturn(null);
        Mockito.when((Object)this.connection.numActiveStreams()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.stream(1)).thenReturn((Object)this.stream);
        Mockito.when((Object)this.connection.goAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class))).thenReturn((Object)true);
        Mockito.when((Object)this.stream.open(Mockito.anyBoolean())).thenReturn((Object)this.stream);
        Mockito.when((Object)this.encoder.writeSettings((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (Http2Settings)Mockito.any(Http2Settings.class), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        Mockito.when((Object)this.ctx.alloc()).thenReturn((Object)UnpooledByteBufAllocator.DEFAULT);
        Mockito.when((Object)this.ctx.channel()).thenReturn((Object)this.channel);
        Mockito.when((Object)this.ctx.newSucceededFuture()).thenReturn((Object)this.future);
        Mockito.when((Object)this.ctx.newPromise()).thenReturn((Object)this.promise);
        Mockito.when((Object)this.ctx.voidPromise()).thenReturn((Object)this.voidPromise);
        Mockito.when((Object)this.ctx.write(Mockito.any())).thenReturn((Object)this.future);
        Mockito.when((Object)this.ctx.executor()).thenReturn((Object)this.executor);
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock in) throws Throwable {
                Object msg = in.getArgument(0);
                ReferenceCountUtil.release((Object)msg);
                return null;
            }
        }).when((Object)this.ctx)).fireChannelRead(Mockito.any());
    }

    private Http2ConnectionHandler newHandler(boolean flushPreface) throws Exception {
        Http2ConnectionHandler handler = new Http2ConnectionHandlerBuilder().codec(this.decoder, this.encoder).flushPreface(flushPreface).build();
        handler.handlerAdded(this.ctx);
        return handler;
    }

    private Http2ConnectionHandler newHandler() throws Exception {
        return this.newHandler(true);
    }

    @AfterEach
    public void tearDown() throws Exception {
        if (this.handler != null) {
            this.handler.handlerRemoved(this.ctx);
        }
    }

    @Test
    public void onHttpServerUpgradeWithoutHandlerAdded() throws Exception {
        this.handler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new Http2FrameAdapter()).server(true).build();
        Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2ConnectionHandlerTest.this.handler.onHttpServerUpgrade(new Http2Settings());
            }
        });
        Assertions.assertEquals((Object)Http2Error.INTERNAL_ERROR, (Object)e.error());
    }

    @Test
    public void onHttpClientUpgradeWithoutHandlerAdded() throws Exception {
        this.handler = new Http2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new Http2FrameAdapter()).server(false).build();
        Http2Exception e = (Http2Exception)Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                Http2ConnectionHandlerTest.this.handler.onHttpClientUpgrade();
            }
        });
        Assertions.assertEquals((Object)Http2Error.INTERNAL_ERROR, (Object)e.error());
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void clientShouldveSentPrefaceAndSettingsFrameWhenUserEventIsTriggered(boolean flushPreface) throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler = this.newHandler(flushPreface);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        final Http2ConnectionPrefaceAndSettingsFrameWrittenEvent evt = Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE;
        final AtomicBoolean verified = new AtomicBoolean(false);
        Answer<Object> verifier = new Answer<Object>(){

            public Object answer(InvocationOnMock in) throws Throwable {
                Assertions.assertEquals((Object)in.getArgument(0), (Object)evt);
                ((ChannelHandlerContext)Mockito.verify((Object)Http2ConnectionHandlerTest.this.ctx)).write(Mockito.eq((Object)Http2CodecUtil.connectionPrefaceBuf()));
                ((Http2ConnectionEncoder)Mockito.verify((Object)Http2ConnectionHandlerTest.this.encoder)).writeSettings((ChannelHandlerContext)Mockito.eq((Object)Http2ConnectionHandlerTest.this.ctx), (Http2Settings)Mockito.any(Http2Settings.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
                verified.set(true);
                return null;
            }
        };
        ((ChannelHandlerContext)Mockito.doAnswer((Answer)verifier).when((Object)this.ctx)).fireUserEventTriggered((Object)evt);
        this.handler.channelActive(this.ctx);
        if (flushPreface) {
            ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).flush();
        } else {
            ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).flush();
        }
        Assertions.assertTrue((boolean)verified.get());
    }

    @Test
    public void clientShouldSendClientPrefaceStringWhenActive() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler = this.newHandler();
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        this.handler.channelActive(this.ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).write(Mockito.eq((Object)Http2CodecUtil.connectionPrefaceBuf()));
    }

    @Test
    public void serverShouldNotSendClientPrefaceStringWhenActive() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler = this.newHandler();
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        this.handler.channelActive(this.ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.never())).write(Mockito.eq((Object)Http2CodecUtil.connectionPrefaceBuf()));
    }

    @Test
    public void serverReceivingInvalidClientPrefaceStringShouldHandleException() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        this.handler.channelRead(this.ctx, (Object)Unpooled.copiedBuffer((CharSequence)"BAD_PREFACE", (Charset)CharsetUtil.UTF_8));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ByteBuf)captor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        Assertions.assertEquals((int)0, (int)((ByteBuf)captor.getValue()).refCnt());
    }

    @Test
    public void serverReceivingHttp1ClientPrefaceStringShouldIncludePreface() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        this.handler.channelRead(this.ctx, (Object)Unpooled.copiedBuffer((CharSequence)"GET /path HTTP/1.1", (Charset)CharsetUtil.US_ASCII));
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ByteBuf)captor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        Assertions.assertEquals((int)0, (int)((ByteBuf)captor.getValue()).refCnt());
        Assertions.assertTrue((boolean)this.goAwayDebugCap.contains("/path"));
    }

    @Test
    public void serverReceivingClientPrefaceStringFollowedByNonSettingsShouldHandleException() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        ByteBuf buf = Unpooled.buffer().writeBytes(Http2CodecUtil.connectionPrefaceBuf()).writeZero(10);
        this.handler.channelRead(this.ctx, (Object)buf);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.atLeastOnce())).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ByteBuf)captor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        Assertions.assertEquals((int)0, (int)((ByteBuf)captor.getValue()).refCnt());
    }

    @Test
    public void serverReceivingValidClientPrefaceStringShouldContinueReadingFrames() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        ByteBuf prefacePlusSome = Http2ConnectionHandlerTest.addSettingsHeader(Unpooled.buffer().writeBytes(Http2CodecUtil.connectionPrefaceBuf()));
        this.handler.channelRead(this.ctx, (Object)prefacePlusSome);
        ((Http2ConnectionDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.atLeastOnce())).decodeFrame((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (ByteBuf)Mockito.any(ByteBuf.class), (List)ArgumentMatchers.any());
    }

    @Test
    public void verifyChannelHandlerCanBeReusedInPipeline() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        ByteBuf preface = Http2CodecUtil.connectionPrefaceBuf();
        this.handler.channelRead(this.ctx, (Object)preface);
        ((Http2ConnectionDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.never())).decodeFrame((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), (ByteBuf)Mockito.any(ByteBuf.class), (List)ArgumentMatchers.any());
        this.handler.handlerRemoved(this.ctx);
        this.handler.handlerAdded(this.ctx);
        ByteBuf prefacePlusSome = Http2ConnectionHandlerTest.addSettingsHeader(Unpooled.buffer().writeBytes(Http2CodecUtil.connectionPrefaceBuf()));
        this.handler.channelRead(this.ctx, (Object)prefacePlusSome);
        ((Http2ConnectionDecoder)Mockito.verify((Object)this.decoder, (VerificationMode)Mockito.atLeastOnce())).decodeFrame((ChannelHandlerContext)Mockito.eq((Object)this.ctx), (ByteBuf)Mockito.any(ByteBuf.class), (List)ArgumentMatchers.any());
    }

    @Test
    public void channelInactiveShouldCloseStreams() throws Exception {
        this.handler = this.newHandler();
        this.handler.channelInactive(this.ctx);
        ((Http2Connection)Mockito.verify((Object)this.connection)).close((Promise)Mockito.any(Promise.class));
    }

    @Test
    public void connectionErrorShouldStartShutdown() throws Exception {
        this.handler = this.newHandler();
        Http2Exception e = new Http2Exception(Http2Error.PROTOCOL_ERROR);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ArgumentCaptor captor = ArgumentCaptor.forClass(ByteBuf.class);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)Integer.MAX_VALUE), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ByteBuf)captor.capture(), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((ByteBuf)captor.getValue()).release();
    }

    @Test
    public void serverShouldSend431OnHeaderSizeErrorWhenDecodingInitialHeaders() throws Exception {
        int padding = 0;
        this.handler = this.newHandler();
        Http2Exception.HeaderListSizeException e = new Http2Exception.HeaderListSizeException(1, Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size 8196", true);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)false);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Http2Headers.class);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)captor.capture(), Mockito.eq((int)padding), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)this.promise));
        Http2Headers headers = (Http2Headers)captor.getValue();
        Assertions.assertEquals((Object)HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE.codeAsText(), (Object)headers.status());
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.ctx, 1, Http2Error.PROTOCOL_ERROR.code(), this.promise);
    }

    @Test
    public void serverShouldNeverSend431HeaderSizeErrorWhenEncoding() throws Exception {
        int padding = 0;
        this.handler = this.newHandler();
        Http2Exception.HeaderListSizeException e = new Http2Exception.HeaderListSizeException(1, Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size 8196", false);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)false);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder, (VerificationMode)Mockito.never())).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)padding), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.ctx, 1, Http2Error.PROTOCOL_ERROR.code(), this.promise);
    }

    @Test
    public void clientShouldNeverSend431WhenHeadersAreTooLarge() throws Exception {
        int padding = 0;
        this.handler = this.newHandler();
        Http2Exception.HeaderListSizeException e = new Http2Exception.HeaderListSizeException(1, Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size 8196", true);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)false);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)false);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder, (VerificationMode)Mockito.never())).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)padding), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.ctx, 1, Http2Error.PROTOCOL_ERROR.code(), this.promise);
    }

    @Test
    public void prefaceUserEventProcessed() throws Exception {
        final CountDownLatch latch = new CountDownLatch(1);
        this.handler = new Http2ConnectionHandler(this.decoder, this.encoder, new Http2Settings()){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt == Http2ConnectionPrefaceAndSettingsFrameWrittenEvent.INSTANCE) {
                    latch.countDown();
                }
            }
        };
        this.handler.handlerAdded(this.ctx);
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
    }

    @Test
    public void serverShouldNeverSend431IfHeadersAlreadySent() throws Exception {
        int padding = 0;
        this.handler = this.newHandler();
        Http2Exception.HeaderListSizeException e = new Http2Exception.HeaderListSizeException(1, Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size 8196", true);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)true);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder, (VerificationMode)Mockito.never())).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)padding), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.ctx, 1, Http2Error.PROTOCOL_ERROR.code(), this.promise);
    }

    @Test
    public void serverShouldCreateStreamIfNeededBeforeSending431() throws Exception {
        int padding = 0;
        this.handler = this.newHandler();
        Http2Exception.HeaderListSizeException e = new Http2Exception.HeaderListSizeException(1, Http2Error.PROTOCOL_ERROR, "Header size exceeded max allowed size 8196", true);
        Mockito.when((Object)this.connection.stream(1)).thenReturn(null);
        Mockito.when((Object)this.remote.createStream(1, true)).thenReturn((Object)this.stream);
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)false);
        Mockito.when((Object)this.remote.lastStreamCreated()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)Http2Error.PROTOCOL_ERROR.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.exceptionCaught(this.ctx, (Throwable)e);
        ((Http2Connection.Endpoint)Mockito.verify(this.remote)).createStream(1, true);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).writeHeaders((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), (Http2Headers)Mockito.any(Http2Headers.class), Mockito.eq((int)padding), Mockito.eq((boolean)true), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream(this.ctx, 1, Http2Error.PROTOCOL_ERROR.code(), this.promise);
    }

    @Test
    public void encoderAndDecoderAreClosedOnChannelInactive() throws Exception {
        this.handler = this.newHandler();
        this.handler.channelActive(this.ctx);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler.channelInactive(this.ctx);
        ((Http2ConnectionEncoder)Mockito.verify((Object)this.encoder)).close();
        ((Http2ConnectionDecoder)Mockito.verify((Object)this.decoder)).close();
    }

    @Test
    public void writeRstOnNonExistantStreamShouldSucceed() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)13), Mockito.eq((long)Http2Error.STREAM_CLOSED.code()), (ChannelPromise)Mockito.eq((Object)this.promise))).thenReturn((Object)this.future);
        this.handler.resetStream(this.ctx, 13, Http2Error.STREAM_CLOSED.code(), this.promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)13), Mockito.eq((long)Http2Error.STREAM_CLOSED.code()), (ChannelPromise)Mockito.eq((Object)this.promise));
    }

    @Test
    public void writeRstOnClosedStreamShouldSucceed() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).thenReturn((Object)this.future);
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.CLOSED);
        Mockito.when((Object)this.stream.isHeadersSent()).thenReturn((Object)true);
        this.handler.resetStream(this.ctx, 1, Http2Error.STREAM_CLOSED.code(), this.promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    public void writeRstOnIdleStreamShouldNotWriteButStillSucceed() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.stream.state()).thenReturn((Object)Http2Stream.State.IDLE);
        this.handler.resetStream(this.ctx, 1, Http2Error.STREAM_CLOSED.code(), this.promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((Http2Stream)Mockito.verify((Object)this.stream)).close();
    }

    @Test
    public void closeListenerShouldBeNotifiedOnlyOneTime() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.future.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
        ((ChannelFuture)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                GenericFutureListener listener = (GenericFutureListener)args[0];
                ((Http2Connection)Mockito.doAnswer((Answer)new Answer<Http2Stream>(){

                    public Http2Stream answer(InvocationOnMock in) throws Throwable {
                        return null;
                    }
                }).when((Object)Http2ConnectionHandlerTest.this.connection)).forEachActiveStream((Http2StreamVisitor)Mockito.any(Http2StreamVisitor.class));
                Mockito.when((Object)Http2ConnectionHandlerTest.this.connection.numActiveStreams()).thenReturn((Object)0);
                listener.operationComplete((Future)Http2ConnectionHandlerTest.this.future);
                return Http2ConnectionHandlerTest.this.future;
            }
        }).when((Object)this.future)).addListener((GenericFutureListener)Mockito.any(GenericFutureListener.class));
        this.handler.close(this.ctx, this.promise);
        if (this.future.isDone()) {
            Mockito.when((Object)this.connection.numActiveStreams()).thenReturn((Object)0);
        }
        this.handler.closeStream(this.stream, this.future);
        this.handler.closeStream(this.stream, this.future);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).close((ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    public void canSendGoAwayFrame() throws Exception {
        ByteBuf data = Http2ConnectionHandlerTest.dummyData();
        long errorCode = Http2Error.INTERNAL_ERROR.code();
        Mockito.when((Object)this.future.isDone()).thenReturn((Object)true);
        Mockito.when((Object)this.future.isSuccess()).thenReturn((Object)true);
        ((ChannelFuture)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ((GenericFutureListener)invocation.getArgument(0)).operationComplete((Future)Http2ConnectionHandlerTest.this.future);
                return null;
            }
        }).when((Object)this.future)).addListener((GenericFutureListener)Mockito.any(GenericFutureListener.class));
        this.handler = this.newHandler();
        this.handler.goAway(this.ctx, 1, errorCode, data, this.promise);
        ((Http2Connection)Mockito.verify((Object)this.connection)).goAwaySent(Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx)).close();
        Assertions.assertEquals((int)0, (int)data.refCnt());
    }

    @Test
    public void canSendGoAwayFramesWithDecreasingLastStreamIds() throws Exception {
        this.handler = this.newHandler();
        ByteBuf data = Http2ConnectionHandlerTest.dummyData();
        long errorCode = Http2Error.INTERNAL_ERROR.code();
        this.handler.goAway(this.ctx, 3, errorCode, data.retain(), this.promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)3), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2Connection)Mockito.verify((Object)this.connection)).goAwaySent(Mockito.eq((int)3), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data));
        this.promise = new DefaultChannelPromise(this.channel);
        this.handler.goAway(this.ctx, 1, errorCode, data, this.promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data), (ChannelPromise)Mockito.eq((Object)this.promise));
        ((Http2Connection)Mockito.verify((Object)this.connection)).goAwaySent(Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data));
        Assertions.assertEquals((int)0, (int)data.refCnt());
    }

    @Test
    public void cannotSendGoAwayFrameWithIncreasingLastStreamIds() throws Exception {
        this.handler = this.newHandler();
        ByteBuf data = Http2ConnectionHandlerTest.dummyData();
        long errorCode = Http2Error.INTERNAL_ERROR.code();
        this.handler.goAway(this.ctx, 1, errorCode, data.retain(), this.promise);
        ((Http2Connection)Mockito.verify((Object)this.connection)).goAwaySent(Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.eq((long)errorCode), (ByteBuf)Mockito.eq((Object)data), (ChannelPromise)Mockito.eq((Object)this.promise));
        Assertions.assertFalse((boolean)this.promise.isDone());
        Mockito.when((Object)this.connection.goAwaySent()).thenReturn((Object)true);
        Mockito.when((Object)this.remote.lastStreamKnownByPeer()).thenReturn((Object)1);
        ((Http2Connection)Mockito.doAnswer((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) {
                throw new IllegalStateException();
            }
        }).when((Object)this.connection)).goAwaySent(Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class));
        this.handler.goAway(this.ctx, 3, errorCode, data, this.promise);
        Assertions.assertTrue((boolean)this.promise.isDone());
        Assertions.assertFalse((boolean)this.promise.isSuccess());
        Assertions.assertEquals((int)0, (int)data.refCnt());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.frameWriter});
    }

    @Test
    public void canSendGoAwayUsingVoidPromise() throws Exception {
        this.handler = this.newHandler();
        ByteBuf data = Http2ConnectionHandlerTest.dummyData();
        long errorCode = Http2Error.INTERNAL_ERROR.code();
        this.handler = this.newHandler();
        final RuntimeException cause = new RuntimeException("fake exception");
        ((Http2FrameWriter)Mockito.doAnswer((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocation) throws Throwable {
                ChannelPromise promise = (ChannelPromise)invocation.getArgument(4);
                Assertions.assertFalse((boolean)promise.isVoid());
                Http2CodecUtil.SimpleChannelPromiseAggregator aggregatedPromise = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, Http2ConnectionHandlerTest.this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
                aggregatedPromise.newPromise();
                aggregatedPromise.doneAllocatingPromises();
                return aggregatedPromise.setFailure(cause);
            }
        }).when((Object)this.frameWriter)).writeGoAway((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        this.handler.goAway(this.ctx, 1, errorCode, data, Http2TestUtil.newVoidPromise(this.channel));
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).fireExceptionCaught((Throwable)cause);
    }

    @Test
    public void canCloseStreamWithVoidPromise() throws Exception {
        this.handler = this.newHandler();
        this.handler.closeStream(this.stream, (ChannelFuture)this.ctx.voidPromise().setSuccess());
        ((Http2Stream)Mockito.verify((Object)this.stream, (VerificationMode)Mockito.times((int)1))).close();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stream});
    }

    @Test
    public void channelReadCompleteTriggersFlush() throws Exception {
        this.handler = this.newHandler();
        this.handler.channelReadComplete(this.ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).flush();
    }

    @Test
    public void channelReadCompleteCallsReadWhenAutoReadFalse() throws Exception {
        this.channel.config().setAutoRead(false);
        this.handler = this.newHandler();
        this.handler.channelReadComplete(this.ctx);
        ((ChannelHandlerContext)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.times((int)1))).read();
    }

    @Test
    public void channelClosedDoesNotThrowPrefaceException() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)true);
        this.handler = this.newHandler();
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler.channelInactive(this.ctx);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeGoAway((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ByteBuf)Mockito.any(ByteBuf.class), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter, (VerificationMode)Mockito.never())).writeRstStream((ChannelHandlerContext)Mockito.any(ChannelHandlerContext.class), Mockito.anyInt(), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class));
    }

    @Test
    public void clientChannelClosedDoesNotSendGoAwayBeforePreface() throws Exception {
        Mockito.when((Object)this.connection.isServer()).thenReturn((Object)false);
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)false);
        this.handler = this.newHandler();
        Mockito.when((Object)this.channel.isActive()).thenReturn((Object)true);
        this.handler.close(this.ctx, this.promise);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.frameWriter});
    }

    @Test
    public void writeRstStreamForUnknownStreamUsingVoidPromise() throws Exception {
        this.writeRstStreamUsingVoidPromise(13);
    }

    @Test
    public void writeRstStreamForKnownStreamUsingVoidPromise() throws Exception {
        this.writeRstStreamUsingVoidPromise(1);
    }

    @Test
    public void gracefulShutdownTimeoutWhenConnectionErrorHardShutdownTest() throws Exception {
        this.gracefulShutdownTimeoutWhenConnectionErrorTest0(Http2Exception.ShutdownHint.HARD_SHUTDOWN);
    }

    @Test
    public void gracefulShutdownTimeoutWhenConnectionErrorGracefulShutdownTest() throws Exception {
        this.gracefulShutdownTimeoutWhenConnectionErrorTest0(Http2Exception.ShutdownHint.GRACEFUL_SHUTDOWN);
    }

    private void gracefulShutdownTimeoutWhenConnectionErrorTest0(Http2Exception.ShutdownHint hint) throws Exception {
        this.handler = this.newHandler();
        long expectedMillis = 1234L;
        this.handler.gracefulShutdownTimeoutMillis(1234L);
        Http2Exception exception = new Http2Exception(Http2Error.PROTOCOL_ERROR, "Test error", hint);
        this.handler.onConnectionError(this.ctx, false, (Throwable)exception, exception);
        ((EventExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)1234L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void gracefulShutdownTimeoutTest() throws Exception {
        this.handler = this.newHandler();
        long expectedMillis = 1234L;
        this.handler.gracefulShutdownTimeoutMillis(1234L);
        this.handler.close(this.ctx, this.promise);
        ((EventExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)1234L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void gracefulShutdownTimeoutNoActiveStreams() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.connection.numActiveStreams()).thenReturn((Object)0);
        long expectedMillis = 1234L;
        this.handler.gracefulShutdownTimeoutMillis(1234L);
        this.handler.close(this.ctx, this.promise);
        ((EventExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeastOnce())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.eq((long)1234L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
    }

    @Test
    public void gracefulShutdownIndefiniteTimeoutTest() throws Exception {
        this.handler = this.newHandler();
        this.handler.gracefulShutdownTimeoutMillis(-1L);
        this.handler.close(this.ctx, this.promise);
        ((EventExecutor)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).schedule((Runnable)Mockito.any(Runnable.class), Mockito.anyLong(), (TimeUnit)((Object)Mockito.any(TimeUnit.class)));
    }

    @Test
    public void writeMultipleRstFramesForSameStream() throws Exception {
        this.handler = this.newHandler();
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        final AtomicBoolean resetSent = new AtomicBoolean();
        Mockito.when((Object)this.stream.resetSent()).then((Answer)new Answer<Http2Stream>(){

            public Http2Stream answer(InvocationOnMock invocationOnMock) {
                resetSent.set(true);
                return Http2ConnectionHandlerTest.this.stream;
            }
        });
        Mockito.when((Object)this.stream.isResetSent()).then((Answer)new Answer<Boolean>(){

            public Boolean answer(InvocationOnMock invocationOnMock) {
                return resetSent.get();
            }
        });
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) throws Throwable {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(3);
                return promise.setSuccess();
            }
        });
        DefaultChannelPromise promise = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        DefaultChannelPromise promise2 = new DefaultChannelPromise(this.channel, (EventExecutor)ImmediateEventExecutor.INSTANCE);
        promise.addListener((GenericFutureListener)new ChannelFutureListener((ChannelPromise)promise2){
            final /* synthetic */ ChannelPromise val$promise2;
            {
                this.val$promise2 = channelPromise;
            }

            public void operationComplete(ChannelFuture future) {
                Http2ConnectionHandlerTest.this.handler.resetStream(Http2ConnectionHandlerTest.this.ctx, 1, Http2Error.STREAM_CLOSED.code(), this.val$promise2);
            }
        });
        this.handler.resetStream(this.ctx, 1, Http2Error.CANCEL.code(), (ChannelPromise)promise);
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)1), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class));
        Assertions.assertTrue((boolean)promise.isSuccess());
        Assertions.assertTrue((boolean)promise2.isSuccess());
    }

    private void writeRstStreamUsingVoidPromise(int streamId) throws Exception {
        this.handler = this.newHandler();
        final RuntimeException cause = new RuntimeException("fake exception");
        Mockito.when((Object)this.stream.id()).thenReturn((Object)1);
        Mockito.when((Object)this.frameWriter.writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)streamId), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class))).then((Answer)new Answer<ChannelFuture>(){

            public ChannelFuture answer(InvocationOnMock invocationOnMock) throws Throwable {
                ChannelPromise promise = (ChannelPromise)invocationOnMock.getArgument(3);
                Assertions.assertFalse((boolean)promise.isVoid());
                return promise.setFailure(cause);
            }
        });
        this.handler.resetStream(this.ctx, streamId, Http2Error.STREAM_CLOSED.code(), Http2TestUtil.newVoidPromise(this.channel));
        ((Http2FrameWriter)Mockito.verify((Object)this.frameWriter)).writeRstStream((ChannelHandlerContext)Mockito.eq((Object)this.ctx), Mockito.eq((int)streamId), Mockito.anyLong(), (ChannelPromise)Mockito.any(ChannelPromise.class));
        ((ChannelPipeline)Mockito.verify((Object)this.pipeline)).fireExceptionCaught((Throwable)cause);
    }

    private static ByteBuf dummyData() {
        return Unpooled.buffer().writeBytes("abcdefgh".getBytes(CharsetUtil.UTF_8));
    }

    private static ByteBuf addSettingsHeader(ByteBuf buf) {
        buf.writeMedium(6);
        buf.writeByte(4);
        buf.writeByte(0);
        buf.writeInt(0);
        return buf;
    }
}

