/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.DefaultHttp2HeadersDecoder;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.Http2TestUtil;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class DefaultHttp2HeadersDecoderTest {
    private DefaultHttp2HeadersDecoder decoder;

    @BeforeEach
    public void setup() {
        this.decoder = new DefaultHttp2HeadersDecoder(false);
    }

    @Test
    public void decodeShouldSucceed() throws Exception {
        ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("akey"), DefaultHttp2HeadersDecoderTest.b("avalue"), Http2TestUtil.randomBytes(), Http2TestUtil.randomBytes());
        try {
            Http2Headers headers = this.decoder.decodeHeaders(0, buf);
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)headers.size());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"GET", (Object)headers.method().toString());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"avalue", (Object)((CharSequence)headers.get((Object)new AsciiString((CharSequence)"akey"))).toString());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void testExceedHeaderSize() throws Exception {
        int maxListSize = 100;
        this.decoder.configuration().maxHeaderListSize(100L, 100L);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(Http2TestUtil.randomBytes(100), Http2TestUtil.randomBytes(1));
        try {
            org.junit.jupiter.api.Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(0, buf);
                }
            });
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0xFFFFFFFFL);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        Http2Exception.HeaderListSizeException e = (Http2Exception.HeaderListSizeException)org.junit.jupiter.api.Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable(){

            public void execute() throws Throwable {
                DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
            }
        });
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)e.streamId());
        buf.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeButLessThanGoAwayWithInitialDecoderSettings() throws Exception {
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), DefaultHttp2HeadersDecoderTest.b(String.format("%09000d", 0).replace('0', 'A')));
        boolean streamId = true;
        try {
            Http2Exception.HeaderListSizeException e = (Http2Exception.HeaderListSizeException)org.junit.jupiter.api.Assertions.assertThrows(Http2Exception.HeaderListSizeException.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)e.streamId());
        }
        finally {
            buf.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void decodeLargerThanHeaderListSizeGoAway() throws Exception {
        this.decoder.maxHeaderListSize(0L, 0L);
        final ByteBuf buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"));
        boolean streamId = true;
        try {
            Http2Exception e = (Http2Exception)org.junit.jupiter.api.Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    DefaultHttp2HeadersDecoderTest.this.decoder.decodeHeaders(1, buf);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((Object)Http2Error.PROTOCOL_ERROR, (Object)e.error());
        }
        finally {
            buf.release();
        }
    }

    @Test
    public void duplicatePseudoHeadersMustFailValidation() throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":authority"), DefaultHttp2HeadersDecoderTest.b("abc"), DefaultHttp2HeadersDecoderTest.b(":authority"), DefaultHttp2HeadersDecoderTest.b("def")));
    }

    @Test
    public void decodingTrailersTeHeaderMustNotFailValidation() throws Exception {
        ByteBuf buf = null;
        try {
            buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("te"), DefaultHttp2HeadersDecoderTest.b("trailers"));
            Http2Headers headers = this.decoder.decodeHeaders(1, buf);
            Assertions.assertThat((CharSequence)((CharSequence)headers.get((Object)HttpHeaderNames.TE))).isEqualToIgnoringCase((CharSequence)HttpHeaderValues.TRAILERS);
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
    }

    @Test
    public void decodingConnectionRelatedHeadersMustFailValidation() throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true, true);
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("keep-alive"), DefaultHttp2HeadersDecoderTest.b("timeout=5")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("connection"), DefaultHttp2HeadersDecoderTest.b("keep-alive"), DefaultHttp2HeadersDecoderTest.b("keep-alive"), DefaultHttp2HeadersDecoderTest.b("timeout=5")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("transfer-encoding"), DefaultHttp2HeadersDecoderTest.b("chunked")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("connection"), DefaultHttp2HeadersDecoderTest.b("transfer-encoding"), DefaultHttp2HeadersDecoderTest.b("transfer-encoding"), DefaultHttp2HeadersDecoderTest.b("chunked")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("upgrade"), DefaultHttp2HeadersDecoderTest.b("foo/2")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("connection"), DefaultHttp2HeadersDecoderTest.b("upgrade"), DefaultHttp2HeadersDecoderTest.b("upgrade"), DefaultHttp2HeadersDecoderTest.b("foo/2")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("connection"), DefaultHttp2HeadersDecoderTest.b("close")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("proxy-connection"), DefaultHttp2HeadersDecoderTest.b("keep-alive")));
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("te"), DefaultHttp2HeadersDecoderTest.b("compress")));
    }

    public static List<Integer> illegalFirstChar() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 33; ++i) {
            list.add(i);
        }
        list.add(127);
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"illegalFirstChar"})
    void decodingInvalidHeaderValueMustFailValidationIfFirstCharIsIllegal(int illegalFirstChar) throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true, true);
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), {(byte)illegalFirstChar, 97}));
    }

    public static List<Integer> illegalNotFirstChar() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < 33; ++i) {
            if (i == 32 || i == 9) continue;
            list.add(i);
        }
        list.add(127);
        return list;
    }

    @ParameterizedTest
    @MethodSource(value={"illegalNotFirstChar"})
    void decodingInvalidHeaderValueMustFailValidationIfANotFirstCharIsIllegal(int illegalSecondChar) throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true, true);
        DefaultHttp2HeadersDecoderTest.verifyValidationFails(decoder, DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), {97, (byte)illegalSecondChar}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void headerValuesAllowSpaceAfterFirstCharacter() throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
        ByteBuf buf = null;
        try {
            buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), DefaultHttp2HeadersDecoderTest.b("a b"));
            Http2Headers headers = decoder.decodeHeaders(1, buf);
            Assertions.assertThat((CharSequence)((CharSequence)headers.get((Object)"test_header"))).isEqualToIgnoringCase((CharSequence)"a b");
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void headerValuesAllowHorzontalTabAfterFirstCharacter() throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
        ByteBuf buf = null;
        try {
            buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), DefaultHttp2HeadersDecoderTest.b("a\tb"));
            Http2Headers headers = decoder.decodeHeaders(1, buf);
            Assertions.assertThat((CharSequence)((CharSequence)headers.get((Object)"test_header"))).isEqualToIgnoringCase((CharSequence)"a\tb");
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
    }

    public static List<Integer> validObsText() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 128; i <= 255; ++i) {
            list.add(i);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"validObsText"})
    void headerValuesAllowObsTextInFirstChar(int i) throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
        ByteBuf buf = null;
        try {
            byte[] bytes = new byte[]{(byte)i, 97};
            buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), bytes);
            Http2Headers headers = decoder.decodeHeaders(1, buf);
            Assertions.assertThat((CharSequence)((CharSequence)headers.get((Object)"test_header"))).isEqualTo((Object)new AsciiString(bytes));
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ParameterizedTest
    @MethodSource(value={"validObsText"})
    void headerValuesAllowObsTextInNonFirstChar(int i) throws Exception {
        DefaultHttp2HeadersDecoder decoder = new DefaultHttp2HeadersDecoder(true);
        ByteBuf buf = null;
        try {
            byte[] bytes = new byte[]{97, (byte)i};
            buf = DefaultHttp2HeadersDecoderTest.encode(DefaultHttp2HeadersDecoderTest.b(":method"), DefaultHttp2HeadersDecoderTest.b("GET"), DefaultHttp2HeadersDecoderTest.b("test_header"), bytes);
            Http2Headers headers = decoder.decodeHeaders(1, buf);
            Assertions.assertThat((CharSequence)((CharSequence)headers.get((Object)"test_header"))).isEqualTo((Object)new AsciiString(bytes));
        }
        catch (Throwable throwable) {
            ReferenceCountUtil.release(buf);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)buf);
    }

    private static void verifyValidationFails(final DefaultHttp2HeadersDecoder decoder, final ByteBuf buf) {
        try {
            Http2Exception e = (Http2Exception)org.junit.jupiter.api.Assertions.assertThrows(Http2Exception.class, (Executable)new Executable(){

                public void execute() throws Throwable {
                    decoder.decodeHeaders(1, buf);
                }
            });
            org.junit.jupiter.api.Assertions.assertEquals((Object)Http2Error.PROTOCOL_ERROR, (Object)e.error());
        }
        finally {
            buf.release();
        }
    }

    private static byte[] b(String string) {
        return string.getBytes(CharsetUtil.UTF_8);
    }

    private static ByteBuf encode(byte[] ... entries) throws Exception {
        HpackEncoder hpackEncoder = Http2TestUtil.newTestEncoder();
        ByteBuf out = Unpooled.buffer();
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers(false);
        int ix = 0;
        while (ix < entries.length) {
            http2Headers.add((Object)new AsciiString(entries[ix++], false), (Object)new AsciiString(entries[ix++], false));
        }
        hpackEncoder.encodeHeaders(3, out, (Http2Headers)http2Headers, Http2HeadersEncoder.NEVER_SENSITIVE);
        return out;
    }
}

