/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.http2.DecoratingHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2FrameListener;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public abstract class AbstractDecoratingHttp2ConnectionDecoderTest {
    protected abstract DecoratingHttp2ConnectionDecoder newDecoder(Http2ConnectionDecoder var1);

    protected abstract Class<? extends Http2FrameListener> delegatingFrameListenerType();

    @Test
    public void testDecoration() {
        Http2ConnectionDecoder delegate = (Http2ConnectionDecoder)Mockito.mock(Http2ConnectionDecoder.class);
        final ArgumentCaptor listenerArgumentCaptor = ArgumentCaptor.forClass(Http2FrameListener.class);
        Mockito.when((Object)delegate.frameListener()).then((Answer)new Answer<Http2FrameListener>(){

            public Http2FrameListener answer(InvocationOnMock invocationOnMock) {
                return (Http2FrameListener)listenerArgumentCaptor.getValue();
            }
        });
        Http2FrameListener listener = (Http2FrameListener)Mockito.mock(Http2FrameListener.class);
        DecoratingHttp2ConnectionDecoder decoder = this.newDecoder(delegate);
        decoder.frameListener(listener);
        ((Http2ConnectionDecoder)Mockito.verify((Object)delegate)).frameListener((Http2FrameListener)listenerArgumentCaptor.capture());
        MatcherAssert.assertThat((Object)decoder.frameListener(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(this.delegatingFrameListenerType())));
    }

    @Test
    public void testDecorationWithNull() {
        Http2ConnectionDecoder delegate = (Http2ConnectionDecoder)Mockito.mock(Http2ConnectionDecoder.class);
        DecoratingHttp2ConnectionDecoder decoder = this.newDecoder(delegate);
        decoder.frameListener(null);
        Assertions.assertNull((Object)decoder.frameListener());
    }
}

