/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public final class OHttpServerPublicKeys
implements Iterable<Map.Entry<Byte, OHttpKey.PublicKey>> {
    private final Map<Byte, OHttpKey.PublicKey> keys;

    public OHttpServerPublicKeys(Map<Byte, OHttpKey.PublicKey> keys) {
        this.keys = Collections.unmodifiableMap(Objects.requireNonNull(keys, "keys"));
    }

    public Collection<OHttpKey.PublicKey> keys() {
        return this.keys.values();
    }

    public OHttpKey.PublicKey key(byte keyId) {
        return this.keys.get(keyId);
    }

    @Override
    public Iterator<Map.Entry<Byte, OHttpKey.PublicKey>> iterator() {
        return this.keys.entrySet().iterator();
    }

    public String toString() {
        return this.keys.values().stream().map(k -> "{ciphers=" + k.ciphersuites().stream().map(OHttpCiphersuite::toString).collect(Collectors.joining(", ", "[", "]")) + ", publicKey=" + ByteBufUtil.hexDump((byte[])k.pkEncoded()) + "}").collect(Collectors.joining(", ", "[", "]"));
    }

    public static OHttpServerPublicKeys decode(ByteBuf input) throws CryptoException {
        HashMap<Byte, OHttpKey.PublicKey> keys = new HashMap<Byte, OHttpKey.PublicKey>();
        while (input.isReadable()) {
            byte keyId = input.readByte();
            OHttpCryptoProvider.KEM kem = OHttpCryptoProvider.KEM.forId((short)input.readShort());
            byte[] publicKeyBytes = new byte[kem.npk()];
            input.readBytes(publicKeyBytes);
            short len = input.readShort();
            ByteBuf ecInput = input.readSlice((int)len);
            ArrayList<OHttpKey.Cipher> ciphers = new ArrayList<OHttpKey.Cipher>();
            while (ecInput.isReadable()) {
                OHttpCryptoProvider.KDF kdf = OHttpCryptoProvider.KDF.forId((short)ecInput.readShort());
                OHttpCryptoProvider.AEAD aead = OHttpCryptoProvider.AEAD.forId((short)ecInput.readShort());
                ciphers.add(OHttpKey.newCipher(kdf, aead));
            }
            OHttpKey.PublicKey publicKey = OHttpKey.newPublicKey(keyId, kem, ciphers, publicKeyBytes);
            keys.put(keyId, publicKey);
        }
        return new OHttpServerPublicKeys(keys);
    }
}

