/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.AsymmetricKeyParameter;
import io.netty.incubator.codec.hpke.CryptoDecryptContext;
import io.netty.incubator.codec.hpke.CryptoEncryptContext;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HPKESenderContext;
import io.netty.incubator.codec.hpke.OHttpCryptoProvider;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpCrypto;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.util.Objects;

public final class OHttpCryptoSender
extends OHttpCrypto {
    private final OHttpCryptoConfiguration configuration;
    private final OHttpCiphersuite ciphersuite;
    private final OHttpCryptoProvider provider;
    private final HPKESenderContext context;
    private CryptoDecryptContext aead;

    public static Builder newBuilder() {
        return new Builder();
    }

    private OHttpCryptoSender(Builder builder) {
        this.configuration = Objects.requireNonNull(builder.configuration, "configuration");
        this.ciphersuite = Objects.requireNonNull(builder.ciphersuite, "ciphersuite");
        this.provider = Objects.requireNonNull(builder.provider, "provider");
        AsymmetricKeyParameter pkR = Objects.requireNonNull(builder.receiverPublicKey, "receiverPublicKey");
        AsymmetricCipherKeyPair forcedEphemeralKeyPair = builder.forcedEphemeralKeyPair;
        this.context = this.provider.setupHPKEBaseS(OHttpCryptoProvider.Mode.Base, this.ciphersuite.kem(), this.ciphersuite.kdf(), this.ciphersuite.aead(), pkR, this.ciphersuite.createInfo(this.configuration), forcedEphemeralKeyPair);
    }

    public OHttpCiphersuite ciphersuite() {
        return this.ciphersuite;
    }

    public void writeHeader(ByteBuf out) {
        this.ciphersuite.encode(out);
        out.writeBytes(this.context.encapsulation());
    }

    public boolean readResponseNonce(ByteBuf in) {
        if (in.readableBytes() < this.ciphersuite().responseNonceLength()) {
            return false;
        }
        byte[] responseNonce = new byte[this.ciphersuite().responseNonceLength()];
        in.readBytes(responseNonce);
        this.aead = this.ciphersuite.createResponseAead(this.provider, (HPKEContext)this.context, this.context.encapsulation(), responseNonce, this.configuration);
        return true;
    }

    @Override
    protected CryptoEncryptContext encryptCrypto() {
        return this.context;
    }

    @Override
    protected CryptoDecryptContext decryptCrypto() {
        return this.aead;
    }

    @Override
    protected OHttpCryptoConfiguration configuration() {
        return this.configuration;
    }

    public static final class Builder {
        private OHttpCryptoProvider provider;
        private OHttpCryptoConfiguration configuration;
        private OHttpCiphersuite ciphersuite;
        private AsymmetricKeyParameter receiverPublicKey;
        private AsymmetricCipherKeyPair forcedEphemeralKeyPair;

        public Builder setOHttpCryptoProvider(OHttpCryptoProvider provider) {
            this.provider = provider;
            return this;
        }

        public Builder setConfiguration(OHttpCryptoConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder setCiphersuite(OHttpCiphersuite value) {
            this.ciphersuite = value;
            return this;
        }

        public Builder setReceiverPublicKey(AsymmetricKeyParameter value) {
            this.receiverPublicKey = value;
            return this;
        }

        Builder setForcedEphemeralKeyPair(AsymmetricCipherKeyPair value) {
            this.forcedEphemeralKeyPair = value;
            return this;
        }

        public OHttpCryptoSender build() {
            return new OHttpCryptoSender(this);
        }

        private Builder() {
        }
    }
}

