/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.VarIntCodecUtils;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.ohttp.OHttpChunkFramer;
import io.netty.incubator.codec.ohttp.OHttpConstants;
import io.netty.incubator.codec.ohttp.OHttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.internal.ObjectUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class OHttpVersionChunkDraft
implements OHttpVersion {
    public static final OHttpVersion INSTANCE = new OHttpVersionChunkDraft(0x100000);
    private static final byte[] CHUNKED_REQUEST_EXPORT_CONTEXT = "message/bhttp chunked request".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] CHUNKED_RESPONSE_EXPORT_CONTEXT = "message/bhttp chunked response".getBytes(StandardCharsets.US_ASCII);
    private final int maxChunkSize;

    public OHttpVersionChunkDraft(int maxChunkSize) {
        this.maxChunkSize = ObjectUtil.checkPositive((int)maxChunkSize, (String)"maxChunkSize");
    }

    @Override
    public byte[] requestExportContext() {
        return (byte[])CHUNKED_REQUEST_EXPORT_CONTEXT.clone();
    }

    @Override
    public byte[] responseExportContext() {
        return (byte[])CHUNKED_RESPONSE_EXPORT_CONTEXT.clone();
    }

    @Override
    public boolean useFinalAad() {
        return true;
    }

    @Override
    public AsciiString requestContentType() {
        return OHttpConstants.CHUNKED_REQUEST_CONTENT_TYPE;
    }

    @Override
    public AsciiString responseContentType() {
        return OHttpConstants.CHUNKED_RESPONSE_CONTENT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ChunkInfo parseNextChunk(ByteBuf in, boolean isLast, int maxChunkSize) {
        if (!in.isReadable()) {
            return null;
        }
        int initialReaderIndex = in.readerIndex();
        ChunkInfo info = null;
        try {
            byte firstByte = in.getByte(initialReaderIndex);
            int lengthNumBytes = VarIntCodecUtils.numBytesForVariableLengthIntegerFromByte((byte)firstByte);
            if (in.readableBytes() < lengthNumBytes) {
                ChunkInfo chunkInfo = null;
                return chunkInfo;
            }
            long contentLength = VarIntCodecUtils.readVariableLengthInteger((ByteBuf)in, (int)lengthNumBytes);
            if (contentLength > (long)maxChunkSize) {
                throw new TooLongFrameException("Chunk is too large: " + contentLength + " > " + maxChunkSize);
            }
            if (contentLength > 0L) {
                if ((long)in.readableBytes() < contentLength) {
                    ChunkInfo chunkInfo = null;
                    return chunkInfo;
                }
                info = new ChunkInfo((int)contentLength, false);
            } else {
                if (!isLast) {
                    ChunkInfo chunkInfo = null;
                    return chunkInfo;
                }
                info = new ChunkInfo(in.readableBytes(), true);
            }
            ChunkInfo chunkInfo = info;
            return chunkInfo;
        }
        finally {
            if (info == null) {
                in.readerIndex(initialReaderIndex);
            }
        }
    }

    static void serializeChunk(ByteBuf content, boolean isFinal, ByteBuf out, int maxChunkSize) {
        if (content.readableBytes() > maxChunkSize) {
            throw new EncoderException("Chunk is too large to be serialized");
        }
        if (!content.isReadable()) {
            throw new EncoderException("Empty chunks cannot be serialized");
        }
        if (isFinal) {
            out.writeByte(0);
        } else {
            VarIntCodecUtils.writeVariableLengthInteger((ByteBuf)out, (long)content.readableBytes());
        }
        out.writeBytes(content);
    }

    @Override
    public void parse(ByteBufAllocator alloc, ByteBuf in, boolean completeBodyReceived, OHttpChunkFramer.Decoder decoder, List<Object> out) throws CryptoException {
        ChunkInfo chunkInfo;
        if (decoder.isPrefixNeeded() && !decoder.decodePrefix(alloc, in)) {
            if (completeBodyReceived) {
                throw new CorruptedFrameException("Prefix is truncated");
            }
            return;
        }
        while (in.isReadable() && (chunkInfo = OHttpVersionChunkDraft.parseNextChunk(in, completeBodyReceived, this.maxChunkSize)) != null) {
            decoder.decodeChunk(alloc, in, chunkInfo.length, chunkInfo.isFinal, out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serialize(ByteBufAllocator alloc, HttpObject msg, OHttpChunkFramer.Encoder<HttpObject> encoder, ByteBuf out) throws CryptoException {
        if (encoder.isPrefixNeeded()) {
            encoder.encodePrefix(alloc, out);
        }
        boolean isFinal = msg instanceof LastHttpContent;
        ByteBuf encryptedBytes = alloc.buffer();
        try {
            encoder.encodeChunk(alloc, msg, encryptedBytes);
            OHttpVersionChunkDraft.serializeChunk(encryptedBytes, isFinal, out, this.maxChunkSize);
        }
        finally {
            encryptedBytes.release();
        }
    }

    static final class ChunkInfo {
        final int length;
        final boolean isFinal;

        private ChunkInfo(int length, boolean isFinal) {
            this.length = length;
            this.isFinal = isFinal;
        }
    }
}

