/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.EncoderException;
import io.netty.incubator.codec.hpke.AsymmetricCipherKeyPair;
import io.netty.incubator.codec.hpke.KEM;
import io.netty.incubator.codec.ohttp.OHttpCiphersuite;
import io.netty.incubator.codec.ohttp.OHttpKey;
import io.netty.util.internal.ObjectUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public final class OHttpServerKeys {
    private final Map<Byte, OHttpKey.PrivateKey> keyMap = new HashMap<Byte, OHttpKey.PrivateKey>();

    public OHttpServerKeys(OHttpKey.PrivateKey ... keys) {
        this(Arrays.asList(ObjectUtil.checkNonEmpty((Object[])keys, (String)"keys")));
    }

    public OHttpServerKeys(Collection<OHttpKey.PrivateKey> keys) {
        ObjectUtil.checkNonEmpty(keys, (String)"keys");
        for (OHttpKey.PrivateKey key : keys) {
            if (this.keyMap.put(key.id(), key) == null) continue;
            throw new IllegalArgumentException("Duplicate keyID " + key.id());
        }
    }

    public AsymmetricCipherKeyPair getKeyPair(OHttpCiphersuite ciphersuite) {
        OHttpKey.PrivateKey key = this.keyMap.get(ciphersuite.keyId());
        if (key == null) {
            return null;
        }
        for (OHttpKey.Cipher cipher : key.ciphers()) {
            if (cipher.kdf() != ciphersuite.kdf() || cipher.aead() != ciphersuite.aead()) continue;
            return key.keyPair();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OHttpServerKeys that = (OHttpServerKeys)o;
        return this.keyMap.equals(that.keyMap);
    }

    public String toString() {
        return "OHttpServerKeys{keyMap=" + this.keyMap + '}';
    }

    public int hashCode() {
        return this.keyMap.hashCode();
    }

    @Deprecated
    public void encodePublicKeys(ByteBuf output) {
        for (Map.Entry<Byte, OHttpKey.PrivateKey> key : this.keyMap.entrySet()) {
            OHttpServerKeys.encodeKeyConfiguration(key.getKey(), key.getValue(), output);
        }
    }

    private static void encodeKeyConfiguration(Byte id, OHttpKey.PrivateKey key, ByteBuf output) {
        KEM kem = key.kem();
        AsymmetricCipherKeyPair kp = key.keyPair();
        output.writeByte((int)id.byteValue());
        output.writeShort((int)kem.id());
        byte[] encoded = kp.publicParameters().encoded();
        if (encoded == null) {
            throw new EncoderException("Unable to encode public keys.");
        }
        output.writeBytes(encoded);
        output.writeShort(key.ciphers().size() * 4);
        for (OHttpKey.Cipher cipher : key.ciphers()) {
            output.writeShort((int)cipher.kdf().id());
            output.writeShort((int)cipher.aead().id());
        }
    }

    public void encodeKeyConfigurationMediaType(ByteBuf output) {
        for (Map.Entry<Byte, OHttpKey.PrivateKey> key : this.keyMap.entrySet()) {
            int writerIndex = output.writerIndex();
            output.ensureWritable(2);
            output.writerIndex(writerIndex + 2);
            OHttpServerKeys.encodeKeyConfiguration(key.getKey(), key.getValue(), output);
            int written = output.writerIndex() - writerIndex - 2;
            output.setShort(writerIndex, written);
        }
    }
}

