/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.incubator.codec.hpke.CryptoException;
import io.netty.incubator.codec.hpke.CryptoOperations;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;

public abstract class OHttpCrypto {
    private static final byte[] AAD_NONE = new byte[0];
    private static final byte[] AAD_FINAL = "final".getBytes(StandardCharsets.US_ASCII);

    OHttpCrypto() {
    }

    private static ByteBuffer aad(boolean isFinal) {
        return ByteBuffer.wrap(isFinal ? AAD_FINAL : AAD_NONE);
    }

    private static ByteBuffer readableTemporaryBuffer(ByteBuf buf, int length) {
        if (buf.nioBufferCount() == 1) {
            return buf.internalNioBuffer(buf.readerIndex(), length);
        }
        return buf.nioBuffer(buf.readerIndex(), length);
    }

    protected abstract CryptoOperations encryptCrypto();

    protected abstract CryptoOperations decryptCrypto();

    protected abstract OHttpCryptoConfiguration configuration();

    public final void encrypt(ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        ByteBuffer encrypted = this.encryptCrypto().seal(OHttpCrypto.aad(isFinal && this.configuration().useFinalAad()), OHttpCrypto.readableTemporaryBuffer(message, messageLength));
        message.skipBytes(messageLength);
        out.writeBytes(encrypted);
    }

    public final void decrypt(ByteBuf message, int messageLength, boolean isFinal, ByteBuf out) throws CryptoException {
        ByteBuffer decrypted = this.decryptCrypto().open(OHttpCrypto.aad(isFinal && this.configuration().useFinalAad()), OHttpCrypto.readableTemporaryBuffer(message, messageLength));
        message.skipBytes(messageLength);
        out.writeBytes(decrypted);
    }
}

