/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.ohttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.netty.incubator.codec.hpke.CryptoOperations;
import io.netty.incubator.codec.hpke.HPKE;
import io.netty.incubator.codec.hpke.HPKEContext;
import io.netty.incubator.codec.hpke.HybridPublicKeyEncryption;
import io.netty.incubator.codec.ohttp.OHttpCryptoConfiguration;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Random;
import org.bouncycastle.util.Arrays;

public final class OHttpCiphersuite {
    private static final Random RAND = new SecureRandom();
    private static final int ENCODED_LENGTH = 7;
    private final byte keyId;
    private final HybridPublicKeyEncryption.KEM kem;
    private final HybridPublicKeyEncryption.KDF kdf;
    private final HybridPublicKeyEncryption.AEAD aead;

    public OHttpCiphersuite(byte keyId, HybridPublicKeyEncryption.KEM kem, HybridPublicKeyEncryption.KDF kdf, HybridPublicKeyEncryption.AEAD aead) {
        this.keyId = keyId;
        this.kem = Objects.requireNonNull(kem, "kem");
        this.kdf = Objects.requireNonNull(kdf, "kdf");
        this.aead = Objects.requireNonNull(aead, "ahead");
    }

    public int responseNonceLength() {
        return Math.max(this.aead.nk(), this.aead.nn());
    }

    public int encapsulatedKeyLength() {
        return this.kem.nenc();
    }

    public byte keyId() {
        return this.keyId;
    }

    public HybridPublicKeyEncryption.KEM kem() {
        return this.kem;
    }

    public HybridPublicKeyEncryption.KDF kdf() {
        return this.kdf;
    }

    public HybridPublicKeyEncryption.AEAD aead() {
        return this.aead;
    }

    void encode(ByteBuf out) {
        out.writeByte((int)this.keyId);
        out.writeShort((int)this.kem.id());
        out.writeShort((int)this.kdf.id());
        out.writeShort((int)this.aead.id());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] createInfo(OHttpCryptoConfiguration configuration) {
        byte[] exportContext = configuration.requestExportContext();
        byte[] ret = new byte[exportContext.length + 8];
        ByteBuf buf = Unpooled.wrappedBuffer((byte[])ret);
        try {
            buf.writerIndex(0).writeBytes(exportContext).writeByte(0);
            this.encode(buf);
            byte[] byArray = ret;
            return byArray;
        }
        finally {
            buf.release();
        }
    }

    static OHttpCiphersuite decode(ByteBuf in) {
        if (in.readableBytes() < 7) {
            return null;
        }
        try {
            byte keyId = in.readByte();
            short kemId = in.readShort();
            short kdfId = in.readShort();
            short aeadId = in.readShort();
            return new OHttpCiphersuite(keyId, HybridPublicKeyEncryption.KEM.forId((short)kemId), HybridPublicKeyEncryption.KDF.forId((short)kdfId), HybridPublicKeyEncryption.AEAD.forId((short)aeadId));
        }
        catch (Exception e) {
            throw new DecoderException("invalid ciphersuite", (Throwable)e);
        }
    }

    byte[] createResponseNonce() {
        byte[] ret = new byte[this.responseNonceLength()];
        RAND.nextBytes(ret);
        return ret;
    }

    CryptoOperations createResponseAead(HybridPublicKeyEncryption encryption, HPKEContext context, byte[] enc, byte[] responseNonce, OHttpCryptoConfiguration configuration) {
        int secretLength = Math.max(this.aead.nk(), this.aead.nn());
        byte[] secret = context.export(configuration.responseExportContext(), secretLength);
        byte[] salt = Arrays.concatenate((byte[])enc, (byte[])responseNonce);
        byte[] prk = context.extract(salt, secret);
        byte[] aeadKey = context.expand(prk, "key".getBytes(StandardCharsets.US_ASCII), this.aead.nk());
        byte[] aeadNonce = context.expand(prk, "nonce".getBytes(StandardCharsets.US_ASCII), this.aead.nn());
        return encryption.newAEADCryptoOperations(this.aead, aeadKey, aeadNonce);
    }

    HPKE newHPKE(HybridPublicKeyEncryption encryption) {
        return encryption.newHPKE(HybridPublicKeyEncryption.Mode.Base, this.kem, this.kdf, this.aead);
    }

    public String toString() {
        return "OHttpCiphersuite{id=" + Byte.toUnsignedInt(this.keyId) + ", kem=" + this.kem + ", kdf=" + this.kdf + ", aead=" + this.aead + "}";
    }
}

