/*
 * Copyright 2023 The Netty Project
 *
 * The Netty Project licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package io.netty.incubator.codec.quic;

import org.jetbrains.annotations.Nullable;

import javax.net.ssl.SSLSessionContext;

/**
 * {@link SSLSessionContext} which also supports advanced operations.
 */
public interface QuicSslSessionContext extends SSLSessionContext {

    /**
     * Sets the {@link SslSessionTicketKey}s that should be used. The first key of the array is used for encryption
     * and decryption while the rest of the array is only used for decryption. This allows you to better handling
     * rotating of the keys. The rotating is the responsibility of the user.
     * If {@code null} is used for {@code keys} a key will automatically generated by the library and also rotated.
     *
     * @param keys the tickets to use.
     */
    void setTicketKeys(SslSessionTicketKey @Nullable ... keys);
}
