/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.FullBinaryHttpRequest;
import java.util.Objects;

public final class DefaultFullBinaryHttpRequest
extends DefaultFullHttpRequest
implements FullBinaryHttpRequest {
    private final String scheme;
    private final String authority;

    public DefaultFullBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri) {
        this(httpVersion, method, scheme, authority, uri, true);
    }

    public DefaultFullBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, ByteBuf content) {
        this(httpVersion, method, scheme, authority, uri, content, true);
    }

    public DefaultFullBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, ByteBuf content, boolean validateHeaders) {
        this(httpVersion, method, scheme, authority, uri, content, (HttpHeaders)BinaryHttpHeaders.newHeaders(validateHeaders), (HttpHeaders)BinaryHttpHeaders.newTrailers(validateHeaders));
    }

    private DefaultFullBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, ByteBuf content, HttpHeaders headers, HttpHeaders trailingHeader) {
        super(httpVersion, method, uri, content, headers, trailingHeader);
        this.scheme = Objects.requireNonNull(scheme, "scheme");
        this.authority = authority;
    }

    public DefaultFullBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, boolean validateHeaders) {
        this(httpVersion, method, scheme, authority, uri, Unpooled.EMPTY_BUFFER, validateHeaders);
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public FullBinaryHttpRequest retain() {
        super.retain();
        return this;
    }

    @Override
    public FullBinaryHttpRequest retain(int increment) {
        super.retain(increment);
        return this;
    }

    @Override
    public FullBinaryHttpRequest touch() {
        super.touch();
        return this;
    }

    @Override
    public FullBinaryHttpRequest touch(Object hint) {
        super.touch(hint);
        return this;
    }

    @Override
    public FullBinaryHttpRequest retainedDuplicate() {
        return this.replace(this.content().retainedDuplicate());
    }

    @Override
    public FullBinaryHttpRequest replace(ByteBuf content) {
        DefaultFullBinaryHttpRequest request = new DefaultFullBinaryHttpRequest(this.protocolVersion(), this.method(), this.scheme(), this.authority(), this.uri(), content, this.headers().copy(), this.trailingHeaders().copy());
        request.setDecoderResult(this.decoderResult());
        return request;
    }

    @Override
    public FullBinaryHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    @Override
    public FullBinaryHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public FullBinaryHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public FullBinaryHttpRequest copy() {
        return (FullBinaryHttpRequest)super.copy();
    }

    @Override
    public FullBinaryHttpRequest duplicate() {
        return (FullBinaryHttpRequest)super.duplicate();
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.authority != null ? this.authority.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultFullBinaryHttpRequest other = (DefaultFullBinaryHttpRequest)o;
        return Objects.equals(this.scheme, ((DefaultFullBinaryHttpRequest)o).scheme) && Objects.equals(this.authority, other.authority);
    }
}

