/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.incubator.codec.bhttp.BinaryHttpHeaders;
import io.netty.incubator.codec.bhttp.BinaryHttpRequest;
import java.util.Objects;

public final class DefaultBinaryHttpRequest
extends DefaultHttpRequest
implements BinaryHttpRequest {
    private final String scheme;
    private final String authority;

    public DefaultBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri) {
        this(httpVersion, method, scheme, authority, uri, true);
    }

    public DefaultBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, boolean validateHeaders) {
        this(httpVersion, method, scheme, authority, uri, BinaryHttpHeaders.newHeaders(validateHeaders));
    }

    DefaultBinaryHttpRequest(HttpVersion httpVersion, HttpMethod method, String scheme, String authority, String uri, BinaryHttpHeaders headers) {
        super(httpVersion, method, uri, (HttpHeaders)headers);
        this.authority = authority;
        this.scheme = Objects.requireNonNull(scheme);
    }

    @Override
    public String scheme() {
        return this.scheme;
    }

    @Override
    public String authority() {
        return this.authority;
    }

    @Override
    public BinaryHttpRequest setMethod(HttpMethod method) {
        super.setMethod(method);
        return this;
    }

    @Override
    public BinaryHttpRequest setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public BinaryHttpRequest setProtocolVersion(HttpVersion version) {
        super.setProtocolVersion(version);
        return this;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.authority != null ? this.authority.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultBinaryHttpRequest other = (DefaultBinaryHttpRequest)o;
        return Objects.equals(this.scheme, other.scheme) && Objects.equals(this.authority, other.authority);
    }
}

