/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.incubator.codec.bhttp.BinaryHttpRequest;
import io.netty.incubator.codec.bhttp.BinaryHttpResponse;
import io.netty.incubator.codec.bhttp.PseudoHeaderName;
import io.netty.incubator.codec.bhttp.VarIntCodecUtils;
import io.netty.util.AsciiString;
import io.netty.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;

public final class BinaryHttpSerializer {
    private State state = State.INITIAL;

    public void serialize(HttpObject msg, ByteBuf out) {
        block5: while (true) {
            switch (this.state) {
                case INITIAL: {
                    if (msg instanceof BinaryHttpRequest) {
                        BinaryHttpSerializer.encodeRequest(out.alloc(), out, (BinaryHttpRequest)msg);
                        this.state = State.CONTENT;
                        continue block5;
                    }
                    if (msg instanceof BinaryHttpResponse) {
                        BinaryHttpResponse response = (BinaryHttpResponse)msg;
                        BinaryHttpSerializer.encodeResponse(out.alloc(), out, response);
                        if (response.status().codeClass() == HttpStatusClass.INFORMATIONAL) {
                            this.state = State.CONTENT_DISPOSE;
                            continue block5;
                        }
                        this.state = State.CONTENT;
                        continue block5;
                    }
                    this.throwUnsupportedMessageTypeException(msg);
                    if (msg instanceof HttpContent) continue block5;
                    return;
                }
                case CONTENT_DISPOSE: {
                    HttpContent disposableContent;
                    if (!(msg instanceof HttpContent)) {
                        this.throwUnsupportedMessageTypeException(msg);
                    }
                    if ((disposableContent = (HttpContent)msg).content().isReadable()) {
                        throw new IllegalArgumentException("HttpContent must be empty for INFORMATIONAL responses, state: " + (Object)((Object)this.state));
                    }
                    if (disposableContent instanceof LastHttpContent) {
                        if (!((LastHttpContent)disposableContent).trailingHeaders().isEmpty()) {
                            throw new IllegalArgumentException("LastHttpContent trailers must be empty for INFORMATIONAL responses, state: " + (Object)((Object)this.state));
                        }
                        this.state = State.INITIAL;
                    }
                    return;
                }
                case CONTENT: {
                    if (!(msg instanceof HttpContent)) {
                        this.throwUnsupportedMessageTypeException(msg);
                    }
                    HttpContent content = (HttpContent)msg;
                    BinaryHttpSerializer.encodeContentChunk(content.content(), out);
                    if (content instanceof LastHttpContent) {
                        VarIntCodecUtils.writeVariableLengthInteger(out, 0L);
                        BinaryHttpSerializer.encodeIndeterminateLengthFieldSection(out.alloc(), out, ((LastHttpContent)content).trailingHeaders());
                        this.state = State.INITIAL;
                    }
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException("Unknown state: " + (Object)((Object)this.state));
    }

    private void throwUnsupportedMessageTypeException(Object msg) {
        throw new UnsupportedMessageTypeException("Unexpected message type: " + StringUtil.simpleClassName((Object)msg) + ", state: " + (Object)((Object)this.state));
    }

    private static void encodeRequest(ByteBufAllocator allocator, ByteBuf out, BinaryHttpRequest request) {
        VarIntCodecUtils.writeVariableLengthInteger(out, 2L);
        BinaryHttpSerializer.encodeRequestControlData(out, request);
        BinaryHttpSerializer.encodeIndeterminateLengthFieldSection(allocator, out, request.headers());
    }

    private static void encodeResponse(ByteBufAllocator allocator, ByteBuf out, BinaryHttpResponse response) {
        VarIntCodecUtils.writeVariableLengthInteger(out, 3L);
        BinaryHttpSerializer.encodeResponseControlData(out, response);
        BinaryHttpSerializer.encodeIndeterminateLengthFieldSection(allocator, out, response.headers());
    }

    private static void encodeResponseControlData(ByteBuf out, BinaryHttpResponse response) {
        VarIntCodecUtils.writeVariableLengthInteger(out, response.status().code());
    }

    private static void writeVariableLengthCharSequence(ByteBuf out, CharSequence sequence) {
        VarIntCodecUtils.writeVariableLengthInteger(out, sequence.length());
        out.writeCharSequence(sequence, StandardCharsets.US_ASCII);
    }

    private static void encodeRequestControlData(ByteBuf out, BinaryHttpRequest request) {
        AsciiString method = request.method().asciiName();
        BinaryHttpSerializer.writeVariableLengthCharSequence(out, (CharSequence)method);
        BinaryHttpSerializer.writeVariableLengthCharSequence(out, request.scheme());
        String authority = request.authority();
        if (authority == null) {
            authority = AsciiString.EMPTY_STRING;
        }
        BinaryHttpSerializer.writeVariableLengthCharSequence(out, authority);
        BinaryHttpSerializer.writeVariableLengthCharSequence(out, request.uri());
    }

    private static void encodeIndeterminateLengthFieldSection(ByteBufAllocator allocator, ByteBuf out, HttpHeaders headers) {
        int writerIndex = out.writerIndex();
        ByteBuf nonPseudoHeaderBuffer = null;
        Iterator it = headers.iteratorCharSequence();
        while (it.hasNext()) {
            Map.Entry header = (Map.Entry)it.next();
            if (PseudoHeaderName.hasPseudoHeaderFormat((CharSequence)header.getKey())) {
                if (nonPseudoHeaderBuffer == null) {
                    nonPseudoHeaderBuffer = allocator.buffer();
                    nonPseudoHeaderBuffer.writeBytes(out, writerIndex, out.writerIndex() - writerIndex);
                    out.writerIndex(writerIndex);
                }
                BinaryHttpSerializer.writeVariableLengthCharSequence(out, (CharSequence)header.getKey());
                BinaryHttpSerializer.writeVariableLengthCharSequence(out, (CharSequence)header.getValue());
                continue;
            }
            if (nonPseudoHeaderBuffer == null) {
                BinaryHttpSerializer.writeVariableLengthCharSequence(out, (CharSequence)header.getKey());
                BinaryHttpSerializer.writeVariableLengthCharSequence(out, (CharSequence)header.getValue());
                continue;
            }
            BinaryHttpSerializer.writeVariableLengthCharSequence(nonPseudoHeaderBuffer, (CharSequence)header.getKey());
            BinaryHttpSerializer.writeVariableLengthCharSequence(nonPseudoHeaderBuffer, (CharSequence)header.getValue());
        }
        if (nonPseudoHeaderBuffer != null) {
            out.writeBytes(nonPseudoHeaderBuffer);
            nonPseudoHeaderBuffer.release();
        }
        VarIntCodecUtils.writeVariableLengthInteger(out, 0L);
    }

    private static void writeVariableLengthBuffer(ByteBuf out, ByteBuf buffer) {
        VarIntCodecUtils.writeVariableLengthInteger(out, buffer.readableBytes());
        out.writeBytes(buffer);
    }

    private static void encodeContentChunk(ByteBuf content, ByteBuf out) {
        if (!content.isReadable()) {
            return;
        }
        BinaryHttpSerializer.writeVariableLengthBuffer(out, content);
    }

    private static enum State {
        INITIAL,
        CONTENT,
        CONTENT_DISPOSE;

    }
}

