/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaderValidationUtil;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.incubator.codec.bhttp.PseudoHeaderName;
import io.netty.util.AsciiString;
import io.netty.util.ByteProcessor;

final class BinaryHttpHeaders
extends DefaultHttpHeaders {
    private static final DefaultHeaders.NameValidator<CharSequence> BINARY_HTTP_HEADERS_VALIDATOR = new BinaryHttpNameValidator(false);
    private static final DefaultHeaders.NameValidator<CharSequence> BINARY_HTTP_TRAILERS_VALIDATOR = new BinaryHttpNameValidator(true);
    private final boolean validate;
    private final DefaultHeaders.NameValidator<CharSequence> validator;

    static BinaryHttpHeaders newHeaders(boolean validate) {
        return new BinaryHttpHeaders(validate, BINARY_HTTP_HEADERS_VALIDATOR);
    }

    static BinaryHttpHeaders newTrailers(boolean validate) {
        return new BinaryHttpHeaders(validate, BINARY_HTTP_TRAILERS_VALIDATOR);
    }

    private BinaryHttpHeaders(boolean validate, DefaultHeaders.NameValidator<CharSequence> validator) {
        super(validate, validator);
        this.validate = validate;
        this.validator = validator;
    }

    public HttpHeaders copy() {
        return new BinaryHttpHeaders(this.validate, this.validator).set((HttpHeaders)this);
    }

    private static final class BinaryHttpNameValidator
    implements DefaultHeaders.NameValidator<CharSequence> {
        private static final ByteProcessor BINARY_HTTP_NAME_VALIDATOR_PROCESSOR = new ByteProcessor(){

            public boolean process(byte value) {
                return !AsciiString.isUpperCase((byte)value);
            }
        };
        private final boolean trailers;

        BinaryHttpNameValidator(boolean trailers) {
            this.trailers = trailers;
        }

        private static int checkUppercase(CharSequence name) {
            if (name instanceof AsciiString) {
                try {
                    return ((AsciiString)name).forEachByte(BINARY_HTTP_NAME_VALIDATOR_PROCESSOR);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("invalid header [" + name + ']', e);
                }
            }
            for (int i = 0; i < name.length(); ++i) {
                if (!AsciiString.isUpperCase((char)name.charAt(i))) continue;
                return i;
            }
            return -1;
        }

        public void validateName(CharSequence name) {
            if (name != null && name.length() != 0) {
                int index = HttpHeaderValidationUtil.validateToken((CharSequence)name);
                if (index != -1) {
                    if (this.trailers || index != 0 || !PseudoHeaderName.isPseudoHeaderPrefix(name.charAt(index))) {
                        throw new IllegalArgumentException("a header name can only contain \"token\" characters, but found invalid character 0x" + Integer.toHexString(name.charAt(index)) + " at index " + index + " of header '" + name + "'.");
                    }
                    if (PseudoHeaderName.isPseudoHeader(name)) {
                        throw new IllegalArgumentException("only custom pseudo-headers are allowed: '" + name + "'.");
                    }
                }
                if ((index = BinaryHttpNameValidator.checkUppercase(name)) != -1) {
                    throw new IllegalArgumentException("a header name can only contain \"lowercase\" characters, but found invalid character 0x" + Integer.toHexString(name.charAt(index)) + " at index " + index + " of header '" + name + "'.");
                }
            } else {
                throw new IllegalArgumentException("empty headers are not allowed [" + name + ']');
            }
        }
    }
}

