/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.bhttp;

import io.netty.handler.codec.DefaultHeaders;
import io.netty.handler.codec.UnsupportedValueConverter;
import io.netty.handler.codec.ValueConverter;
import io.netty.util.AsciiString;

enum PseudoHeaderName {
    METHOD(":method"),
    SCHEME(":scheme"),
    AUTHORITY(":authority"),
    PATH(":path"),
    STATUS(":status");

    private static final char PSEUDO_HEADER_PREFIX = ':';
    private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
    private final AsciiString value;
    private static final CharSequenceMap<PseudoHeaderName> PSEUDO_HEADERS;

    private PseudoHeaderName(String value) {
        this.value = AsciiString.cached((String)value);
    }

    public AsciiString value() {
        return this.value;
    }

    public static boolean hasPseudoHeaderFormat(CharSequence headerName) {
        if (headerName.length() == 0) {
            return false;
        }
        if (headerName instanceof AsciiString) {
            return ((AsciiString)headerName).byteAt(0) == 58;
        }
        return PseudoHeaderName.isPseudoHeaderPrefix(headerName.charAt(0));
    }

    public static boolean isPseudoHeader(CharSequence name) {
        return PSEUDO_HEADERS.contains(name);
    }

    static boolean isPseudoHeaderPrefix(char c) {
        return ':' == c;
    }

    static {
        PSEUDO_HEADERS = new CharSequenceMap();
        for (PseudoHeaderName pseudoHeader : PseudoHeaderName.values()) {
            PSEUDO_HEADERS.add(pseudoHeader.value(), (Object)pseudoHeader);
        }
    }

    private static final class CharSequenceMap<V>
    extends DefaultHeaders<CharSequence, V, CharSequenceMap<V>> {
        CharSequenceMap() {
            super(AsciiString.CASE_SENSITIVE_HASHER, (ValueConverter)UnsupportedValueConverter.instance());
        }
    }
}

