/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socksx.v5;

import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressEncoder;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AddressType;
import io.netty.contrib.handler.codec.socksx.v5.Socks5AuthMethod;
import io.netty.contrib.handler.codec.socksx.v5.Socks5CommandRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5InitialRequest;
import io.netty.contrib.handler.codec.socksx.v5.Socks5Message;
import io.netty.contrib.handler.codec.socksx.v5.Socks5PasswordAuthRequest;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.EncoderException;
import io.netty5.handler.codec.MessageToByteEncoder;
import io.netty5.util.internal.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;

public class Socks5ClientEncoder
extends MessageToByteEncoder<Socks5Message> {
    public static final Socks5ClientEncoder DEFAULT = new Socks5ClientEncoder();
    private final Socks5AddressEncoder addressEncoder;

    protected Socks5ClientEncoder() {
        this(Socks5AddressEncoder.DEFAULT);
    }

    protected Buffer allocateBuffer(ChannelHandlerContext ctx, Socks5Message msg) {
        return ctx.bufferAllocator().allocate(256);
    }

    public Socks5ClientEncoder(Socks5AddressEncoder addressEncoder) {
        Objects.requireNonNull(addressEncoder, "addressEncoder");
        this.addressEncoder = addressEncoder;
    }

    protected final Socks5AddressEncoder addressEncoder() {
        return this.addressEncoder;
    }

    protected void encode(ChannelHandlerContext ctx, Socks5Message msg, Buffer out) throws Exception {
        if (msg instanceof Socks5InitialRequest) {
            Socks5ClientEncoder.encodeAuthMethodRequest((Socks5InitialRequest)msg, out);
        } else if (msg instanceof Socks5PasswordAuthRequest) {
            Socks5ClientEncoder.encodePasswordAuthRequest((Socks5PasswordAuthRequest)msg, out);
        } else if (msg instanceof Socks5CommandRequest) {
            this.encodeCommandRequest((Socks5CommandRequest)msg, out);
        } else {
            throw new EncoderException("unsupported message type: " + StringUtil.simpleClassName((Object)msg));
        }
    }

    private static void encodeAuthMethodRequest(Socks5InitialRequest msg, Buffer out) {
        out.writeByte(msg.version().byteValue());
        List<Socks5AuthMethod> authMethods = msg.authMethods();
        int numAuthMethods = authMethods.size();
        out.writeByte((byte)numAuthMethods);
        if (authMethods instanceof RandomAccess) {
            for (int i = 0; i < numAuthMethods; ++i) {
                out.writeByte(authMethods.get(i).byteValue());
            }
        } else {
            for (Socks5AuthMethod a : authMethods) {
                out.writeByte(a.byteValue());
            }
        }
    }

    private static void encodePasswordAuthRequest(Socks5PasswordAuthRequest msg, Buffer out) {
        out.writeByte((byte)1);
        String username = msg.username();
        out.writeByte((byte)username.length());
        out.writeCharSequence((CharSequence)username, StandardCharsets.US_ASCII);
        String password = msg.password();
        out.writeByte((byte)password.length());
        out.writeCharSequence((CharSequence)password, StandardCharsets.US_ASCII);
    }

    private void encodeCommandRequest(Socks5CommandRequest msg, Buffer out) throws Exception {
        out.writeByte(msg.version().byteValue());
        out.writeByte(msg.type().byteValue());
        out.writeByte((byte)0);
        Socks5AddressType dstAddrType = msg.dstAddrType();
        out.writeByte(dstAddrType.byteValue());
        this.addressEncoder.encodeAddress(dstAddrType, msg.dstAddr(), out);
        out.writeShort((short)msg.dstPort());
    }

    public boolean isSharable() {
        return true;
    }
}

