/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.socks;

import io.netty.contrib.handler.codec.socks.SocksAuthScheme;
import io.netty.contrib.handler.codec.socks.SocksCommonUtils;
import io.netty.contrib.handler.codec.socks.SocksInitRequest;
import io.netty.contrib.handler.codec.socks.SocksProtocolVersion;
import io.netty5.buffer.Buffer;
import io.netty5.channel.ChannelHandler;
import io.netty5.channel.ChannelHandlerContext;
import io.netty5.handler.codec.ByteToMessageDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SocksInitRequestDecoder
extends ByteToMessageDecoder {
    private State state = State.CHECK_PROTOCOL_VERSION;

    protected void decode(ChannelHandlerContext ctx, Buffer buffer) throws Exception {
        switch (this.state) {
            case CHECK_PROTOCOL_VERSION: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                if (buffer.readByte() != SocksProtocolVersion.SOCKS5.byteValue()) {
                    ctx.fireChannelRead((Object)SocksCommonUtils.UNKNOWN_SOCKS_REQUEST);
                    break;
                }
                this.state = State.READ_AUTH_SCHEMES;
            }
            case READ_AUTH_SCHEMES: {
                List<SocksAuthScheme> authSchemes;
                if (buffer.readableBytes() < 1) {
                    return;
                }
                int authSchemeNum = buffer.getByte(buffer.readerOffset());
                if (buffer.readableBytes() < 1 + authSchemeNum) {
                    return;
                }
                buffer.skipReadableBytes(1);
                if (authSchemeNum > 0) {
                    authSchemes = new ArrayList(authSchemeNum);
                    for (int i = 0; i < authSchemeNum; ++i) {
                        authSchemes.add(SocksAuthScheme.valueOf(buffer.readByte()));
                    }
                } else {
                    authSchemes = Collections.emptyList();
                }
                ctx.fireChannelRead((Object)new SocksInitRequest(authSchemes));
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.pipeline().remove((ChannelHandler)this);
    }

    private static enum State {
        CHECK_PROTOCOL_VERSION,
        READ_AUTH_SCHEMES;

    }
}

