/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractMixedHttpData;
import io.netty.contrib.handler.codec.http.multipart.DiskFileUpload;
import io.netty.contrib.handler.codec.http.multipart.FileUpload;
import io.netty.contrib.handler.codec.http.multipart.MemoryFileUpload;
import io.netty5.buffer.Owned;
import io.netty5.util.Send;
import java.nio.charset.Charset;

public class MixedFileUpload
extends AbstractMixedHttpData<FileUpload>
implements FileUpload {
    public MixedFileUpload(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size, long limitSize) {
        this(name, filename, contentType, contentTransferEncoding, charset, size, limitSize, DiskFileUpload.baseDirectory, DiskFileUpload.deleteOnExitTemporaryFile);
    }

    public MixedFileUpload(String name, String filename, String contentType, String contentTransferEncoding, Charset charset, long size, long limitSize, String baseDir, boolean deleteOnExit) {
        super(limitSize, baseDir, deleteOnExit, size > limitSize ? new DiskFileUpload(name, filename, contentType, contentTransferEncoding, charset, size) : new MemoryFileUpload(name, filename, contentType, contentTransferEncoding, charset, size));
    }

    private MixedFileUpload(long limitSize, String baseDir, boolean deleteOnExit, FileUpload fileUpload) {
        super(limitSize, baseDir, deleteOnExit, fileUpload);
    }

    @Override
    public String getContentType() {
        return ((FileUpload)this.wrapped).getContentType();
    }

    @Override
    public String getContentTransferEncoding() {
        return ((FileUpload)this.wrapped).getContentTransferEncoding();
    }

    @Override
    public String getFilename() {
        return ((FileUpload)this.wrapped).getFilename();
    }

    @Override
    public void setContentType(String contentType) {
        ((FileUpload)this.wrapped).setContentType(contentType);
    }

    @Override
    public void setContentTransferEncoding(String contentTransferEncoding) {
        ((FileUpload)this.wrapped).setContentTransferEncoding(contentTransferEncoding);
    }

    @Override
    public void setFilename(String filename) {
        ((FileUpload)this.wrapped).setFilename(filename);
    }

    @Override
    FileUpload makeDiskData() {
        DiskFileUpload diskFileUpload = new DiskFileUpload(this.getName(), this.getFilename(), this.getContentType(), this.getContentTransferEncoding(), this.getCharset(), this.definedLength(), this.baseDir, this.deleteOnExit);
        diskFileUpload.setMaxSize(this.getMaxSize());
        return diskFileUpload;
    }

    protected Owned<AbstractMixedHttpData<?>> prepareSend() {
        Send send = ((FileUpload)this.wrapped).send();
        return drop -> {
            FileUpload received = (FileUpload)send.receive();
            return new MixedFileUpload(this.limitSize, this.baseDir, this.deleteOnExit, received);
        };
    }
}

