/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.Attribute;
import io.netty.contrib.handler.codec.http.multipart.CaseIgnoringComparator;
import io.netty.contrib.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty.contrib.handler.codec.http.multipart.HttpDataFactory;
import io.netty.contrib.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.contrib.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.ByteCursor;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.handler.codec.http.HttpContent;
import io.netty5.handler.codec.http.HttpRequest;
import io.netty5.handler.codec.http.LastHttpContent;
import io.netty5.handler.codec.http.QueryStringDecoder;
import io.netty5.util.ByteProcessor;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.StringUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class HttpPostStandardRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    private final HttpDataFactory factory;
    private final HttpRequest request;
    private final Charset charset;
    private boolean isLastChunk;
    private final List<InterfaceHttpData> bodyListHttpData = new ArrayList<InterfaceHttpData>();
    private final Map<String, List<InterfaceHttpData>> bodyMapHttpData = new TreeMap<CharSequence, List<InterfaceHttpData>>(CaseIgnoringComparator.INSTANCE);
    private Buffer undecodedChunk;
    private int bodyListHttpDataRank;
    private HttpPostRequestDecoder.MultiPartStatus currentStatus = HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED;
    private Attribute currentAttribute;
    private boolean destroyed;
    private int discardThreshold = 0xA00000;

    public HttpPostStandardRequestDecoder(HttpRequest request) {
        this(new DefaultHttpDataFactory(16384L), request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request) {
        this(factory, request, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostStandardRequestDecoder(HttpDataFactory factory, HttpRequest request, Charset charset) {
        this.request = (HttpRequest)ObjectUtil.checkNotNullWithIAE((Object)request, (String)"request");
        this.charset = (Charset)ObjectUtil.checkNotNullWithIAE((Object)charset, (String)"charset");
        this.factory = (HttpDataFactory)ObjectUtil.checkNotNullWithIAE((Object)factory, (String)"factory");
        try {
            if (request instanceof HttpContent) {
                this.offer((HttpContent)request);
            } else {
                this.parseBody();
            }
        }
        catch (Throwable e) {
            this.destroy();
            PlatformDependent.throwException((Throwable)e);
        }
    }

    private void checkDestroyed() {
        if (this.destroyed) {
            throw new IllegalStateException(HttpPostStandardRequestDecoder.class.getSimpleName() + " was destroyed already");
        }
    }

    @Override
    public boolean isMultipart() {
        this.checkDestroyed();
        return false;
    }

    @Override
    public void setDiscardThreshold(int discardThreshold) {
        this.discardThreshold = ObjectUtil.checkPositiveOrZero((int)discardThreshold, (String)"discardThreshold");
    }

    @Override
    public int getDiscardThreshold() {
        return this.discardThreshold;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyListHttpData;
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        return this.bodyMapHttpData.get(name);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String name) {
        this.checkDestroyed();
        if (!this.isLastChunk) {
            throw new HttpPostRequestDecoder.NotEnoughDataDecoderException();
        }
        List<InterfaceHttpData> list = this.bodyMapHttpData.get(name);
        if (list != null) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public HttpPostStandardRequestDecoder offer(HttpContent<?> content) {
        this.checkDestroyed();
        if (content instanceof LastHttpContent) {
            this.isLastChunk = true;
        }
        Buffer buf = content.payload();
        if (this.undecodedChunk == null) {
            this.undecodedChunk = buf.isDirect() ? DefaultBufferAllocators.offHeapAllocator().allocate(buf.readableBytes()).writeBytes(buf) : DefaultBufferAllocators.onHeapAllocator().allocate(buf.readableBytes()).writeBytes(buf);
        } else {
            this.undecodedChunk.ensureWritable(buf.readableBytes());
            this.undecodedChunk.writeBytes(buf);
        }
        this.parseBody();
        if (this.undecodedChunk != null && this.undecodedChunk.writerOffset() > this.discardThreshold) {
            this.undecodedChunk.compact();
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        this.checkDestroyed();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE && this.bodyListHttpDataRank >= this.bodyListHttpData.size()) {
            throw new HttpPostRequestDecoder.EndOfDataDecoderException();
        }
        return !this.bodyListHttpData.isEmpty() && this.bodyListHttpDataRank < this.bodyListHttpData.size();
    }

    @Override
    public InterfaceHttpData next() {
        this.checkDestroyed();
        if (this.hasNext()) {
            return this.bodyListHttpData.get(this.bodyListHttpDataRank++);
        }
        return null;
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.currentAttribute;
    }

    private void parseBody() {
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE || this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.EPILOGUE) {
            if (this.isLastChunk) {
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            }
            return;
        }
        this.parseBodyAttributes();
    }

    protected void addHttpData(InterfaceHttpData data) {
        if (data == null) {
            return;
        }
        List<InterfaceHttpData> datas = this.bodyMapHttpData.get(data.getName());
        if (datas == null) {
            datas = new ArrayList<InterfaceHttpData>(1);
            this.bodyMapHttpData.put(data.getName(), datas);
        }
        datas.add(data);
        this.bodyListHttpData.add(data);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseBodyAttributesStandard() {
        int firstpos;
        int currentpos = firstpos = this.undecodedChunk.readerOffset();
        if (this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.NOTSTARTED) {
            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
        }
        boolean contRead = true;
        try {
            int ampersandpos;
            block8: while (this.undecodedChunk.readableBytes() > 0 && contRead) {
                char read = (char)this.undecodedChunk.readUnsignedByte();
                ++currentpos;
                switch (this.currentStatus) {
                    case DISPOSITION: {
                        String key;
                        if (read == '=') {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.FIELD;
                            int equalpos = currentpos - 1;
                            key = HttpPostStandardRequestDecoder.decodeAttribute(Helpers.toString(this.undecodedChunk, firstpos, equalpos - firstpos, this.charset), this.charset);
                            this.currentAttribute = this.factory.createAttribute(this.request, key);
                            firstpos = currentpos;
                            continue block8;
                        }
                        if (read != '&') continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                        ampersandpos = currentpos - 1;
                        key = HttpPostStandardRequestDecoder.decodeAttribute(Helpers.toString(this.undecodedChunk, firstpos, ampersandpos - firstpos, this.charset), this.charset);
                        if (!key.isEmpty()) {
                            this.currentAttribute = this.factory.createAttribute(this.request, key);
                            this.currentAttribute.setValue("");
                            this.addHttpData(this.currentAttribute);
                        }
                        this.currentAttribute = null;
                        firstpos = currentpos;
                        contRead = true;
                        continue block8;
                    }
                    case FIELD: {
                        if (read == '&') {
                            this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.DISPOSITION;
                            ampersandpos = currentpos - 1;
                            this.undecodedChunk.readerOffset(firstpos);
                            this.setFinalBuffer(this.undecodedChunk.readSplit(ampersandpos - firstpos));
                            this.undecodedChunk.skipReadableBytes(1);
                            firstpos = currentpos = 1;
                            contRead = true;
                            continue block8;
                        }
                        if (read == '\r') {
                            if (this.undecodedChunk.readableBytes() > 0) {
                                read = (char)this.undecodedChunk.readUnsignedByte();
                                if (read != '\n') throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad end of line");
                                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                                ampersandpos = ++currentpos - 2;
                                this.undecodedChunk.readerOffset(firstpos);
                                this.setFinalBuffer(this.undecodedChunk.readSplit(ampersandpos - firstpos));
                                this.undecodedChunk.skipReadableBytes(2);
                                firstpos = currentpos = 2;
                                contRead = false;
                                continue block8;
                            }
                            --currentpos;
                            continue block8;
                        }
                        if (read != '\n') continue block8;
                        this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.PREEPILOGUE;
                        ampersandpos = currentpos - 1;
                        this.undecodedChunk.readerOffset(firstpos);
                        this.setFinalBuffer(this.undecodedChunk.readSplit(ampersandpos - firstpos));
                        this.undecodedChunk.skipReadableBytes(1);
                        firstpos = currentpos = 1;
                        contRead = false;
                        continue block8;
                    }
                }
                contRead = false;
            }
            if (this.isLastChunk && this.currentAttribute != null) {
                ampersandpos = currentpos;
                if (ampersandpos > firstpos) {
                    this.undecodedChunk.readerOffset(firstpos);
                    this.setFinalBuffer(this.undecodedChunk.readSplit(ampersandpos - firstpos));
                    currentpos = 0;
                } else if (!this.currentAttribute.isCompleted()) {
                    this.setFinalBuffer(DefaultBufferAllocators.preferredAllocator().allocate(0));
                }
                firstpos = currentpos;
                this.currentStatus = HttpPostRequestDecoder.MultiPartStatus.EPILOGUE;
            } else if (contRead && this.currentAttribute != null && this.currentStatus == HttpPostRequestDecoder.MultiPartStatus.FIELD) {
                this.undecodedChunk.readerOffset(firstpos);
                this.currentAttribute.addContent(this.undecodedChunk.readSplit(currentpos - firstpos), false);
                firstpos = currentpos = 0;
            }
            this.undecodedChunk.readerOffset(firstpos);
            return;
        }
        catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
            this.undecodedChunk.readerOffset(firstpos);
            throw e;
        }
        catch (IOException e) {
            this.undecodedChunk.readerOffset(firstpos);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
        }
        catch (IllegalArgumentException e) {
            this.undecodedChunk.readerOffset(firstpos);
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(e);
        }
    }

    private void parseBodyAttributes() {
        if (this.undecodedChunk == null) {
            return;
        }
        this.parseBodyAttributesStandard();
    }

    private void setFinalBuffer(Buffer buffer) throws IOException {
        this.currentAttribute.addContent(buffer, true);
        this.currentAttribute.usingBuffer(attrBuffer -> {
            Buffer decodedBuf = HttpPostStandardRequestDecoder.decodeAttribute(attrBuffer, this.charset);
            if (decodedBuf != null) {
                this.currentAttribute.setContent(decodedBuf);
            }
        });
        this.addHttpData(this.currentAttribute);
        this.currentAttribute = null;
    }

    private static String decodeAttribute(String s, Charset charset) {
        try {
            return QueryStringDecoder.decodeComponent((String)s, (Charset)charset);
        }
        catch (IllegalArgumentException e) {
            throw new HttpPostRequestDecoder.ErrorDataDecoderException("Bad string: '" + s + "'", e);
        }
    }

    private static Buffer decodeAttribute(Buffer b, Charset charset) {
        ByteCursor cursor = b.openCursor();
        int firstEscaped = cursor.process((ByteProcessor)new UrlEncodedDetector());
        if (firstEscaped == -1) {
            return null;
        }
        cursor = b.openCursor();
        Buffer buf = b.isDirect() ? DefaultBufferAllocators.offHeapAllocator().allocate(b.readableBytes()) : DefaultBufferAllocators.onHeapAllocator().allocate(b.readableBytes());
        UrlDecoder urlDecode = new UrlDecoder(buf);
        int idx = cursor.process((ByteProcessor)urlDecode);
        if (urlDecode.nextEscapedIdx != 0) {
            if (idx == -1) {
                idx = b.readableBytes() - 1;
            }
            buf.close();
            throw new HttpPostRequestDecoder.ErrorDataDecoderException(String.format("Invalid hex byte at index '%d' in string: '%s'", idx -= urlDecode.nextEscapedIdx - 1, b.toString(charset)));
        }
        return buf;
    }

    @Override
    public void destroy() {
        this.cleanFiles();
        for (InterfaceHttpData httpData : this.bodyListHttpData) {
            if (!httpData.isAccessible()) continue;
            httpData.close();
        }
        this.destroyed = true;
        if (this.undecodedChunk != null) {
            if (this.undecodedChunk.isAccessible()) {
                this.undecodedChunk.close();
            }
            this.undecodedChunk = null;
        }
    }

    @Override
    public void cleanFiles() {
        this.checkDestroyed();
        this.factory.cleanRequestHttpData(this.request);
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData data) {
        this.checkDestroyed();
        this.factory.removeHttpDataFromClean(this.request, data);
    }

    private static final class UrlDecoder
    implements ByteProcessor {
        private final Buffer output;
        private int nextEscapedIdx;
        private byte hiByte;

        UrlDecoder(Buffer output) {
            this.output = output;
        }

        public boolean process(byte value) {
            if (this.nextEscapedIdx != 0) {
                if (this.nextEscapedIdx == 1) {
                    this.hiByte = value;
                    ++this.nextEscapedIdx;
                } else {
                    int hi = StringUtil.decodeHexNibble((char)((char)this.hiByte));
                    int lo = StringUtil.decodeHexNibble((char)((char)value));
                    if (hi == -1 || lo == -1) {
                        ++this.nextEscapedIdx;
                        return false;
                    }
                    this.output.writeByte((byte)((hi << 4) + lo));
                    this.nextEscapedIdx = 0;
                }
            } else if (value == 37) {
                this.nextEscapedIdx = 1;
            } else if (value == 43) {
                this.output.writeByte((byte)32);
            } else {
                this.output.writeByte(value);
            }
            return true;
        }
    }

    private static final class UrlEncodedDetector
    implements ByteProcessor {
        private UrlEncodedDetector() {
        }

        public boolean process(byte value) {
            return value != 37 && value != 43;
        }
    }
}

