/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty.contrib.handler.codec.http.multipart.HttpData;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.Drop;
import io.netty5.buffer.internal.ResourceSupport;
import io.netty5.channel.ChannelException;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.util.internal.ObjectUtil;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.regex.Pattern;

public abstract class AbstractHttpData
extends ResourceSupport<HttpData, AbstractHttpData>
implements HttpData {
    private static final Pattern STRIP_PATTERN = Pattern.compile("(?:^\\s+|\\s+$|\\n)");
    private static final Pattern REPLACE_PATTERN = Pattern.compile("[\\r\\t]");
    protected static final byte[] EMPTY_ARRAY = new byte[0];
    private final String name;
    protected long definedSize;
    protected long size;
    private Charset charset = HttpConstants.DEFAULT_CHARSET;
    private boolean completed;
    private long maxSize = -1L;
    private static final Drop<AbstractHttpData> drop = new Drop<AbstractHttpData>(){

        public void drop(AbstractHttpData data) {
            data.delete();
        }

        public Drop<AbstractHttpData> fork() {
            return this;
        }

        public void attach(AbstractHttpData mixedFileUpload) {
        }
    };

    protected AbstractHttpData(String name, Charset charset, long size) {
        super(drop);
        ObjectUtil.checkNotNullWithIAE((Object)name, (String)"name");
        name = REPLACE_PATTERN.matcher(name).replaceAll(" ");
        name = STRIP_PATTERN.matcher(name).replaceAll("");
        this.name = ObjectUtil.checkNonEmpty((String)name, (String)"name");
        if (charset != null) {
            this.setCharset(charset);
        }
        this.definedSize = size;
    }

    protected AbstractHttpData(AbstractHttpData copy) {
        super(drop);
        this.name = copy.name;
        this.charset = copy.charset;
        this.definedSize = copy.definedSize;
        this.size = copy.size;
        this.completed = copy.completed;
        this.maxSize = copy.maxSize;
    }

    @Override
    public long getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }

    @Override
    public void checkSize(long newSize) throws IOException {
        if (this.maxSize >= 0L && newSize > this.maxSize) {
            throw new IOException("Size exceed allowed maximum capacity");
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCompleted() {
        return this.completed;
    }

    protected void setCompleted() {
        this.setCompleted(true);
    }

    protected void setCompleted(boolean completed) {
        this.completed = completed;
    }

    @Override
    public Charset getCharset() {
        return this.charset;
    }

    @Override
    public void setCharset(Charset charset) {
        this.charset = (Charset)ObjectUtil.checkNotNullWithIAE((Object)charset, (String)"charset");
    }

    @Override
    public long length() {
        return this.size;
    }

    @Override
    public long definedLength() {
        return this.definedSize;
    }

    @Override
    public <E extends Exception> void usingContent(Helpers.ThrowingConsumer<Buffer, E> callback) throws E {
        this.checkAccessible();
        try {
            this.usingBuffer(b -> callback.accept((Buffer)b));
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    protected RuntimeException createResourceClosedException() {
        return new IllegalStateException("Resource closed");
    }

    protected void checkAccessible() {
        if (!this.isAccessible()) {
            throw new IllegalStateException(this.getClass().getName() + " is innaccessible");
        }
    }

    protected void checkAccessible(Buffer cleanup) {
        if (!this.isAccessible()) {
            if (cleanup != null && cleanup.isAccessible()) {
                cleanup.close();
            }
            throw new IllegalStateException(this.getClass().getName() + " is innaccessible");
        }
    }
}

