/*
 * Decompiled with CFR 0.152.
 */
package io.netty.contrib.handler.codec.http.multipart;

import io.netty.contrib.handler.codec.http.multipart.AbstractHttpData;
import io.netty.contrib.handler.codec.http.multipart.DeleteFileOnExitHook;
import io.netty.contrib.handler.codec.http.multipart.Helpers;
import io.netty5.buffer.Buffer;
import io.netty5.buffer.DefaultBufferAllocators;
import io.netty5.channel.ChannelException;
import io.netty5.handler.codec.http.HttpConstants;
import io.netty5.util.internal.EmptyArrays;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import io.netty5.util.internal.logging.InternalLogger;
import io.netty5.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.file.Files;

public abstract class AbstractDiskHttpData
extends AbstractHttpData {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractDiskHttpData.class);
    private File file;
    private boolean isRenamed;
    private FileChannel fileChannel;

    protected AbstractDiskHttpData(String name, Charset charset, long size) {
        super(name, charset, size);
    }

    protected AbstractDiskHttpData(AbstractDiskHttpData copy) {
        super(copy);
        this.file = copy.file;
        this.isRenamed = copy.isRenamed;
        this.fileChannel = copy.fileChannel;
    }

    protected abstract String getDiskFilename();

    protected abstract String getPrefix();

    protected abstract String getBaseDirectory();

    protected abstract String getPostfix();

    protected abstract boolean deleteOnExit();

    private File tempFile() throws IOException {
        String diskFilename = this.getDiskFilename();
        Object newpostfix = diskFilename != null ? "_" + Integer.toString(diskFilename.hashCode()) : this.getPostfix();
        File tmpFile = this.getBaseDirectory() == null ? PlatformDependent.createTempFile((String)this.getPrefix(), (String)newpostfix, null) : PlatformDependent.createTempFile((String)this.getPrefix(), (String)newpostfix, (File)new File(this.getBaseDirectory()));
        if (this.deleteOnExit()) {
            DeleteFileOnExitHook.add(tmpFile.getPath());
        }
        return tmpFile;
    }

    @Override
    public void setContent(Buffer buffer) throws IOException {
        try (Buffer buffer2 = buffer;){
            this.checkAccessible();
            ObjectUtil.checkNotNullWithIAE((Object)buffer, (String)"buffer");
            this.size = buffer.readableBytes();
            this.checkSize(this.size);
            if (this.definedSize > 0L && this.definedSize < this.size) {
                throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
            }
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (buffer.readableBytes() == 0) {
                if (!this.file.createNewFile()) {
                    if (this.file.length() == 0L) {
                        return;
                    }
                    if (!this.file.delete() || !this.file.createNewFile()) {
                        throw new IOException("file exists already: " + this.file);
                    }
                }
                return;
            }
            try (RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");){
                accessFile.setLength(0L);
                try (FileChannel localfileChannel = accessFile.getChannel();){
                    int written;
                    int length = buffer.readableBytes();
                    while ((written = buffer.transferTo((WritableByteChannel)localfileChannel, length)) != -1 && (length = -written) > 0) {
                    }
                    localfileChannel.force(false);
                    this.setCompleted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addContent(Buffer buffer, boolean last) throws IOException {
        if (buffer != null) {
            try (Buffer buffer2 = buffer;){
                int written;
                this.checkAccessible();
                int localsize = buffer.readableBytes();
                this.checkSize(this.size + (long)localsize);
                if (this.definedSize > 0L && this.definedSize < this.size + (long)localsize) {
                    throw new IOException("Out of size: " + (this.size + (long)localsize) + " > " + this.definedSize);
                }
                if (this.file == null) {
                    this.file = this.tempFile();
                }
                if (this.fileChannel == null) {
                    RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
                    this.fileChannel = accessFile.getChannel();
                }
                int remaining = localsize;
                while ((written = buffer.transferTo((WritableByteChannel)this.fileChannel, remaining)) != -1 && (remaining -= written) > 0) {
                }
                this.size += (long)(localsize - remaining);
            }
        }
        if (last) {
            if (this.file == null) {
                this.file = this.tempFile();
            }
            if (this.fileChannel == null) {
                RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");
                this.fileChannel = accessFile.getChannel();
            }
            try {
                this.fileChannel.force(false);
            }
            finally {
                this.fileChannel.close();
            }
            this.fileChannel = null;
            this.setCompleted();
        } else {
            ObjectUtil.checkNotNullWithIAE((Object)buffer, (String)"buffer");
        }
    }

    @Override
    public void setContent(File file) throws IOException {
        this.checkAccessible();
        long size = file.length();
        this.checkSize(size);
        this.size = size;
        if (this.file != null) {
            this.delete();
        }
        this.file = file;
        this.isRenamed = true;
        this.setCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setContent(InputStream inputStream) throws IOException {
        this.checkAccessible();
        ObjectUtil.checkNotNullWithIAE((Object)inputStream, (String)"inputStream");
        if (this.file != null) {
            this.delete();
        }
        this.file = this.tempFile();
        int written = 0;
        try (RandomAccessFile accessFile = new RandomAccessFile(this.file, "rw");){
            accessFile.setLength(0L);
            FileChannel localfileChannel = accessFile.getChannel();
            byte[] bytes = new byte[16384];
            ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
            int read = inputStream.read(bytes);
            while (read > 0) {
                byteBuffer.position(read).flip();
                this.checkSize(written += localfileChannel.write(byteBuffer));
                read = inputStream.read(bytes);
            }
            localfileChannel.force(false);
        }
        this.size = written;
        if (this.definedSize > 0L && this.definedSize < this.size) {
            if (!this.file.delete()) {
                logger.warn("Failed to delete: {}", (Object)this.file);
            }
            this.file = null;
            throw new IOException("Out of size: " + this.size + " > " + this.definedSize);
        }
        this.isRenamed = true;
        this.setCompleted();
    }

    @Override
    public void delete() {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.force(false);
            }
            catch (IOException e) {
                logger.warn("Failed to force.", (Throwable)e);
            }
            finally {
                try {
                    this.fileChannel.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close a file.", (Throwable)e);
                }
            }
            this.fileChannel = null;
        }
        if (!this.isRenamed) {
            String filePath = null;
            if (this.file != null && this.file.exists()) {
                filePath = this.file.getPath();
                if (!this.file.delete()) {
                    filePath = null;
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
            }
            if (this.deleteOnExit() && filePath != null) {
                DeleteFileOnExitHook.remove(filePath);
            }
            this.file = null;
        }
    }

    @Override
    public byte[] get() throws IOException {
        this.checkAccessible();
        if (this.file == null) {
            return EmptyArrays.EMPTY_BYTES;
        }
        return AbstractDiskHttpData.readFrom(this.file);
    }

    @Override
    public <E extends Exception> void usingBuffer(Helpers.ThrowingConsumer<Buffer, E> callback) throws IOException, E {
        this.checkAccessible();
        Buffer buf = this.getContent();
        try {
            callback.accept(buf);
        }
        finally {
            if (buf != null && buf.isAccessible()) {
                buf.close();
            }
        }
    }

    @Override
    public Buffer getChunk(int length) throws IOException {
        this.checkAccessible();
        int remaining = length;
        if (this.file == null || length == 0) {
            return DefaultBufferAllocators.preferredAllocator().allocate(0);
        }
        if (this.fileChannel == null) {
            RandomAccessFile accessFile = new RandomAccessFile(this.file, "r");
            this.fileChannel = accessFile.getChannel();
        }
        Buffer buffer = DefaultBufferAllocators.onHeapAllocator().allocate(length);
        try {
            int read;
            while ((read = buffer.transferFrom((ReadableByteChannel)this.fileChannel, remaining)) >= 0 && (remaining -= read) > 0) {
            }
        }
        catch (IOException e) {
            this.fileChannel.close();
            this.fileChannel = null;
            buffer.close();
            throw e;
        }
        return buffer;
    }

    @Override
    public String getString() throws IOException {
        return this.getString(HttpConstants.DEFAULT_CHARSET);
    }

    @Override
    public String getString(Charset encoding) throws IOException {
        this.checkAccessible();
        if (this.file == null) {
            return "";
        }
        if (encoding == null) {
            byte[] array = AbstractDiskHttpData.readFrom(this.file);
            return new String(array, HttpConstants.DEFAULT_CHARSET.name());
        }
        byte[] array = AbstractDiskHttpData.readFrom(this.file);
        return new String(array, encoding.name());
    }

    @Override
    public boolean isInMemory() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean renameTo(File dest) throws IOException {
        this.checkAccessible();
        ObjectUtil.checkNotNullWithIAE((Object)dest, (String)"dest");
        if (this.file == null) {
            throw new IOException("No file defined so cannot be renamed");
        }
        if (!this.file.renameTo(dest)) {
            long position;
            IOException exception = null;
            RandomAccessFile inputAccessFile = null;
            RandomAccessFile outputAccessFile = null;
            long chunkSize = 8196L;
            try {
                inputAccessFile = new RandomAccessFile(this.file, "r");
                outputAccessFile = new RandomAccessFile(dest, "rw");
                FileChannel in = inputAccessFile.getChannel();
                FileChannel out = outputAccessFile.getChannel();
                for (position = 0L; position < this.size; position += in.transferTo(position, chunkSize, out)) {
                    if (chunkSize >= this.size - position) continue;
                    chunkSize = this.size - position;
                }
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                if (inputAccessFile != null) {
                    try {
                        inputAccessFile.close();
                    }
                    catch (IOException e) {
                        if (exception == null) {
                            exception = e;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", (Throwable)e);
                    }
                }
                if (outputAccessFile != null) {
                    try {
                        outputAccessFile.close();
                    }
                    catch (IOException e) {
                        if (exception == null) {
                            exception = e;
                        }
                        logger.warn("Multiple exceptions detected, the following will be suppressed {}", (Throwable)e);
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
            if (position == this.size) {
                if (!this.file.delete()) {
                    logger.warn("Failed to delete: {}", (Object)this.file);
                }
                this.file = dest;
                this.isRenamed = true;
                return true;
            }
            if (!dest.delete()) {
                logger.warn("Failed to delete: {}", (Object)dest);
            }
            return false;
        }
        this.file = dest;
        this.isRenamed = true;
        return true;
    }

    private static byte[] readFrom(File src) throws IOException {
        return Files.readAllBytes(src.toPath());
    }

    protected Buffer getContent() {
        try {
            return this.file == null ? DefaultBufferAllocators.preferredAllocator().allocate(0) : AbstractDiskHttpData.getBufferFrom(this.file);
        }
        catch (IOException e) {
            throw new ChannelException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Buffer getBufferFrom(File src) throws IOException {
        long srcsize = src.length();
        if (srcsize > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("File too big to be loaded in memory");
        }
        Buffer buf = DefaultBufferAllocators.onHeapAllocator().allocate((int)srcsize);
        try (RandomAccessFile raf = new RandomAccessFile(src, "r");){
            Buffer buffer;
            block15: {
                FileChannel channel = raf.getChannel();
                try {
                    int read;
                    int remaining = (int)srcsize;
                    while ((read = buf.transferFrom((ReadableByteChannel)channel, remaining)) >= 0 && (remaining -= read) > 0) {
                    }
                    buffer = buf;
                    if (channel == null) break block15;
                }
                catch (Throwable throwable) {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                channel.close();
            }
            return buffer;
        }
        catch (IOException e) {
            buf.close();
            throw e;
        }
    }

    @Override
    public File getFile() throws IOException {
        return this.file;
    }
}

