/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory.reflective;

import io.nanovc.AreaAPI;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.memory.MemoryCommit;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemorySearchQuery;
import io.nanovc.memory.MemorySearchResults;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepo;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepoEngine;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepoEngineAPI;
import io.nanovc.memory.reflective.ReflectiveObjectMemoryRepoHandlerAPI;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ReflectiveObjectNanoRepo
extends ReflectiveObjectMemoryRepo
implements ReflectiveObjectMemoryRepoHandlerAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo, ReflectiveObjectMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo>> {
    public static final ReflectiveObjectMemoryRepoEngine COMMON_ENGINE = new ReflectiveObjectMemoryRepoEngine();
    protected ReflectiveObjectMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo> engine = COMMON_ENGINE;
    public static final ClockWithVMNanos COMMON_CLOCK = new ClockWithVMNanos();
    private ClockAPI<? extends TimestampAPI> clock = COMMON_CLOCK;
    public static final DifferenceHandlerAPI<? extends DifferenceEngineAPI> COMMON_DIFFERENCE_HANDLER = HashMapDifferenceHandler.COMMON_DIFFERENCE_HANDLER;
    protected DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler = COMMON_DIFFERENCE_HANDLER;
    public static final ComparisonHandlerAPI<? extends ComparisonEngineAPI> COMMON_COMPARISON_HANDLER = HashMapComparisonHandler.COMMON_COMPARISON_HANDLER;
    protected ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler = COMMON_COMPARISON_HANDLER;
    public static final MergeHandlerAPI<? extends MergeEngineAPI> COMMON_MERGE_HANDLER = LastWinsMergeHandler.COMMON_MERGE_HANDLER;
    protected MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler = COMMON_MERGE_HANDLER;
    protected ByteArrayIndex byteArrayIndex;

    public ReflectiveObjectNanoRepo() {
        this.ensureDependenciesExist();
    }

    public ReflectiveObjectNanoRepo(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
        this.ensureDependenciesExist();
    }

    public ReflectiveObjectNanoRepo(ByteArrayIndex byteArrayIndex, ReflectiveObjectMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo> engine, ClockAPI<? extends TimestampAPI> clock, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.byteArrayIndex = byteArrayIndex;
        this.engine = engine;
        this.clock = clock;
        this.differenceHandler = differenceHandler;
        this.comparisonHandler = comparisonHandler;
        this.mergeHandler = mergeHandler;
        this.ensureDependenciesExist();
    }

    private void ensureDependenciesExist() {
        if (this.engine == null) {
            this.engine = COMMON_ENGINE;
        }
        if (this.byteArrayIndex == null) {
            this.byteArrayIndex = this.engine.createByteArrayIndex();
        }
        if (this.clock == null) {
            this.clock = this.engine.createClock();
        }
        if (this.differenceHandler == null) {
            this.differenceHandler = new HashMapDifferenceHandler();
        }
        if (this.comparisonHandler == null) {
            this.comparisonHandler = new HashMapComparisonHandler();
        }
        if (this.mergeHandler == null) {
            this.mergeHandler = new LastWinsMergeHandler();
        }
    }

    public ByteArrayHashMapArea createArea() {
        return (ByteArrayHashMapArea)this.getEngine().createArea(ByteArrayHashMapArea::new);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit parentCommit) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, parentCommit);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, List<MemoryCommit> parentCommits) {
        if (parentCommits == null) {
            return (MemoryCommit)this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
        }
        switch (parentCommits.size()) {
            case 0: {
                return (MemoryCommit)this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
            }
            case 1: {
                return (MemoryCommit)this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0));
            }
        }
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0), parentCommits.subList(1, parentCommits.size()));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, firstParentCommit, otherParentCommits);
    }

    public MemoryCommit commitToBranch(ByteArrayHashMapArea contentAreaToCommit, String branch, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commitToBranch(contentAreaToCommit, branch, message, commitTags, this, this.byteArrayIndex, this.clock);
    }

    public void createBranchAtCommit(MemoryCommit commit, String branchName) {
        this.getEngine().createBranchAtCommit(commit, branchName, this);
    }

    public void removeBranch(String branchName) {
        this.getEngine().removeBranch(this, branchName);
    }

    public MemoryCommit getLatestCommitForBranch(String branchName) {
        return (MemoryCommit)this.getEngine().getLatestCommitForBranch(branchName, this);
    }

    public void checkoutIntoArea(MemoryCommit commit, ByteArrayHashMapArea areaToUpdate) {
        this.getEngine().checkoutIntoArea(commit, this, areaToUpdate, ByteArrayContent::new);
    }

    public ByteArrayHashMapArea checkout(MemoryCommit commit) {
        return (ByteArrayHashMapArea)this.getEngine().checkout(commit, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public void tagCommit(MemoryCommit commit, String tagName) {
        this.getEngine().tagCommit(this, commit, tagName);
    }

    public MemoryCommit getCommitForTag(String tagName) {
        return (MemoryCommit)this.getEngine().getCommitForTag(this, tagName);
    }

    public void removeTag(String tagName) {
        this.getEngine().removeTag(this, tagName);
    }

    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.getEngine().computeDifferenceBetweenAreas(fromArea, toArea, this.differenceHandler);
    }

    public DifferenceAPI computeDifferenceBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeDifferenceBetweenCommits(fromCommit, toCommit, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public DifferenceAPI computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeDifferenceBetweenBranches(fromBranchName, toBranchName, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.getEngine().computeComparisonBetweenAreas(fromArea, toArea, this.comparisonHandler);
    }

    public ComparisonAPI computeComparisonBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeComparisonBetweenCommits(fromCommit, toCommit, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public ComparisonAPI computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeComparisonBetweenBranches(fromBranchName, toBranchName, this.comparisonHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    @Override
    public MemoryCommit commitObject(Object objectToCommit, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commitObject(objectToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    @Override
    public MemoryCommit commitObject(Object objectToCommit, String message, StringAreaAPI commitTags, MemoryCommit parentCommit) {
        return this.getEngine().commitObject(objectToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, ByteArrayHashMapArea::new, ByteArrayContent::new, parentCommit);
    }

    public MemoryCommit commitObject(Object objectToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.getEngine().commitObject(objectToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, ByteArrayHashMapArea::new, ByteArrayContent::new, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    @Override
    public MemoryCommit commitObject(Object objectToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.getEngine().commitObject(objectToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, ByteArrayHashMapArea::new, ByteArrayContent::new, firstParentCommit, otherParentCommits);
    }

    @Override
    public MemoryCommit commitObjectToBranch(Object objectToCommit, String branch, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commitObjectToBranch(objectToCommit, branch, message, commitTags, this, this.byteArrayIndex, this.clock, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    @Override
    public Object checkoutObject(MemoryCommit memoryCommit) {
        return this.getEngine().checkoutObject(memoryCommit, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public Set<String> getBranchNames() {
        return this.getEngine().getBranchNames(this);
    }

    public Set<String> getTagNames() {
        return this.getEngine().getTagNames(this);
    }

    public DifferenceHandlerAPI<? extends DifferenceEngineAPI> getDifferenceHandler() {
        return this.differenceHandler;
    }

    public void setDifferenceHandler(DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler) {
        this.differenceHandler = differenceHandler;
    }

    public ComparisonHandlerAPI<? extends ComparisonEngineAPI> getComparisonHandler() {
        return this.comparisonHandler;
    }

    public void setComparisonHandler(ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler) {
        this.comparisonHandler = comparisonHandler;
    }

    public MergeHandlerAPI<? extends MergeEngineAPI> getMergeHandler() {
        return this.mergeHandler;
    }

    public void setMergeHandler(MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.mergeHandler = mergeHandler;
    }

    public MemorySearchQuery prepareSearchQuery(SearchQueryDefinitionAPI searchQueryDefinition) {
        return (MemorySearchQuery)this.getEngine().prepareSearchQuery(searchQueryDefinition);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery) {
        return (MemorySearchResults)this.getEngine().searchWithQuery(searchQuery, null, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery, SearchParametersAPI overrideParameters) {
        return (MemorySearchResults)this.getEngine().searchWithQuery(searchQuery, overrideParameters, this, ByteArrayHashMapArea::new, ByteArrayContent::new);
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery);
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition, SearchParametersAPI overrideParameters) {
        MemorySearchQuery searchQuery = this.prepareSearchQuery(searchQueryDefinition);
        return this.searchWithQuery(searchQuery, overrideParameters);
    }

    public MemoryCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, commitTags, this.mergeHandler, this.comparisonHandler, this.differenceHandler, this, ByteArrayHashMapArea::new, ByteArrayContent::new, this.byteArrayIndex, this.clock);
    }

    public ByteArrayHashMapArea castOrCloneArea(AreaAPI<? extends ContentAPI> areaToCastOrClone) {
        return (ByteArrayHashMapArea)this.getEngine().castOrCloneArea(areaToCastOrClone, this::createArea, ByteArrayContent::new, this.byteArrayIndex);
    }

    public ReflectiveObjectMemoryRepo getRepo() {
        return this;
    }

    public void setRepo(ReflectiveObjectMemoryRepo repo) {
        throw new IllegalArgumentException("Cannot set a nano repo to another nano repo. That doesn't make sense for Object Oriented nano repos.");
    }

    public ReflectiveObjectMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo> getEngine() {
        return this.engine;
    }

    public void setEngine(ReflectiveObjectMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ReflectiveObjectMemoryRepo> engine) {
        this.engine = engine;
    }

    public ClockAPI<? extends TimestampAPI> getClock() {
        return this.clock;
    }

    public void setClock(ClockAPI<? extends TimestampAPI> clock) {
        this.clock = clock;
    }
}

