/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.AreaAPI;
import io.nanovc.AreaEntry;
import io.nanovc.AreaFactory;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.CommitAPI;
import io.nanovc.CommitTags;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.RepoEngineBase;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.ByteArrayAreaAPI;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.epochs.EpochWithVMNanos;
import io.nanovc.indexes.HashWrapperByteArrayIndex;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemoryRepoAPI;
import io.nanovc.memory.MemoryRepoEngineAPI;
import io.nanovc.memory.MemorySearchQueryAPI;
import io.nanovc.memory.MemorySearchResultsAPI;
import io.nanovc.searches.commits.HashMapSearchParameters;
import io.nanovc.searches.commits.expressions.AllRepoCommitsExpression;
import io.nanovc.searches.commits.expressions.CommitsExpression;
import io.nanovc.searches.commits.expressions.Expression;
import io.nanovc.searches.commits.expressions.TipOfExpression;
import io.nanovc.timestamps.TimestampWithVMNanos;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public abstract class MemoryRepoEngineBase<TContent extends ContentAPI, TArea extends AreaAPI<TContent>, TCommit extends MemoryCommitAPI<TCommit>, TSearchQuery extends MemorySearchQueryAPI<TCommit>, TSearchResults extends MemorySearchResultsAPI<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>>
extends RepoEngineBase<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo>
implements MemoryRepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo> {
    @Override
    public TArea createArea(AreaFactory<TContent, TArea> areaSupplier) {
        return (TArea)areaSupplier.createArea();
    }

    @Override
    public TContent createContent(byte[] bytes, ContentFactory<TContent> contentFactory) {
        return (TContent)contentFactory.createContent(bytes);
    }

    @Override
    public ByteArrayAreaAPI createSnapshotArea() {
        return new ByteArrayHashMapArea();
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TRepo repo, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, commitTags, byteArrayIndex, clock);
        repo.getDanglingCommits().add(commit);
        return commit;
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TRepo repo, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock, TCommit parentCommit) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, commitTags, byteArrayIndex, clock);
        commit.setFirstParent(parentCommit);
        LinkedHashSet danglingCommits = repo.getDanglingCommits();
        danglingCommits.add(commit);
        danglingCommits.remove(parentCommit);
        return commit;
    }

    @Override
    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TRepo repo, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock, TCommit firstParentCommit, List<TCommit> otherParentCommits) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, commitTags, byteArrayIndex, clock);
        commit.setFirstParent(firstParentCommit);
        commit.setOtherParents(otherParentCommits);
        LinkedHashSet danglingCommits = repo.getDanglingCommits();
        danglingCommits.add(commit);
        danglingCommits.remove(firstParentCommit);
        danglingCommits.removeAll(otherParentCommits);
        return commit;
    }

    @Override
    public TCommit commitToBranch(TArea contentAreaToCommit, String branchName, String message, StringAreaAPI commitTags, TRepo repo, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock) {
        TCommit commit = this.constructCommit(contentAreaToCommit, message, commitTags, byteArrayIndex, clock);
        MemoryCommitAPI previousCommit = (MemoryCommitAPI)repo.getBranchTips().get(branchName);
        if (previousCommit != null) {
            commit.setFirstParent((MemoryCommitAPI)previousCommit);
        }
        this.createBranchAtCommit(commit, branchName, repo);
        return commit;
    }

    @Override
    public void createBranchAtCommit(TCommit commit, String branchName, TRepo repo) {
        repo.getBranchTips().put(branchName, commit);
        repo.getDanglingCommits().remove(commit);
    }

    @Override
    public TCommit constructCommit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock) {
        TimestampAPI timestamp = clock.now();
        MemoryCommitAPI commit = this.createCommit();
        commit.setTimestamp(timestamp);
        commit.setMessage(message);
        commit.setCommitTags((StringAreaAPI)(commitTags == null ? CommitTags.none() : commitTags));
        ByteArrayAreaAPI snapshotArea = this.createSnapshotArea();
        for (AreaEntry areaEntry : contentAreaToCommit) {
            byte[] bytes = areaEntry.content.asByteArray();
            byte[] indexedBytes = byteArrayIndex.addOrLookup(bytes);
            snapshotArea.putBytes(areaEntry.path, indexedBytes);
        }
        commit.setSnapshot(snapshotArea);
        return (TCommit)commit;
    }

    @Override
    public void removeBranch(TRepo repo, String branchName) {
        MemoryCommitAPI removedCommit = (MemoryCommitAPI)repo.getBranchTips().remove(branchName);
        if (removedCommit != null) {
            this.addDanglingCommitIfNotReferencedAnywhereElse(repo, removedCommit);
        }
    }

    protected void addDanglingCommitIfNotReferencedAnywhereElse(TRepo repo, TCommit commitToSearchFor) {
        IdentityHashMap visitedCommits = new IdentityHashMap();
        for (MemoryCommitAPI branchTip : repo.getBranchTips().values()) {
            if (!this.scanForCommitRecursively(commitToSearchFor, branchTip, visitedCommits)) continue;
            return;
        }
        for (MemoryCommitAPI tagTip : repo.getTags().values()) {
            if (!this.scanForCommitRecursively(commitToSearchFor, tagTip, visitedCommits)) continue;
            return;
        }
        for (MemoryCommitAPI danglingCommit : repo.getDanglingCommits()) {
            if (!this.scanForCommitRecursively(commitToSearchFor, danglingCommit, visitedCommits)) continue;
            return;
        }
        repo.getDanglingCommits().add(commitToSearchFor);
    }

    protected boolean scanForCommitRecursively(TCommit commitToSearchFor, TCommit commitToSearchFrom, IdentityHashMap<TCommit, TCommit> visitedCommits) {
        if (commitToSearchFor == commitToSearchFrom) {
            visitedCommits.put(commitToSearchFor, commitToSearchFor);
            return true;
        }
        if (visitedCommits.containsKey(commitToSearchFrom)) {
            return false;
        }
        if (this.scanForCommitRecursively(commitToSearchFor, commitToSearchFrom.getFirstParent(), visitedCommits)) {
            return true;
        }
        List otherParents = commitToSearchFrom.getOtherParents();
        if (otherParents != null && otherParents.size() > 0) {
            for (MemoryCommitAPI otherParent : otherParents) {
                if (!this.scanForCommitRecursively(commitToSearchFor, otherParent, visitedCommits)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void checkoutIntoArea(TCommit commit, TRepo repo, TArea areaToUpdate, ContentFactory<TContent> contentFactory) {
        for (AreaEntry snapshotEntry : commit.getSnapshot()) {
            TContent destinationContent = this.createContent(((ByteArrayContent)snapshotEntry.content).getEfficientByteArray(), contentFactory);
            areaToUpdate.putContent(snapshotEntry.path, destinationContent);
        }
    }

    @Override
    public TArea checkout(TCommit commit, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea area = this.createArea(areaFactory);
        this.checkoutIntoArea(commit, repo, area, contentFactory);
        return area;
    }

    @Override
    public ByteArrayIndex createByteArrayIndex() {
        return new HashWrapperByteArrayIndex();
    }

    @Override
    public ClockAPI<? extends TimestampAPI> createClock() {
        return new ClockWithVMNanos();
    }

    @Override
    public TCommit getLatestCommitForBranch(String branchName, TRepo repo) {
        return (TCommit)((MemoryCommitAPI)repo.getBranchTips().get(branchName));
    }

    @Override
    public Set<String> getBranchNames(TRepo repo) {
        return new HashSet<String>(repo.getBranchTips().keySet());
    }

    @Override
    public Set<String> getTagNames(TRepo repo) {
        return new HashSet<String>(repo.getTags().keySet());
    }

    @Override
    public void tagCommit(TRepo repo, TCommit commit, String tagName) {
        repo.getTags().put(tagName, commit);
        repo.getDanglingCommits().remove(commit);
    }

    @Override
    public TCommit getCommitForTag(TRepo repo, String tagName) {
        return (TCommit)((MemoryCommitAPI)repo.getTags().get(tagName));
    }

    @Override
    public void removeTag(TRepo repo, String tagName) {
        MemoryCommitAPI removedCommit = (MemoryCommitAPI)repo.getTags().remove(tagName);
        if (removedCommit != null) {
            this.addDanglingCommitIfNotReferencedAnywhereElse(repo, removedCommit);
        }
    }

    @Override
    public void optimizeTimestamps(TRepo repo) {
        TimestampWithVMNanos timestampWithVMNanos;
        HashSet commits = new HashSet(repo.getDanglingCommits());
        IdentityHashMap identities = new IdentityHashMap();
        for (MemoryCommitAPI commit : repo.getBranchTips().values()) {
            this.extractCommitsRecursively(commit, identities, commits);
        }
        EpochWithVMNanos bestEpochWithVMNanos = null;
        HashSet<MemoryCommitAPI> commitsToProcess = new HashSet<MemoryCommitAPI>();
        for (MemoryCommitAPI commit : commits) {
            if (!(commit.getTimestamp() instanceof TimestampWithVMNanos)) continue;
            timestampWithVMNanos = (TimestampWithVMNanos)commit.getTimestamp();
            commitsToProcess.add(commit);
            if (bestEpochWithVMNanos == null) {
                bestEpochWithVMNanos = timestampWithVMNanos.epoch;
                continue;
            }
            if (timestampWithVMNanos.epoch == bestEpochWithVMNanos || timestampWithVMNanos.epoch.getNanoTimeDurationLong() >= bestEpochWithVMNanos.getNanoTimeDurationLong()) continue;
            bestEpochWithVMNanos = timestampWithVMNanos.epoch;
        }
        for (MemoryCommitAPI commit : commitsToProcess) {
            if (!(commit.getTimestamp() instanceof TimestampWithVMNanos)) continue;
            timestampWithVMNanos = (TimestampWithVMNanos)commit.getTimestamp();
            if (timestampWithVMNanos.epoch == bestEpochWithVMNanos) continue;
            TimestampWithVMNanos rebasedTimestamp = new TimestampWithVMNanos(bestEpochWithVMNanos, timestampWithVMNanos.nanoTime);
            commit.setTimestamp((TimestampAPI)rebasedTimestamp);
        }
    }

    @Override
    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends TContent> fromArea, AreaAPI<? extends TContent> toArea, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler) {
        return differenceHandler.computeDifference(fromArea, toArea);
    }

    @Override
    public DifferenceAPI computeDifferenceBetweenCommits(TCommit fromCommit, TCommit toCommit, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea fromArea = this.checkout(fromCommit, repo, areaFactory, contentFactory);
        TArea toArea = this.checkout(toCommit, repo, areaFactory, contentFactory);
        return this.computeDifferenceBetweenAreas((AreaAPI<? extends TContent>)fromArea, (AreaAPI<? extends TContent>)toArea, differenceHandler);
    }

    @Override
    public DifferenceAPI computeDifferenceBetweenBranches(String fromBranchName, String toBranchName, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TCommit fromCommit = this.getLatestCommitForBranch(fromBranchName, repo);
        TCommit toCommit = this.getLatestCommitForBranch(toBranchName, repo);
        return this.computeDifferenceBetweenCommits(fromCommit, toCommit, differenceHandler, repo, areaFactory, contentFactory);
    }

    @Override
    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends TContent> fromArea, AreaAPI<? extends TContent> toArea, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler) {
        return comparisonHandler.compare(fromArea, toArea);
    }

    @Override
    public ComparisonAPI computeComparisonBetweenCommits(TCommit fromCommit, TCommit toCommit, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TArea fromArea = this.checkout(fromCommit, repo, areaFactory, contentFactory);
        TArea toArea = this.checkout(toCommit, repo, areaFactory, contentFactory);
        return this.computeComparisonBetweenAreas((AreaAPI<? extends TContent>)fromArea, (AreaAPI<? extends TContent>)toArea, comparisonHandler);
    }

    @Override
    public ComparisonAPI computeComparisonBetweenBranches(String fromBranchName, String toBranchName, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        TCommit fromCommit = this.getLatestCommitForBranch(fromBranchName, repo);
        TCommit toCommit = this.getLatestCommitForBranch(toBranchName, repo);
        return this.computeComparisonBetweenCommits(fromCommit, toCommit, comparisonHandler, repo, areaFactory, contentFactory);
    }

    @Override
    public TSearchQuery prepareSearchQuery(SearchQueryDefinitionAPI searchQueryDefinition) {
        MemorySearchQueryAPI searchQuery = this.createSearchQuery(searchQueryDefinition);
        return (TSearchQuery)searchQuery;
    }

    @Override
    public TSearchResults searchWithQuery(TSearchQuery searchQuery, SearchParametersAPI overrideParameters, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory) {
        MemorySearchResultsAPI searchResults = this.createSearchResults((MemorySearchQueryAPI)searchQuery);
        SearchParametersAPI parameters = searchQuery.getDefinition().getParameters();
        if (overrideParameters != null) {
            HashMapSearchParameters updatedSearchParameters = new HashMapSearchParameters();
            updatedSearchParameters.putAll((Map)parameters);
            updatedSearchParameters.putAll((Map)overrideParameters);
            parameters = updatedSearchParameters;
        }
        List commitsToAddTo = searchResults.getCommits();
        Expression singleCommitExpression = searchQuery.getDefinition().getSingleCommitExpression();
        if (singleCommitExpression != null) {
            this.walkSingleCommitSearchExpression((Expression<CommitAPI>)singleCommitExpression, parameters, repo, commitsToAddTo);
        } else {
            Expression listOfCommitsExpression = searchQuery.getDefinition().getListOfCommitsExpression();
            this.walkListOfCommitsSearchExpression((Expression<List<CommitAPI>>)listOfCommitsExpression, parameters, repo, commitsToAddTo);
        }
        return (TSearchResults)searchResults;
    }

    public void walkListOfCommitsSearchExpression(Expression<List<CommitAPI>> expression, SearchParametersAPI parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        switch (expression.getClass().getSimpleName()) {
            case "AllRepoCommitsExpression": {
                this.walkAllRepoCommitsExpression((AllRepoCommitsExpression)expression, parameters, repo, commitsToAddTo);
            }
        }
    }

    public void walkSingleCommitSearchExpression(Expression<CommitAPI> expression, SearchParametersAPI parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        switch (expression.getClass().getSimpleName()) {
            case "TipOfExpression": {
                this.walkTipOfExpression((TipOfExpression)expression, parameters, repo, commitsToAddTo);
            }
        }
    }

    public void walkTipOfExpression(TipOfExpression expression, SearchParametersAPI parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        CommitsExpression operand = expression.getOperand();
        this.walkListOfCommitsSearchExpression((Expression<List<CommitAPI>>)operand, parameters, repo, commitsToAddTo);
        MemoryCommitAPI lastCommit = (MemoryCommitAPI)commitsToAddTo.get(commitsToAddTo.size() - 1);
        commitsToAddTo.clear();
        commitsToAddTo.add(lastCommit);
    }

    public void walkAllRepoCommitsExpression(AllRepoCommitsExpression expression, SearchParametersAPI parameters, TRepo repo, List<TCommit> commitsToAddTo) {
        TreeSet<MemoryCommitAPI> commitSet = new TreeSet<MemoryCommitAPI>(Comparator.comparing(tCommit -> tCommit.getTimestamp().getInstant()));
        IdentityHashMap identities = new IdentityHashMap();
        LinkedHashSet initialCommitSet = new LinkedHashSet();
        initialCommitSet.addAll(repo.getBranchTips().values());
        initialCommitSet.addAll(repo.getTags().values());
        initialCommitSet.addAll(repo.getDanglingCommits());
        for (MemoryCommitAPI tipCommit : initialCommitSet) {
            this.extractCommitsRecursively(tipCommit, identities, commitSet);
        }
        commitsToAddTo.addAll(commitSet);
    }

    public void extractCommitsRecursively(TCommit currentCommit, IdentityHashMap<TCommit, TCommit> previouslySeenIdentities, Set<TCommit> commitSetToAddTo) {
        List otherParents;
        if (previouslySeenIdentities.containsKey(currentCommit)) {
            return;
        }
        previouslySeenIdentities.put(currentCommit, currentCommit);
        commitSetToAddTo.add(currentCommit);
        Object firstParent = currentCommit.getFirstParent();
        if (firstParent != null) {
            this.extractCommitsRecursively(firstParent, previouslySeenIdentities, commitSetToAddTo);
        }
        if ((otherParents = currentCommit.getOtherParents()) != null && otherParents.size() > 0) {
            for (MemoryCommitAPI otherParent : otherParents) {
                this.extractCommitsRecursively(otherParent, previouslySeenIdentities, commitSetToAddTo);
            }
        }
    }

    @Override
    public TCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, StringAreaAPI commitTags, MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, TRepo repo, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex, ClockAPI<? extends TimestampAPI> clock) {
        Object mergedArea;
        TCommit sourceCommit = this.getLatestCommitForBranch(sourceBranchName, repo);
        TCommit destinationCommit = this.getLatestCommitForBranch(destinationBranchName, repo);
        DifferenceAPI differenceBetweenCommits = this.computeDifferenceBetweenCommits(destinationCommit, sourceCommit, differenceHandler, repo, areaFactory, contentFactory);
        if (differenceBetweenCommits.hasDifferences()) {
            mergedArea = areaFactory.createArea();
            TArea sourceArea = this.checkout(sourceCommit, repo, areaFactory, contentFactory);
            TArea destinationArea = this.checkout(destinationCommit, repo, areaFactory, contentFactory);
            ComparisonAPI comparisonBetweenSourceAndDestination = this.computeComparisonBetweenAreas((AreaAPI<? extends TContent>)destinationArea, (AreaAPI<? extends TContent>)sourceArea, comparisonHandler);
            TCommit commonAncestorCommit = this.findCommonAncestorOfCommits(sourceCommit, destinationCommit);
            if (commonAncestorCommit == null) {
                mergeHandler.mergeIntoAreaWithTwoWayDiff(mergedArea, sourceCommit, destinationCommit, sourceArea, destinationArea, comparisonBetweenSourceAndDestination, contentFactory, byteArrayIndex);
            } else {
                TArea commonAncestorArea = this.checkout(commonAncestorCommit, repo, areaFactory, contentFactory);
                DifferenceAPI differenceBetweenAncestorAndSource = this.computeDifferenceBetweenAreas((AreaAPI<? extends TContent>)commonAncestorArea, (AreaAPI<? extends TContent>)sourceArea, differenceHandler);
                DifferenceAPI differenceBetweenAncestorAndDestination = this.computeDifferenceBetweenAreas((AreaAPI<? extends TContent>)commonAncestorArea, (AreaAPI<? extends TContent>)destinationArea, differenceHandler);
                mergeHandler.mergeIntoAreaWithThreeWayDiff(mergedArea, commonAncestorCommit, sourceCommit, destinationCommit, commonAncestorArea, sourceArea, destinationArea, comparisonBetweenSourceAndDestination, differenceBetweenAncestorAndSource, differenceBetweenAncestorAndDestination, contentFactory, byteArrayIndex);
            }
        } else {
            mergedArea = this.checkout(destinationCommit, repo, areaFactory, contentFactory);
        }
        TCommit mergeCommit = this.commitToBranch(mergedArea, destinationBranchName, message, commitTags, repo, byteArrayIndex, clock);
        mergeCommit.setOtherParents(new ArrayList());
        mergeCommit.getOtherParents().add(sourceCommit);
        return mergeCommit;
    }

    public TCommit findCommonAncestorOfCommits(TCommit commit1, TCommit commit2) {
        IdentityHashMap identities1 = new IdentityHashMap();
        HashSet parentCommits1 = new HashSet();
        this.extractCommitsRecursively(commit1, identities1, parentCommits1);
        IdentityHashMap identities2 = new IdentityHashMap();
        return this.findCommonAncestorOfCommitsRecursive(commit2, identities2, identities1);
    }

    private TCommit findCommonAncestorOfCommitsRecursive(TCommit currentCommit, IdentityHashMap<TCommit, TCommit> previouslySeenIdentities, IdentityHashMap<TCommit, TCommit> otherCommitsToSearchAgainst) {
        Object commonAncestor;
        if (previouslySeenIdentities.containsKey(currentCommit)) {
            return null;
        }
        previouslySeenIdentities.put(currentCommit, currentCommit);
        if (otherCommitsToSearchAgainst.containsKey(currentCommit)) {
            return currentCommit;
        }
        Object firstParent = currentCommit.getFirstParent();
        if (firstParent != null && (commonAncestor = this.findCommonAncestorOfCommitsRecursive(firstParent, previouslySeenIdentities, otherCommitsToSearchAgainst)) != null) {
            return (TCommit)commonAncestor;
        }
        List otherParents = currentCommit.getOtherParents();
        if (otherParents != null && otherParents.size() > 0) {
            for (MemoryCommitAPI otherParent : otherParents) {
                MemoryCommitAPI commonAncestor2 = this.findCommonAncestorOfCommitsRecursive(otherParent, previouslySeenIdentities, otherCommitsToSearchAgainst);
                if (commonAncestor2 == null) continue;
                return (TCommit)commonAncestor2;
            }
        }
        return null;
    }

    @Override
    public TArea castOrCloneArea(AreaAPI<? extends ContentAPI> areaToCastOrClone, AreaFactory<TContent, TArea> areaFactory, ContentFactory<TContent> contentFactory, ByteArrayIndex byteArrayIndex) {
        AreaAPI clonedArea = areaFactory.createArea();
        for (AreaEntry areaEntry : areaToCastOrClone) {
            byte[] bytes = byteArrayIndex.addOrLookup(areaEntry.content.asByteArray());
            ContentAPI clonedContent = contentFactory.createContent(bytes);
            clonedArea.putContent(areaEntry.path, clonedContent);
        }
        return (TArea)clonedArea;
    }
}

