/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.AreaAPI;
import io.nanovc.AreaFactory;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.RepoEngineAPI;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.ByteArrayAreaAPI;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemoryRepoAPI;
import io.nanovc.memory.MemorySearchQueryAPI;
import io.nanovc.memory.MemorySearchResultsAPI;
import java.util.List;
import java.util.Set;

public interface MemoryRepoEngineAPI<TContent extends ContentAPI, TArea extends AreaAPI<TContent>, TCommit extends MemoryCommitAPI<TCommit>, TSearchQuery extends MemorySearchQueryAPI<TCommit>, TSearchResults extends MemorySearchResultsAPI<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>>
extends RepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo> {
    public TRepo createRepo();

    public TCommit createCommit();

    default public TArea createArea(AreaFactory<TContent, TArea> areaSupplier) {
        return (TArea)areaSupplier.createArea();
    }

    public ByteArrayAreaAPI createSnapshotArea();

    public TContent createContent(byte[] var1, ContentFactory<TContent> var2);

    public TCommit commit(TArea var1, String var2, StringAreaAPI var3, TRepo var4, ByteArrayIndex var5, ClockAPI<? extends TimestampAPI> var6);

    public TCommit commit(TArea var1, String var2, StringAreaAPI var3, TRepo var4, ByteArrayIndex var5, ClockAPI<? extends TimestampAPI> var6, TCommit var7);

    public TCommit commit(TArea var1, String var2, StringAreaAPI var3, TRepo var4, ByteArrayIndex var5, ClockAPI<? extends TimestampAPI> var6, TCommit var7, List<TCommit> var8);

    public TCommit commitToBranch(TArea var1, String var2, String var3, StringAreaAPI var4, TRepo var5, ByteArrayIndex var6, ClockAPI<? extends TimestampAPI> var7);

    public TCommit constructCommit(TArea var1, String var2, StringAreaAPI var3, ByteArrayIndex var4, ClockAPI<? extends TimestampAPI> var5);

    public void checkoutIntoArea(TCommit var1, TRepo var2, TArea var3, ContentFactory<TContent> var4);

    public TArea checkout(TCommit var1, TRepo var2, AreaFactory<TContent, TArea> var3, ContentFactory<TContent> var4);

    public ByteArrayIndex createByteArrayIndex();

    public ClockAPI<? extends TimestampAPI> createClock();

    public TCommit getLatestCommitForBranch(String var1, TRepo var2);

    public Set<String> getBranchNames(TRepo var1);

    public Set<String> getTagNames(TRepo var1);

    public void tagCommit(TRepo var1, TCommit var2, String var3);

    public TCommit getCommitForTag(TRepo var1, String var2);

    public void removeTag(TRepo var1, String var2);

    public void optimizeTimestamps(TRepo var1);

    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends TContent> var1, AreaAPI<? extends TContent> var2, DifferenceHandlerAPI<? extends DifferenceEngineAPI> var3);

    public DifferenceAPI computeDifferenceBetweenCommits(TCommit var1, TCommit var2, DifferenceHandlerAPI<? extends DifferenceEngineAPI> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public DifferenceAPI computeDifferenceBetweenBranches(String var1, String var2, DifferenceHandlerAPI<? extends DifferenceEngineAPI> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends TContent> var1, AreaAPI<? extends TContent> var2, ComparisonHandlerAPI<? extends ComparisonEngineAPI> var3);

    public ComparisonAPI computeComparisonBetweenCommits(TCommit var1, TCommit var2, ComparisonHandlerAPI<? extends ComparisonEngineAPI> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public ComparisonAPI computeComparisonBetweenBranches(String var1, String var2, ComparisonHandlerAPI<? extends ComparisonEngineAPI> var3, TRepo var4, AreaFactory<TContent, TArea> var5, ContentFactory<TContent> var6);

    public TSearchQuery createSearchQuery(SearchQueryDefinitionAPI var1);

    public TSearchQuery prepareSearchQuery(SearchQueryDefinitionAPI var1);

    public TSearchResults createSearchResults(TSearchQuery var1);

    public TSearchResults searchWithQuery(TSearchQuery var1, SearchParametersAPI var2, TRepo var3, AreaFactory<TContent, TArea> var4, ContentFactory<TContent> var5);

    public TCommit mergeIntoBranchFromAnotherBranch(String var1, String var2, String var3, StringAreaAPI var4, MergeHandlerAPI<? extends MergeEngineAPI> var5, ComparisonHandlerAPI<? extends ComparisonEngineAPI> var6, DifferenceHandlerAPI<? extends DifferenceEngineAPI> var7, TRepo var8, AreaFactory<TContent, TArea> var9, ContentFactory<TContent> var10, ByteArrayIndex var11, ClockAPI<? extends TimestampAPI> var12);

    public void createBranchAtCommit(TCommit var1, String var2, TRepo var3);

    public void removeBranch(TRepo var1, String var2);

    public TArea castOrCloneArea(AreaAPI<? extends ContentAPI> var1, AreaFactory<TContent, TArea> var2, ContentFactory<TContent> var3, ByteArrayIndex var4);
}

