/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory.bytes;

import io.nanovc.AreaAPI;
import io.nanovc.AreaFactory;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.areas.ByteArrayHashMapArea;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.clocks.ClockWithVMNanos;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.content.ByteArrayContent;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.indexes.HashWrapperByteArrayIndex;
import io.nanovc.memory.MemoryCommit;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemorySearchQuery;
import io.nanovc.memory.MemorySearchResults;
import io.nanovc.memory.bytes.ByteArrayMemoryRepo;
import io.nanovc.memory.bytes.ByteArrayMemoryRepoEngine;
import io.nanovc.memory.bytes.ByteArrayMemoryRepoEngineAPI;
import io.nanovc.memory.bytes.ByteArrayMemoryRepoHandlerAPI;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public class ByteArrayNanoRepo
extends ByteArrayMemoryRepo
implements ByteArrayMemoryRepoHandlerAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo, ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo>> {
    private ByteArrayIndex byteArrayIndex;
    private ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo> engine = COMMON_ENGINE;
    public static final ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo> COMMON_ENGINE = new ByteArrayMemoryRepoEngine();
    public static final ClockWithVMNanos COMMON_CLOCK = new ClockWithVMNanos();
    private ClockAPI<? extends TimestampAPI> clock = COMMON_CLOCK;
    public static final DifferenceHandlerAPI<? extends DifferenceEngineAPI> COMMON_DIFFERENCE_HANDLER = HashMapDifferenceHandler.COMMON_DIFFERENCE_HANDLER;
    protected DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler = COMMON_DIFFERENCE_HANDLER;
    public static final ComparisonHandlerAPI<? extends ComparisonEngineAPI> COMMON_COMPARISON_HANDLER = HashMapComparisonHandler.COMMON_COMPARISON_HANDLER;
    protected ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler = COMMON_COMPARISON_HANDLER;
    public static final MergeHandlerAPI<? extends MergeEngineAPI> COMMON_MERGE_HANDLER = LastWinsMergeHandler.COMMON_MERGE_HANDLER;
    protected MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler = COMMON_MERGE_HANDLER;

    public ByteArrayNanoRepo(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
    }

    public ByteArrayNanoRepo() {
        this.byteArrayIndex = new HashWrapperByteArrayIndex();
    }

    public ByteArrayNanoRepo(ByteArrayIndex byteArrayIndex, ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo> engine, ClockAPI<? extends TimestampAPI> clock, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.byteArrayIndex = byteArrayIndex;
        this.engine = engine;
        this.clock = clock;
        this.differenceHandler = differenceHandler;
        this.comparisonHandler = comparisonHandler;
        this.mergeHandler = mergeHandler;
    }

    public ByteArrayHashMapArea createArea() {
        return new ByteArrayHashMapArea();
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.getByteArrayIndex(), this.getClock());
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit parentCommit) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.getByteArrayIndex(), this.getClock(), parentCommit);
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, MemoryCommit ... otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.getByteArrayIndex(), this.getClock(), firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, List<MemoryCommit> parentCommits) {
        if (parentCommits == null) {
            return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
        }
        switch (parentCommits.size()) {
            case 0: {
                return (MemoryCommit)this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock);
            }
            case 1: {
                return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommit)((MemoryCommitAPI)parentCommits.get(0)));
            }
        }
        return this.engine.commit(contentAreaToCommit, message, commitTags, this, this.byteArrayIndex, this.clock, (MemoryCommit)((MemoryCommitAPI)parentCommits.get(0)), parentCommits.subList(1, parentCommits.size()));
    }

    public MemoryCommit commit(ByteArrayHashMapArea contentAreaToCommit, String message, StringAreaAPI commitTags, MemoryCommit firstParentCommit, List<MemoryCommit> otherParentCommits) {
        return this.getEngine().commit(contentAreaToCommit, message, commitTags, this, this.getByteArrayIndex(), this.getClock(), firstParentCommit, otherParentCommits);
    }

    public MemoryCommit commitToBranch(ByteArrayHashMapArea contentAreaToCommit, String branch, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().commitToBranch(contentAreaToCommit, branch, message, commitTags, this, this.getByteArrayIndex(), this.getClock());
    }

    public void createBranchAtCommit(MemoryCommit commit, String branchName) {
        this.getEngine().createBranchAtCommit(commit, branchName, this);
    }

    public MemoryCommit getLatestCommitForBranch(String branchName) {
        return (MemoryCommit)this.getEngine().getLatestCommitForBranch(branchName, this);
    }

    public void checkoutIntoArea(MemoryCommit commit, ByteArrayHashMapArea areaToUpdate) {
        this.getEngine().checkoutIntoArea(commit, this, areaToUpdate, this::createContent);
    }

    public ByteArrayHashMapArea checkout(MemoryCommit commit) {
        return (ByteArrayHashMapArea)this.getEngine().checkout(commit, this, this::createArea, this::createContent);
    }

    public void tagCommit(MemoryCommit commit, String tagName) {
        this.getEngine().tagCommit(this, commit, tagName);
    }

    public MemoryCommit getCommitForTag(String tagName) {
        return (MemoryCommit)this.getEngine().getCommitForTag(this, tagName);
    }

    public void removeTag(String tagName) {
        this.getEngine().removeTag(this, tagName);
    }

    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.getEngine().computeDifferenceBetweenAreas(fromArea, toArea, this.getDifferenceHandler());
    }

    public DifferenceAPI computeDifferenceBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeDifferenceBetweenCommits(fromCommit, toCommit, this.getDifferenceHandler(), this, this::createArea, this::createContent);
    }

    public DifferenceAPI computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeDifferenceBetweenBranches(fromBranchName, toBranchName, this.getDifferenceHandler(), this, this::createArea, this::createContent);
    }

    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends ByteArrayContent> fromArea, AreaAPI<? extends ByteArrayContent> toArea) {
        return this.getEngine().computeComparisonBetweenAreas(fromArea, toArea, this.getComparisonHandler());
    }

    public ComparisonAPI computeComparisonBetweenCommits(MemoryCommit fromCommit, MemoryCommit toCommit) {
        return this.getEngine().computeComparisonBetweenCommits(fromCommit, toCommit, this.getComparisonHandler(), this, this::createArea, this::createContent);
    }

    public ComparisonAPI computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return this.getEngine().computeComparisonBetweenBranches(fromBranchName, toBranchName, this.getComparisonHandler(), this, this::createArea, this::createContent);
    }

    protected ByteArrayContent createContent(byte[] contentBytes) {
        return new ByteArrayContent(contentBytes);
    }

    public Set<String> getBranchNames() {
        return this.getEngine().getBranchNames(this);
    }

    public Set<String> getTagNames() {
        return this.getEngine().getTagNames(this);
    }

    public ByteArrayHashMapArea castOrCloneArea(AreaAPI<? extends ContentAPI> areaToCastOrClone) {
        return this.engine.castOrCloneArea(areaToCastOrClone, (AreaFactory<ByteArrayContent, ByteArrayHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<ByteArrayContent>)((ContentFactory)this::createContent), this.byteArrayIndex);
    }

    public ByteArrayNanoRepo getRepo() {
        return this;
    }

    public void setRepo(ByteArrayMemoryRepo repo) {
        throw new IllegalArgumentException("Cannot set a string nano repo to another string nano repo. That doesn't make sense for Object Oriented nano repos.");
    }

    public ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo> getEngine() {
        return this.engine;
    }

    public void setEngine(ByteArrayMemoryRepoEngineAPI<ByteArrayContent, ByteArrayHashMapArea, MemoryCommit, MemorySearchQuery, MemorySearchResults, ByteArrayMemoryRepo> engine) {
        this.engine = engine;
    }

    public DifferenceHandlerAPI<? extends DifferenceEngineAPI> getDifferenceHandler() {
        return this.differenceHandler;
    }

    public void setDifferenceHandler(DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler) {
        this.differenceHandler = differenceHandler;
    }

    public ComparisonHandlerAPI<? extends ComparisonEngineAPI> getComparisonHandler() {
        return this.comparisonHandler;
    }

    public void setComparisonHandler(ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler) {
        this.comparisonHandler = comparisonHandler;
    }

    public MergeHandlerAPI<? extends MergeEngineAPI> getMergeHandler() {
        return this.mergeHandler;
    }

    public void setMergeHandler(MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        this.mergeHandler = mergeHandler;
    }

    public MemorySearchQuery prepareSearchQuery(SearchQueryDefinitionAPI searchQueryDefinition) {
        return (MemorySearchQuery)this.getEngine().prepareSearchQuery(searchQueryDefinition);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery) {
        return (MemorySearchResults)this.getEngine().searchWithQuery(searchQuery, null, this, this::createArea, this::createContent);
    }

    public MemorySearchResults searchWithQuery(MemorySearchQuery searchQuery, SearchParametersAPI overrideParameters) {
        return (MemorySearchResults)this.getEngine().searchWithQuery(searchQuery, overrideParameters, this, this::createArea, this::createContent);
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition) {
        MemorySearchQuery searchQuery = (MemorySearchQuery)this.engine.prepareSearchQuery(searchQueryDefinition);
        return (MemorySearchResults)this.engine.searchWithQuery(searchQuery, null, this, (AreaFactory<ByteArrayContent, ByteArrayHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<ByteArrayContent>)((ContentFactory)this::createContent));
    }

    public MemorySearchResults search(SearchQueryDefinitionAPI searchQueryDefinition, SearchParametersAPI overrideParameters) {
        MemorySearchQuery searchQuery = (MemorySearchQuery)this.engine.prepareSearchQuery(searchQueryDefinition);
        return (MemorySearchResults)this.engine.searchWithQuery(searchQuery, overrideParameters, this, (AreaFactory<ByteArrayContent, ByteArrayHashMapArea>)((AreaFactory)this::createArea), (ContentFactory<ByteArrayContent>)((ContentFactory)this::createContent));
    }

    public MemoryCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, StringAreaAPI commitTags) {
        return (MemoryCommit)this.getEngine().mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, commitTags, this.mergeHandler, this.getComparisonHandler(), this.getDifferenceHandler(), this, this::createArea, this::createContent, this.getByteArrayIndex(), this.getClock());
    }

    public ByteArrayIndex getByteArrayIndex() {
        return this.byteArrayIndex;
    }

    public void setByteArrayIndex(ByteArrayIndex byteArrayIndex) {
        this.byteArrayIndex = byteArrayIndex;
    }

    public ClockAPI<? extends TimestampAPI> getClock() {
        return this.clock;
    }

    public void setClock(ClockAPI<? extends TimestampAPI> clock) {
        this.clock = clock;
    }
}

