/*
 * Decompiled with CFR 0.152.
 */
package io.nanovc.memory;

import io.nanovc.AreaAPI;
import io.nanovc.AreaFactory;
import io.nanovc.ByteArrayIndex;
import io.nanovc.ClockAPI;
import io.nanovc.ClockBase;
import io.nanovc.ComparisonAPI;
import io.nanovc.ComparisonEngineAPI;
import io.nanovc.ComparisonHandlerAPI;
import io.nanovc.ContentAPI;
import io.nanovc.ContentFactory;
import io.nanovc.DifferenceAPI;
import io.nanovc.DifferenceEngineAPI;
import io.nanovc.DifferenceHandlerAPI;
import io.nanovc.MergeEngineAPI;
import io.nanovc.MergeHandlerAPI;
import io.nanovc.RepoHandlerBase;
import io.nanovc.SearchParametersAPI;
import io.nanovc.SearchQueryDefinitionAPI;
import io.nanovc.TimestampAPI;
import io.nanovc.TimestampBase;
import io.nanovc.areas.StringAreaAPI;
import io.nanovc.comparisons.HashMapComparisonHandler;
import io.nanovc.differences.HashMapDifferenceHandler;
import io.nanovc.memory.MemoryCommitAPI;
import io.nanovc.memory.MemoryRepoAPI;
import io.nanovc.memory.MemoryRepoEngineAPI;
import io.nanovc.memory.MemoryRepoHandlerAPI;
import io.nanovc.memory.MemorySearchQueryAPI;
import io.nanovc.memory.MemorySearchResultsAPI;
import io.nanovc.merges.LastWinsMergeHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public abstract class MemoryRepoHandlerBase<TContent extends ContentAPI, TArea extends AreaAPI<TContent>, TCommit extends MemoryCommitAPI<TCommit>, TSearchQuery extends MemorySearchQueryAPI<TCommit>, TSearchResults extends MemorySearchResultsAPI<TCommit, TSearchQuery>, TRepo extends MemoryRepoAPI<TContent, TArea, TCommit>, TEngine extends MemoryRepoEngineAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo>>
extends RepoHandlerBase<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo, TEngine>
implements MemoryRepoHandlerAPI<TContent, TArea, TCommit, TSearchQuery, TSearchResults, TRepo, TEngine> {
    public ContentFactory<TContent> contentFactory;
    public AreaFactory<TContent, TArea> areaFactory;
    public ByteArrayIndex byteArrayIndex;
    public ClockAPI<? extends TimestampAPI> clock;

    public MemoryRepoHandlerBase(ContentFactory<TContent> contentFactory, AreaFactory<TContent, TArea> areaFactory, TRepo repo, ByteArrayIndex byteArrayIndex, ClockBase<? extends TimestampBase> clock, TEngine repoEngine, DifferenceHandlerAPI<? extends DifferenceEngineAPI> differenceHandler, ComparisonHandlerAPI<? extends ComparisonEngineAPI> comparisonHandler, MergeHandlerAPI<? extends MergeEngineAPI> mergeHandler) {
        super(repo, repoEngine, differenceHandler, comparisonHandler, mergeHandler);
        this.contentFactory = contentFactory;
        this.areaFactory = areaFactory;
        this.byteArrayIndex = byteArrayIndex;
        this.clock = clock;
        this.ensureDependenciesExist();
    }

    private void ensureDependenciesExist() {
        if (this.engine == null) {
            this.engine = this.createDefaultEngine();
        }
        if (this.repo == null) {
            this.repo = ((MemoryRepoEngineAPI)this.engine).createRepo();
        }
        if (this.byteArrayIndex == null) {
            this.byteArrayIndex = ((MemoryRepoEngineAPI)this.engine).createByteArrayIndex();
        }
        if (this.clock == null) {
            this.clock = ((MemoryRepoEngineAPI)this.engine).createClock();
        }
        if (this.differenceHandler == null) {
            this.differenceHandler = new HashMapDifferenceHandler();
        }
        if (this.comparisonHandler == null) {
            this.comparisonHandler = new HashMapComparisonHandler();
        }
        if (this.mergeHandler == null) {
            this.mergeHandler = new LastWinsMergeHandler();
        }
        this.initRepo((MemoryRepoAPI)this.repo);
    }

    public TCommit getCommitForTag(String tagName) {
        return ((MemoryRepoEngineAPI)this.engine).getCommitForTag((MemoryRepoAPI)this.repo, tagName);
    }

    public void removeTag(String tagName) {
        ((MemoryRepoEngineAPI)this.engine).removeTag((MemoryRepoAPI)this.repo, tagName);
    }

    public void tagCommit(TCommit commit, String tagName) {
        ((MemoryRepoEngineAPI)this.engine).tagCommit((MemoryRepoAPI)this.repo, commit, tagName);
    }

    protected void initRepo(TRepo repo) {
    }

    protected abstract TEngine createDefaultEngine();

    public TArea createArea() {
        return ((MemoryRepoEngineAPI)this.engine).createArea(this.areaFactory);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TCommit parentCommit) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, parentCommit);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TCommit firstParentCommit, TCommit ... otherParentCommits) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, firstParentCommit, Arrays.asList(otherParentCommits));
    }

    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, TCommit firstParentCommit, List<TCommit> otherParentCommits) {
        return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, firstParentCommit, otherParentCommits);
    }

    public TCommit commit(TArea contentAreaToCommit, String message, StringAreaAPI commitTags, List<TCommit> parentCommits) {
        if (parentCommits == null) {
            return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
        }
        switch (parentCommits.size()) {
            case 0: {
                return ((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
            }
            case 1: {
                return (TCommit)((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0));
            }
        }
        return (TCommit)((MemoryRepoEngineAPI)this.engine).commit(contentAreaToCommit, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock, (MemoryCommitAPI)parentCommits.get(0), parentCommits.subList(1, parentCommits.size()));
    }

    public TCommit commitToBranch(TArea contentAreaToCommit, String branch, String message, StringAreaAPI commitTags) {
        return ((MemoryRepoEngineAPI)this.engine).commitToBranch(contentAreaToCommit, branch, message, commitTags, (MemoryRepoAPI)this.repo, this.byteArrayIndex, this.clock);
    }

    public void checkoutIntoArea(TCommit commit, TArea areaToUpdate) {
        ((MemoryRepoEngineAPI)this.engine).checkoutIntoArea(commit, (MemoryRepoAPI)this.repo, areaToUpdate, this.contentFactory);
    }

    public TArea checkout(TCommit commit) {
        return ((MemoryRepoEngineAPI)this.engine).checkout(commit, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TCommit getLatestCommitForBranch(String branchName) {
        return ((MemoryRepoEngineAPI)this.engine).getLatestCommitForBranch(branchName, (MemoryRepoAPI)this.repo);
    }

    public DifferenceAPI computeDifferenceBetweenAreas(AreaAPI<? extends TContent> fromArea, AreaAPI<? extends TContent> toArea) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenAreas(fromArea, toArea, (DifferenceHandlerAPI<DifferenceEngineAPI>)this.differenceHandler);
    }

    public DifferenceAPI computeDifferenceBetweenCommits(TCommit fromCommit, TCommit toCommit) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenCommits(fromCommit, toCommit, (DifferenceHandlerAPI<DifferenceEngineAPI>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public DifferenceAPI computeDifferenceBetweenBranches(String fromBranchName, String toBranchName) {
        return ((MemoryRepoEngineAPI)this.engine).computeDifferenceBetweenBranches(fromBranchName, toBranchName, (DifferenceHandlerAPI<DifferenceEngineAPI>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public ComparisonAPI computeComparisonBetweenAreas(AreaAPI<? extends TContent> fromArea, AreaAPI<? extends TContent> toArea) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenAreas(fromArea, toArea, (ComparisonHandlerAPI<ComparisonEngineAPI>)this.comparisonHandler);
    }

    public ComparisonAPI computeComparisonBetweenCommits(TCommit fromCommit, TCommit toCommit) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenCommits(fromCommit, toCommit, (ComparisonHandlerAPI<ComparisonEngineAPI>)this.comparisonHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public ComparisonAPI computeComparisonBetweenBranches(String fromBranchName, String toBranchName) {
        return ((MemoryRepoEngineAPI)this.engine).computeComparisonBetweenBranches(fromBranchName, toBranchName, (ComparisonHandlerAPI<ComparisonEngineAPI>)this.comparisonHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public Set<String> getBranchNames() {
        return ((MemoryRepoEngineAPI)this.engine).getBranchNames((MemoryRepoAPI)this.repo);
    }

    public Set<String> getTagNames() {
        return ((MemoryRepoEngineAPI)this.engine).getTagNames((MemoryRepoAPI)this.repo);
    }

    public TSearchQuery prepareSearchQuery(SearchQueryDefinitionAPI searchQueryDefinition) {
        return ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
    }

    public TSearchResults searchWithQuery(TSearchQuery searchQuery) {
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, null, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults searchWithQuery(TSearchQuery searchQuery, SearchParametersAPI overrideParameters) {
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, overrideParameters, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults search(SearchQueryDefinitionAPI searchQueryDefinition) {
        Object searchQuery = ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, null, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TSearchResults search(SearchQueryDefinitionAPI searchQueryDefinition, SearchParametersAPI overrideParameters) {
        Object searchQuery = ((MemoryRepoEngineAPI)this.engine).prepareSearchQuery(searchQueryDefinition);
        return ((MemoryRepoEngineAPI)this.engine).searchWithQuery(searchQuery, overrideParameters, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory);
    }

    public TCommit mergeIntoBranchFromAnotherBranch(String destinationBranchName, String sourceBranchName, String message, StringAreaAPI commitTags) {
        return ((MemoryRepoEngineAPI)this.engine).mergeIntoBranchFromAnotherBranch(destinationBranchName, sourceBranchName, message, commitTags, (MergeHandlerAPI<MergeEngineAPI>)this.mergeHandler, (ComparisonHandlerAPI<ComparisonEngineAPI>)this.comparisonHandler, (DifferenceHandlerAPI<DifferenceEngineAPI>)this.differenceHandler, (MemoryRepoAPI)this.repo, this.areaFactory, this.contentFactory, this.byteArrayIndex, this.clock);
    }

    public void createBranchAtCommit(TCommit commit, String branchName) {
        ((MemoryRepoEngineAPI)this.engine).createBranchAtCommit(commit, branchName, (MemoryRepoAPI)this.repo);
    }

    public TArea castOrCloneArea(AreaAPI<? extends ContentAPI> areaToCastOrClone) {
        return ((MemoryRepoEngineAPI)this.engine).castOrCloneArea(areaToCastOrClone, this.areaFactory, this.contentFactory, this.byteArrayIndex);
    }
}

